/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.MetaData;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.core.configuration.Password;
import org.eclipse.kura.core.configuration.metatype.Tmetadata;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.util.StringUtil;
import org.eclipse.kura.core.configuration.util.XmlUtil;
import org.eclipse.kura.core.util.IOUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(ComponentUtil.class);

    public static Map<String, OCD> getObjectClassDefinition(BundleContext ctx, Bundle bnd) {
        String[] pids;
        HashMap<String, OCD> bundleDefaults = new HashMap<String, OCD>();
        ServiceReference ref = ctx.getServiceReference(MetaTypeService.class);
        MetaTypeService metaTypeService = (MetaTypeService)ctx.getService(ref);
        MetaTypeInformation mti = metaTypeService.getMetaTypeInformation(bnd);
        if (mti != null && (pids = mti.getPids()) != null) {
            String[] stringArray = pids;
            int n = pids.length;
            int n2 = 0;
            while (n2 < n) {
                String pid = stringArray[n2];
                Tocd ocd = null;
                try {
                    ocd = ComponentUtil.readObjectClassDefinition(bnd, pid);
                    if (ocd != null) {
                        bundleDefaults.put(pid, ocd);
                    }
                }
                catch (Exception e) {
                    s_logger.warn("Error loading OCD for pid " + pid, (Throwable)e);
                }
                ++n2;
            }
        }
        return bundleDefaults;
    }

    public static ObjectClassDefinition getObjectClassDefinition(BundleContext ctx, String pid) {
        ServiceReference ref = ctx.getServiceReference(MetaTypeService.class);
        MetaTypeService metaTypeService = (MetaTypeService)ctx.getService(ref);
        MetaTypeInformation mti = metaTypeService.getMetaTypeInformation(ctx.getBundle());
        ObjectClassDefinition ocd = null;
        try {
            if (mti != null) {
                ocd = mti.getObjectClassDefinition(pid, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return ocd;
    }

    public static OCD readObjectClassDefinition(URL resourceUrl) throws IOException, JAXBException, XMLStreamException, FactoryConfigurationError {
        OCD ocd = null;
        String metatypeXml = IOUtil.readResource((URL)resourceUrl);
        if (metatypeXml != null) {
            MetaData metaData = XmlUtil.unmarshal(metatypeXml, MetaData.class);
            if (metaData.getOCD() != null && metaData.getOCD().size() > 0) {
                ocd = (OCD)metaData.getOCD().get(0);
            } else {
                s_logger.warn("Cannot find OCD for component with url: {}", (Object)resourceUrl.toString());
            }
        }
        return ocd;
    }

    public static Tocd readObjectClassDefinition(String pid) throws IOException, JAXBException, XMLStreamException, FactoryConfigurationError {
        Tocd ocd = null;
        StringBuilder sbMetatypeXmlName = new StringBuilder();
        sbMetatypeXmlName.append("OSGI-INF/metatype/").append(pid).append(".xml");
        String metatypeXmlName = sbMetatypeXmlName.toString();
        String metatypeXml = IOUtil.readResource((String)metatypeXmlName);
        if (metatypeXml != null) {
            Tmetadata metaData = XmlUtil.unmarshal(metatypeXml, Tmetadata.class);
            if (metaData.getOCD() != null && metaData.getOCD().size() > 0) {
                ocd = (Tocd)metaData.getOCD().get(0);
            } else {
                s_logger.warn("Cannot find OCD for component with pid: {}", (Object)pid);
            }
        }
        return ocd;
    }

    public static Tocd readObjectClassDefinition(Bundle bundle, String pid) throws IOException, JAXBException, XMLStreamException, FactoryConfigurationError {
        Tmetadata metaData;
        Tocd ocd = null;
        StringBuilder sbMetatypeXmlName = new StringBuilder();
        sbMetatypeXmlName.append("OSGI-INF/metatype/").append(pid).append(".xml");
        String metatypeXmlName = sbMetatypeXmlName.toString();
        String metatypeXml = IOUtil.readResource((Bundle)bundle, (String)metatypeXmlName);
        if (metatypeXml != null && (metaData = XmlUtil.unmarshal(metatypeXml, Tmetadata.class)).getOCD() != null && metaData.getOCD().size() > 0) {
            ocd = (Tocd)metaData.getOCD().get(0);
        }
        return ocd;
    }

    public static Map<String, Object> getDefaultProperties(OCD ocd) throws KuraException {
        List attrDefs;
        HashMap<String, Object> defaults = null;
        defaults = new HashMap<String, Object>();
        if (ocd != null && (attrDefs = ocd.getAD()) != null) {
            for (AD attrDef : attrDefs) {
                String name = attrDef.getName();
                Object defaultValue = ComponentUtil.getDefaultValue(attrDef);
                if (defaults.get(name) != null || defaultValue == null) continue;
                defaults.put(name, defaultValue);
            }
        }
        return defaults;
    }

    private static Object getDefaultValue(AD attrDef) {
        String defaultValue = attrDef.getDefault();
        if (defaultValue == null || defaultValue.length() == 0) {
            return null;
        }
        Object[] objectValues = null;
        Scalar type = attrDef.getType();
        if (type != null) {
            String[] defaultValues = new String[]{defaultValue};
            int cardinality = attrDef.getCardinality();
            if (cardinality != 0 || cardinality != 1 || cardinality != -1) {
                defaultValues = StringUtil.splitValues(defaultValue);
            }
            objectValues = ComponentUtil.getObjectValue(type, defaultValues);
            if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
                return objectValues[0];
            }
        } else {
            s_logger.warn("Unknown type for attribute {}", (Object)attrDef.getId());
        }
        return objectValues;
    }

    private static Object[] getObjectValue(Scalar type, String[] defaultValues) {
        ArrayList<Object> values = new ArrayList<Object>();
        switch (type) {
            case BOOLEAN: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    values.add(Boolean.valueOf(value));
                    ++n2;
                }
                return values.toArray(new Boolean[0]);
            }
            case BYTE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    values.add(Byte.valueOf(value));
                    ++n3;
                }
                return values.toArray(new Byte[0]);
            }
            case CHAR: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n4 = 0;
                while (n4 < n) {
                    String value = stringArray[n4];
                    values.add(new Character(value.charAt(0)));
                    ++n4;
                }
                return values.toArray(new Character[0]);
            }
            case DOUBLE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n5 = 0;
                while (n5 < n) {
                    String value = stringArray[n5];
                    values.add(Double.valueOf(value));
                    ++n5;
                }
                return values.toArray(new Double[0]);
            }
            case FLOAT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n6 = 0;
                while (n6 < n) {
                    String value = stringArray[n6];
                    values.add(Float.valueOf(value));
                    ++n6;
                }
                return values.toArray(new Float[0]);
            }
            case INTEGER: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n7 = 0;
                while (n7 < n) {
                    String value = stringArray[n7];
                    values.add(Integer.valueOf(value));
                    ++n7;
                }
                return values.toArray(new Integer[0]);
            }
            case LONG: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n8 = 0;
                while (n8 < n) {
                    String value = stringArray[n8];
                    values.add(Long.valueOf(value));
                    ++n8;
                }
                return values.toArray(new Long[0]);
            }
            case SHORT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n9 = 0;
                while (n9 < n) {
                    String value = stringArray[n9];
                    values.add(Short.valueOf(value));
                    ++n9;
                }
                return values.toArray(new Short[0]);
            }
            case PASSWORD: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n10 = 0;
                while (n10 < n) {
                    String value = stringArray[n10];
                    values.add(new Password(value));
                    ++n10;
                }
                return values.toArray(new Password[0]);
            }
            case STRING: {
                return defaultValues;
            }
        }
        return null;
    }
}

