/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.kura.cloud.app.command.KuraCommandRequestPayload;
import org.eclipse.kura.cloud.app.command.KuraCommandResponsePayload;
import org.eclipse.kura.cloud.app.command.ProcessMonitorThread;
import org.eclipse.kura.cloud.app.command.UnZip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuraCommandHandler {
    private static final Logger s_logger = LoggerFactory.getLogger(KuraCommandHandler.class);

    public static void handleRequest(KuraCommandRequestPayload req, KuraCommandResponsePayload resp) {
        byte[] zipBytes;
        String command = req.getCommand();
        if (command == null) {
            s_logger.error("null command");
            resp.setResponseCode(400);
            return;
        }
        String[] args = req.getArguments();
        int argsCount = args != null ? args.length : 0;
        String[] cmdarray = new String[1 + argsCount];
        cmdarray[0] = command;
        int i = 0;
        while (i < argsCount) {
            cmdarray[1 + i] = args[i];
            ++i;
        }
        i = 0;
        while (i < cmdarray.length) {
            s_logger.debug("cmdarray: {}", (Object)cmdarray[i]);
            ++i;
        }
        String[] envp = req.getEnvironmentPairs();
        String dir = req.getWorkingDir();
        if (dir != null && dir.isEmpty()) {
            dir = null;
        }
        if ((zipBytes = req.getZipBytes()) != null) {
            try {
                UnZip.unZipBytes(zipBytes, dir);
            }
            catch (IOException e) {
                s_logger.error("Error unzipping command zip bytes", (Throwable)e);
                resp.setException(e);
                return;
            }
        }
        Runtime rt = Runtime.getRuntime();
        Process proc = null;
        try {
            File fileDir = dir == null ? null : new File(dir);
            proc = rt.exec(cmdarray, envp, fileDir);
        }
        catch (Throwable t) {
            s_logger.error("Error executing command {}", t);
            resp.setResponseCode(500);
            resp.setException(t);
            return;
        }
        ProcessMonitorThread pmt = null;
        boolean runAsync = req.isRunAsync() != null ? req.isRunAsync() : false;
        int timeout = req.getTimeout() != null ? req.getTimeout() : 0;
        pmt = new ProcessMonitorThread(proc, req.getStdin(), timeout);
        pmt.start();
        if (!runAsync) {
            try {
                pmt.join();
                if (pmt.getException() != null) {
                    resp.setResponseCode(500);
                    resp.setException(pmt.getException());
                    resp.setStderr(pmt.getStderr());
                    resp.setStdout(pmt.getStdout());
                } else {
                    resp.setStderr(pmt.getStderr());
                    resp.setStdout(pmt.getStdout());
                    resp.setTimedout(pmt.isTimedOut());
                    if (!pmt.isTimedOut()) {
                        resp.setExitCode(pmt.getExitValue());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                pmt.interrupt();
                resp.setStderr(pmt.getStderr());
                resp.setStdout(pmt.getStdout());
                resp.setTimedout(true);
            }
        }
    }
}

