/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.SliceIterator;
import org.junit.Assert;
import org.junit.Test;

public class IndexIteratorTest {
    @Test
    public void testIterations() {
        int size = 1024;
        this.testIterationsND(size, DoubleDataset.class);
        this.testIterationsND(size, ComplexDoubleDataset.class);
    }

    @Test
    public void testZeroSizedIteration() {
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[2] = 4;
        DoubleDataset ta = DatasetFactory.zeros((int[])nArray);
        IndexIterator it = ta.getIterator();
        Assert.assertFalse((boolean)it.hasNext());
        it = ta.getIterator(true);
        Assert.assertFalse((boolean)it.hasNext());
    }

    private void testIterationsND(int size, Class<? extends Dataset> clazz) {
        TestUtils.verbosePrintf((String)"Size: %d\n", (Object[])new Object[]{size});
        Dataset ta = DatasetFactory.zeros(clazz, (int[])new int[0]);
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0);
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, 8, size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
    }

    private void testDataset(Dataset ta) {
        IndexIterator iter = ta.getIterator();
        double[] data = (double[])ta.getBuffer();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)data[iter.index], (double)(1.0E-5 * (double)i));
            ++i;
        }
        iter.reset();
        i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)data[iter.index], (double)(1.0E-5 * (double)i));
            ++i;
        }
        iter = ta.getIterator(true);
        int[] pos = iter.getPos();
        int i2 = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i2, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        iter.reset();
        i2 = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i2, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
    }

    private Dataset oldSlice(Dataset t, SliceIterator siter) {
        int j;
        int[] shape = siter.getShape();
        int rank = shape.length;
        int[] lstart = siter.getStart();
        int[] lstep = siter.getStep();
        DoubleDataset result = DatasetFactory.zeros((int[])shape);
        int[] relative = new int[rank];
        int[] absolute = new int[rank];
        int i = 0;
        while (i < rank) {
            relative[i] = lstart[i];
            absolute[i] = 0;
            ++i;
        }
        block1: do {
            result.set((Object)t.getDouble(relative), absolute);
            j = rank - 1;
            while (j >= 0) {
                int n = j;
                relative[n] = relative[n] + lstep[j];
                int n2 = j;
                absolute[n2] = absolute[n2] + 1;
                if (absolute[j] < shape[j]) continue block1;
                relative[j] = lstart[j];
                absolute[j] = 0;
                --j;
            }
        } while (j != -1);
        return result;
    }

    private void testSlicedDataset(Dataset t, int start, int startaxis, int step, int stepaxis) {
        long stime;
        int rank = t.getRank();
        int[] steps = new int[rank];
        int[] starts = new int[rank];
        Arrays.fill(steps, 1);
        while (stepaxis > rank) {
            stepaxis -= rank;
        }
        if (stepaxis < 0) {
            stepaxis += rank;
        }
        steps[stepaxis] = step;
        while (startaxis > rank) {
            startaxis -= rank;
        }
        if (startaxis < 0) {
            startaxis += rank;
        }
        starts[startaxis] = start;
        int nloop = 7;
        ArrayList<Long> elapsed = new ArrayList<Long>();
        Dataset sliced = null;
        SliceIterator siter = (SliceIterator)t.getSliceIterator(starts, null, steps);
        elapsed.clear();
        int i = 0;
        while (i < nloop) {
            stime = System.nanoTime();
            sliced = this.oldSlice(t, siter);
            elapsed.add(System.nanoTime() - stime);
            ++i;
        }
        Collections.sort(elapsed);
        double[] sdata = (double[])sliced.getBuffer();
        Dataset nsliced = null;
        elapsed.clear();
        int i2 = 0;
        while (i2 < nloop) {
            stime = System.nanoTime();
            nsliced = t.getSlice(starts, null, steps);
            elapsed.add(System.nanoTime() - stime);
            ++i2;
        }
        Collections.sort(elapsed);
        double[] ndata = (double[])nsliced.getBuffer();
        IndexIterator iter = nsliced.getIterator();
        int i3 = 0;
        while (i3 < sdata.length && iter.hasNext()) {
            Assert.assertEquals((double)sdata[i3], (double)ndata[iter.index], (double)(1.0E-5 * sdata[i3]));
            ++i3;
        }
    }

    @Test
    public void testSliceIteration() {
        int size = 60;
        this.testSliceIterationND(size, DoubleDataset.class);
        this.testSliceIterationND(size, ComplexDoubleDataset.class);
    }

    private void testSliceIterationND(int size, Class<? extends Dataset> clazz) {
        System.out.println(" Size: " + size);
        Dataset ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0);
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 62, 0);
        this.testSlicedDataset(ta, 23, 0, 3, 0);
        this.testSlicedDataset(ta, 23, 0, 62, 0);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 15, 15});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 3, 1);
        this.testSlicedDataset(ta, 2, 0, 3, 0);
        this.testSlicedDataset(ta, 2, 0, 3, 1);
        this.testSlicedDataset(ta, 3, 1, 3, 0);
        this.testSlicedDataset(ta, 3, 1, 3, 1);
        this.testSlicedDataset(ta, 0, 0, 4, 0);
        this.testSlicedDataset(ta, 0, 0, 4, 1);
        this.testSlicedDataset(ta, 2, 0, 4, 0);
        this.testSlicedDataset(ta, 2, 0, 4, 1);
        this.testSlicedDataset(ta, 3, 1, 4, 0);
        this.testSlicedDataset(ta, 3, 1, 4, 1);
        this.testSlicedDataset(ta, 0, 0, -1, 0);
        this.testSlicedDataset(ta, 0, 0, -1, 1);
        this.testSlicedDataset(ta, 2, 0, -1, 0);
        this.testSlicedDataset(ta, 2, 0, -1, 1);
        this.testSlicedDataset(ta, 3, 1, -1, 0);
        this.testSlicedDataset(ta, 3, 1, -1, 1);
        this.testSlicedDataset(ta, 0, 0, -2, 0);
        this.testSlicedDataset(ta, 0, 0, -2, 1);
        this.testSlicedDataset(ta, 2, 0, -2, 0);
        this.testSlicedDataset(ta, 2, 0, -2, 1);
        this.testSlicedDataset(ta, 3, 1, -2, 0);
        this.testSlicedDataset(ta, 3, 1, -2, 1);
        this.testSlicedDataset(ta, 0, 0, -3, 0);
        this.testSlicedDataset(ta, 0, 0, -3, 1);
        this.testSlicedDataset(ta, 2, 0, -3, 0);
        this.testSlicedDataset(ta, 2, 0, -3, 1);
        this.testSlicedDataset(ta, 3, 1, -3, 0);
        this.testSlicedDataset(ta, 3, 1, -3, 1);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 10, 2, 5});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 3, 1);
        this.testSlicedDataset(ta, 0, 0, 3, 2);
        this.testSlicedDataset(ta, 3, 0, 3, 0);
        this.testSlicedDataset(ta, 3, 0, 3, 1);
        this.testSlicedDataset(ta, 3, 0, 3, 2);
        this.testSlicedDataset(ta, 1, 1, 3, 0);
        this.testSlicedDataset(ta, 1, 1, 3, 1);
        this.testSlicedDataset(ta, 1, 1, 3, 2);
        this.testSlicedDataset(ta, 2, 2, 3, 0);
        this.testSlicedDataset(ta, 2, 2, 3, 1);
        this.testSlicedDataset(ta, 2, 2, 3, 2);
        this.testSlicedDataset(ta, 0, 0, 4, 0);
        this.testSlicedDataset(ta, 0, 0, 4, 1);
        this.testSlicedDataset(ta, 0, 0, 4, 2);
        this.testSlicedDataset(ta, 3, 0, 4, 0);
        this.testSlicedDataset(ta, 3, 0, 4, 1);
        this.testSlicedDataset(ta, 3, 0, 4, 2);
        this.testSlicedDataset(ta, 1, 1, 4, 0);
        this.testSlicedDataset(ta, 1, 1, 4, 1);
        this.testSlicedDataset(ta, 1, 1, 4, 2);
        this.testSlicedDataset(ta, 2, 2, 4, 0);
        this.testSlicedDataset(ta, 2, 2, 4, 1);
        this.testSlicedDataset(ta, 2, 2, 4, 2);
        this.testSlicedDataset(ta, 0, 0, -1, 0);
        this.testSlicedDataset(ta, 0, 0, -1, 1);
        this.testSlicedDataset(ta, 0, 0, -1, 2);
        this.testSlicedDataset(ta, 3, 0, -1, 0);
        this.testSlicedDataset(ta, 3, 0, -1, 1);
        this.testSlicedDataset(ta, 3, 0, -1, 2);
        this.testSlicedDataset(ta, 1, 1, -1, 0);
        this.testSlicedDataset(ta, 1, 1, -1, 1);
        this.testSlicedDataset(ta, 1, 1, -1, 2);
        this.testSlicedDataset(ta, 2, 2, -1, 0);
        this.testSlicedDataset(ta, 2, 2, -1, 1);
        this.testSlicedDataset(ta, 2, 2, -1, 2);
        this.testSlicedDataset(ta, 0, 0, -2, 0);
        this.testSlicedDataset(ta, 0, 0, -2, 1);
        this.testSlicedDataset(ta, 0, 0, -2, 2);
        this.testSlicedDataset(ta, 3, 0, -2, 0);
        this.testSlicedDataset(ta, 3, 0, -2, 1);
        this.testSlicedDataset(ta, 3, 0, -2, 2);
        this.testSlicedDataset(ta, 1, 1, -2, 0);
        this.testSlicedDataset(ta, 1, 1, -2, 1);
        this.testSlicedDataset(ta, 1, 1, -2, 2);
        this.testSlicedDataset(ta, 2, 2, -2, 0);
        this.testSlicedDataset(ta, 2, 2, -2, 1);
        this.testSlicedDataset(ta, 2, 2, -2, 2);
        this.testSlicedDataset(ta, 0, 0, -3, 0);
        this.testSlicedDataset(ta, 0, 0, -3, 1);
        this.testSlicedDataset(ta, 0, 0, -3, 2);
        this.testSlicedDataset(ta, 3, 0, -3, 0);
        this.testSlicedDataset(ta, 3, 0, -3, 1);
        this.testSlicedDataset(ta, 3, 0, -3, 2);
        this.testSlicedDataset(ta, 1, 1, -3, 0);
        this.testSlicedDataset(ta, 1, 1, -3, 1);
        this.testSlicedDataset(ta, 1, 1, -3, 2);
        this.testSlicedDataset(ta, 2, 2, -3, 0);
        this.testSlicedDataset(ta, 2, 2, -3, 1);
        this.testSlicedDataset(ta, 2, 2, -3, 2);
    }
}

