/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.InterpolatedPoint;
import org.eclipse.january.dataset.Maths;

public class InterpolatorUtils {
    public static Dataset regridOld(Dataset data, Dataset x, Dataset y, Dataset gridX, Dataset gridY) throws Exception {
        DoubleDataset result = DatasetFactory.zeros(DoubleDataset.class, gridX.getShapeRef()[0], gridY.getShapeRef()[0]);
        IndexIterator itx = gridX.getIterator();
        ArrayList pointList = new ArrayList();
        while (itx.hasNext()) {
            pointList.add(new ArrayList());
            int xindex = itx.index;
            double xPos = gridX.getDouble(xindex);
            IndexIterator ity = gridY.getIterator();
            while (ity.hasNext()) {
                int yindex = ity.index;
                System.out.println("Testing : " + xindex + "," + yindex);
                double yPos = gridX.getDouble(yindex);
                result.set((Object)InterpolatorUtils.getInterpolated(data, x, y, xPos, yPos), yindex, xindex);
            }
        }
        return result;
    }

    public static Dataset selectDatasetRegion(Dataset dataset, int x, int y, int xSize, int ySize) {
        int startX = x - xSize;
        int startY = y - ySize;
        int endX = x + xSize + 1;
        int endY = y + ySize + 1;
        int shapeX = dataset.getShapeRef()[0];
        int shapeY = dataset.getShapeRef()[1];
        if (startX < 0) {
            startX = 0;
            endX = 3;
        }
        if (endX > shapeX) {
            endX = shapeX;
            startX = endX - 3;
        }
        if (startY < 0) {
            startY = 0;
            endY = 3;
        }
        if (endY > shapeY) {
            endY = shapeY;
            startY = endY - 3;
        }
        int[] start = new int[]{startX, startY};
        int[] stop = new int[]{endX, endY};
        return dataset.getSlice(start, stop, null);
    }

    private static double getInterpolated(Dataset val, Dataset x, Dataset y, double xPos, double yPos) throws Exception {
        Dataset xPosDS = x.getSlice(new int[2], new int[]{x.getShapeRef()[0], 1}, null).isubtract(xPos);
        int xPosMin = xPosDS.minPos()[0];
        int[] nArray = new int[2];
        nArray[0] = xPosMin;
        Dataset yPosDS = y.getSlice(nArray, new int[]{xPosMin + 1, y.getShapeRef()[1]}, null).isubtract(yPos);
        int yPosMin = yPosDS.minPos()[0];
        Dataset xClipped = InterpolatorUtils.selectDatasetRegion(x, xPosMin, yPosMin, 2, 2);
        Dataset yClipped = InterpolatorUtils.selectDatasetRegion(y, xPosMin, yPosMin, 2, 2);
        Dataset xSquare = Maths.subtract(xClipped, xPos).ipower(2);
        Dataset ySquare = Maths.subtract(yClipped, yPos).ipower(2);
        Dataset total = Maths.add(xSquare, ySquare);
        int[] pos = total.minPos();
        Dataset xReduced = InterpolatorUtils.selectDatasetRegion(x, pos[0], pos[1], 1, 1);
        Dataset yReduced = InterpolatorUtils.selectDatasetRegion(y, pos[0], pos[1], 1, 1);
        Dataset valReduced = InterpolatorUtils.selectDatasetRegion(val, pos[0], pos[1], 1, 1);
        return InterpolatorUtils.getInterpolatedResultFromNinePoints(valReduced, xReduced, yReduced, xPos, yPos);
    }

    private static double getInterpolatedResultFromNinePoints(Dataset val, Dataset x, Dataset y, double xPos, double yPos) throws Exception {
        InterpolatedPoint p00 = InterpolatorUtils.makePoint(x, y, 0, 0);
        InterpolatedPoint p01 = InterpolatorUtils.makePoint(x, y, 0, 1);
        InterpolatedPoint p02 = InterpolatorUtils.makePoint(x, y, 0, 2);
        InterpolatedPoint p10 = InterpolatorUtils.makePoint(x, y, 1, 0);
        InterpolatedPoint p11 = InterpolatorUtils.makePoint(x, y, 1, 1);
        InterpolatedPoint p12 = InterpolatorUtils.makePoint(x, y, 1, 2);
        InterpolatedPoint p20 = InterpolatorUtils.makePoint(x, y, 2, 0);
        InterpolatedPoint p21 = InterpolatorUtils.makePoint(x, y, 2, 1);
        InterpolatedPoint p22 = InterpolatorUtils.makePoint(x, y, 2, 2);
        ArrayList<InterpolatedPoint> points = new ArrayList<InterpolatedPoint>();
        InterpolatedPoint A = InterpolatorUtils.get1DInterpolatedPoint(p00, p10, 0, xPos);
        InterpolatedPoint B = InterpolatorUtils.get1DInterpolatedPoint(p10, p20, 0, xPos);
        InterpolatedPoint C = InterpolatorUtils.get1DInterpolatedPoint(p00, p01, 0, xPos);
        InterpolatedPoint D = InterpolatorUtils.get1DInterpolatedPoint(p10, p11, 0, xPos);
        InterpolatedPoint E = InterpolatorUtils.get1DInterpolatedPoint(p20, p21, 0, xPos);
        InterpolatedPoint F = InterpolatorUtils.get1DInterpolatedPoint(p01, p11, 0, xPos);
        InterpolatedPoint G = InterpolatorUtils.get1DInterpolatedPoint(p11, p21, 0, xPos);
        InterpolatedPoint H = InterpolatorUtils.get1DInterpolatedPoint(p01, p02, 0, xPos);
        InterpolatedPoint I = InterpolatorUtils.get1DInterpolatedPoint(p11, p12, 0, xPos);
        InterpolatedPoint J = InterpolatorUtils.get1DInterpolatedPoint(p21, p22, 0, xPos);
        InterpolatedPoint K = InterpolatorUtils.get1DInterpolatedPoint(p02, p12, 0, xPos);
        InterpolatedPoint L = InterpolatorUtils.get1DInterpolatedPoint(p12, p22, 0, xPos);
        if (A != null) {
            points.add(A);
        }
        if (B != null) {
            points.add(B);
        }
        if (C != null) {
            points.add(C);
        }
        if (D != null) {
            points.add(D);
        }
        if (E != null) {
            points.add(E);
        }
        if (F != null) {
            points.add(F);
        }
        if (G != null) {
            points.add(G);
        }
        if (H != null) {
            points.add(H);
        }
        if (I != null) {
            points.add(I);
        }
        if (J != null) {
            points.add(J);
        }
        if (K != null) {
            points.add(K);
        }
        if (L != null) {
            points.add(L);
        }
        if (points.size() == 0) {
            return Double.NaN;
        }
        InterpolatedPoint bestPoint = null;
        Collections.sort(points, new Comparator<InterpolatedPoint>(){

            @Override
            public int compare(InterpolatedPoint o1, InterpolatedPoint o2) {
                return (int)Math.signum(o1.realPoint.getDouble(1) - o2.realPoint.getDouble(1));
            }
        });
        int a = 1;
        while (a < points.size()) {
            InterpolatedPoint testPoint = InterpolatorUtils.get1DInterpolatedPoint((InterpolatedPoint)points.get(a - 1), (InterpolatedPoint)points.get(a), 1, yPos);
            if (testPoint != null) {
                bestPoint = testPoint;
                break;
            }
            ++a;
        }
        if (bestPoint == null) {
            return Double.NaN;
        }
        int xs = (int)Math.floor(bestPoint.getCoordPoint().getDouble(0));
        int ys = (int)Math.floor(bestPoint.getCoordPoint().getDouble(1));
        double xoff = bestPoint.getCoordPoint().getDouble(0) - (double)xs;
        double yoff = bestPoint.getCoordPoint().getDouble(1) - (double)ys;
        if (xs == 2) {
            xs = 1;
            xoff = 1.0;
        }
        if (ys == 2) {
            ys = 1;
            yoff = 1.0;
        }
        double w00 = (1.0 - xoff) * (1.0 - yoff);
        double w10 = xoff * (1.0 - yoff);
        double w01 = (1.0 - xoff) * yoff;
        double w11 = xoff * yoff;
        double result = val.getDouble(xs, ys) * w00;
        result += val.getDouble(xs + 1, ys) * w10;
        result += val.getDouble(xs, ys + 1) * w01;
        return result += val.getDouble(xs + 1, ys + 1) * w11;
    }

    private static InterpolatedPoint makePoint(Dataset x, Dataset y, int i, int j) {
        Dataset realPoint = DatasetFactory.createFromObject(new double[]{x.getDouble(i, j), y.getDouble(i, j)});
        Dataset coordPoint = DatasetFactory.createFromObject(new double[]{i, j});
        return new InterpolatedPoint(realPoint, coordPoint);
    }

    private static InterpolatedPoint get1DInterpolatedPoint(InterpolatedPoint p1, InterpolatedPoint p2, int interpolationDimension, double interpolatedValue) throws IllegalArgumentException {
        InterpolatorUtils.checkPoints(p1, p2);
        if (interpolationDimension >= p1.getRealPoint().getShapeRef()[0]) {
            throw new IllegalArgumentException("Dimention is too large for these datasets");
        }
        double p1_n = p1.getRealPoint().getDouble(interpolationDimension);
        double p2_n = p2.getRealPoint().getDouble(interpolationDimension);
        double max = Math.max(p1_n, p2_n);
        double min = Math.min(p1_n, p2_n);
        if (interpolatedValue < min || interpolatedValue > max || min == max) {
            return null;
        }
        double proportion = (interpolatedValue - min) / (max - min);
        return InterpolatorUtils.getInterpolatedPoint(p1, p2, proportion);
    }

    private static InterpolatedPoint getInterpolatedPoint(InterpolatedPoint p1, InterpolatedPoint p2, double proportion) {
        InterpolatorUtils.checkPoints(p1, p2);
        if (proportion < 0.0 || proportion > 1.0) {
            throw new IllegalArgumentException("Proportion must be between 0 and 1");
        }
        Dataset p1RealContribution = Maths.multiply(p1.getRealPoint(), 1.0 - proportion);
        Dataset p2RealContribution = Maths.multiply(p2.getRealPoint(), proportion);
        Dataset realPoint = Maths.add(p1RealContribution, p2RealContribution);
        Dataset p1CoordContribution = Maths.multiply(p1.getCoordPoint(), 1.0 - proportion);
        Dataset p2CoordContribution = Maths.multiply(p2.getCoordPoint(), proportion);
        Dataset coordPoint = Maths.add(p1CoordContribution, p2CoordContribution);
        return new InterpolatedPoint(realPoint, coordPoint);
    }

    private static void checkPoints(InterpolatedPoint p1, InterpolatedPoint p2) throws IllegalArgumentException {
        if (!p1.getCoordPoint().isCompatibleWith(p2.getCoordPoint())) {
            throw new IllegalArgumentException("Datasets do not match");
        }
    }

    private static Dataset getTrimmedAxis(Dataset axis, int axisIndex, InterpolatedPoint p1, InterpolatedPoint p2) {
        double endPoint;
        double startPoint = p1.getRealPoint().getDouble(axisIndex);
        if (startPoint > (endPoint = p2.getRealPoint().getDouble(axisIndex))) {
            startPoint = p2.getRealPoint().getDouble(axisIndex);
            endPoint = p1.getRealPoint().getDouble(axisIndex);
        }
        int start = InterpolatorUtils.getTrimmedAxisStart(axis, startPoint);
        int end = InterpolatorUtils.getTrimmedAxisEnd(axis, start, endPoint);
        return axis.getSlice(new int[]{start}, new int[]{end}, null);
    }

    private static int getTrimmedAxisStart(Dataset axis, double startPoint) {
        int i = 0;
        while (i < axis.getShapeRef()[0]) {
            if (axis.getDouble(i) > startPoint) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int getTrimmedAxisEnd(Dataset axis, int startPos, double endPoint) {
        int i = startPos;
        while (i < axis.getShapeRef()[0]) {
            if (axis.getDouble(i) > endPoint) {
                return i - 1;
            }
            ++i;
        }
        return axis.getShapeRef()[0];
    }

    public static Dataset remap1D(Dataset dataset, Dataset axis, Dataset outputAxis) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, outputAxis.getShapeRef());
        int i = 0;
        while (i < outputAxis.getShapeRef()[0]) {
            double point = outputAxis.getDouble(i);
            double position = InterpolatorUtils.getRealPositionAsIndex(axis, point);
            if (position >= 0.0) {
                data.set((Object)Maths.interpolate(dataset, position), i);
            } else {
                data.set((Object)Double.NaN, i);
            }
            ++i;
        }
        return data;
    }

    private static double getRealPositionAsIndex(Dataset dataset, double point) {
        int j = 0;
        while (j < dataset.getShapeRef()[0] - 1) {
            double end = dataset.getDouble(j + 1);
            double start = dataset.getDouble(j);
            if (start < end) {
                if (end > point && start <= point) {
                    double proportion = (point - start) / (end - start);
                    return (double)j + proportion;
                }
            } else if (end < point && start >= point) {
                double proportion = (point - start) / (end - start);
                return (double)j + proportion;
            }
            ++j;
        }
        return -1.0;
    }

    public static Dataset remapOneAxis(Dataset dataset, int axisIndex, Dataset corrections, Dataset originalAxisForCorrection, Dataset outputAxis) {
        int[] stop = dataset.getShape();
        int[] start = new int[stop.length];
        int[] step = new int[stop.length];
        int[] resultSize = new int[stop.length];
        int i = 0;
        while (i < start.length) {
            start[i] = 0;
            step[i] = 1;
            resultSize[i] = stop[i];
            ++i;
        }
        resultSize[axisIndex] = outputAxis.getShapeRef()[0];
        DoubleDataset result = DatasetFactory.zeros(DoubleDataset.class, resultSize);
        step[axisIndex] = dataset.getShapeRef()[axisIndex];
        IndexIterator iter = dataset.getSliceIterator(start, stop, step);
        int[] pos = iter.getPos();
        int[] posEnd = new int[pos.length];
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < posEnd.length) {
                posEnd[i2] = pos[i2] + 1;
                ++i2;
            }
            posEnd[axisIndex] = stop[axisIndex];
            Dataset slice = dataset.getSlice(pos, posEnd, null).squeeze();
            int[] correctionPos = new int[pos.length - 1];
            int index = 0;
            int j = 0;
            while (j < pos.length) {
                if (j != axisIndex) {
                    correctionPos[index] = pos[j];
                    ++index;
                }
                ++j;
            }
            Dataset axis = Maths.subtract(originalAxisForCorrection, corrections.getDouble(correctionPos));
            Dataset remapped = InterpolatorUtils.remap1D(slice, axis, outputAxis);
            int[] ref = ArrayUtils.clone((int[])pos);
            int k = 0;
            while (k < result.getShapeRef()[axisIndex]) {
                ref[axisIndex] = k;
                result.set((Object)remapped.getDouble(k), ref);
                ++k;
            }
        }
        return result;
    }

    public static Dataset remapAxis(Dataset dataset, int axisIndex, Dataset originalAxisForCorrection, Dataset outputAxis) {
        if (!dataset.isCompatibleWith(originalAxisForCorrection)) {
            throw new IllegalArgumentException("Datasets must be of the same shape");
        }
        int[] stop = dataset.getShapeRef();
        int[] start = new int[stop.length];
        int[] step = new int[stop.length];
        int[] resultSize = new int[stop.length];
        int i = 0;
        while (i < start.length) {
            start[i] = 0;
            step[i] = 1;
            resultSize[i] = stop[i];
            ++i;
        }
        resultSize[axisIndex] = outputAxis.getShapeRef()[0];
        DoubleDataset result = DatasetFactory.zeros(DoubleDataset.class, resultSize);
        step[axisIndex] = dataset.getShapeRef()[axisIndex];
        IndexIterator iter = dataset.getSliceIterator(start, stop, step);
        int[] pos = iter.getPos();
        int[] posEnd = new int[pos.length];
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < posEnd.length) {
                posEnd[i2] = pos[i2] + 1;
                ++i2;
            }
            posEnd[axisIndex] = stop[axisIndex];
            Dataset slice = dataset.getSlice(pos, posEnd, null).squeeze();
            Dataset axis = originalAxisForCorrection.getSlice(pos, posEnd, null).squeeze();
            Dataset remapped = InterpolatorUtils.remap1D(slice, axis, outputAxis);
            int[] ref = ArrayUtils.clone((int[])pos);
            int k = 0;
            while (k < result.shape[axisIndex]) {
                ref[axisIndex] = k;
                result.set((Object)remapped.getDouble(k), ref);
                ++k;
            }
        }
        return result;
    }

    public static Dataset regrid(Dataset data, Dataset x, Dataset y, Dataset gridX, Dataset gridY) {
        Dataset result = InterpolatorUtils.remapAxis(data, 1, x, gridX);
        result = InterpolatorUtils.remapAxis(result, 0, y, gridY);
        return result;
    }
}

