/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form.emf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.util.XMLProcessor;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.TreeComposite;
import org.eclipse.january.form.emf.EMFTreeComposite;
import org.xml.sax.SAXException;

@XmlRootElement(name="EMFComponent")
public class EMFComponent
extends ICEObject
implements Component {
    @XmlElement(name="EMFTreeComposite")
    private EMFTreeComposite iceEMFTree = new EMFTreeComposite();
    @XmlTransient
    private XMLProcessor xmlProcessor;
    @XmlTransient
    private XMLResource xmlResource = new XMLResourceImpl();

    public EMFComponent() {
    }

    public EMFComponent(File file) {
        if (file != null) {
            try {
                this.xmlProcessor = new XMLProcessor(URI.createFileURI((String)file.getAbsolutePath()));
            }
            catch (SAXException e) {
                this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
            }
            if (this.xmlProcessor != null) {
                EPackage ePackage = (EPackage)this.xmlProcessor.getEPackageRegistry().values().toArray()[0];
                TreeIterator tree = ePackage.eAllContents();
                while (tree.hasNext()) {
                    EClass eClass;
                    EObject obj = (EObject)tree.next();
                    if (!(obj instanceof EClass) || !"DocumentRoot".equals((eClass = (EClass)obj).getName())) continue;
                    this.iceEMFTree = new EMFTreeComposite(eClass);
                    break;
                }
            }
        }
    }

    public TreeComposite getEMFTreeComposite() {
        return this.iceEMFTree;
    }

    public boolean save(File saveFile) {
        block4: {
            boolean created = false;
            FileOutputStream outputStream = null;
            try {
                if (saveFile.exists()) {
                    saveFile.delete();
                }
                if (!(created = saveFile.createNewFile())) break block4;
                outputStream = new FileOutputStream(saveFile);
                this.xmlResource.getContents().clear();
                this.xmlResource.getContents().add((Object)this.iceEMFTree.getEcoreNode());
                this.xmlProcessor.save((OutputStream)outputStream, (Resource)this.xmlResource, null);
                outputStream.close();
                return true;
            }
            catch (IOException e) {
                this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
                return false;
            }
        }
        this.logger.info("[EMFComponent] Could not create save file.");
        return false;
    }

    public boolean load(File schema, File file) {
        try {
            this.xmlProcessor = new XMLProcessor(URI.createFileURI((String)schema.getAbsolutePath()));
        }
        catch (SAXException e) {
            this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
            return false;
        }
        return this.load(file);
    }

    public boolean load(File file) {
        EObject documentRoot = null;
        if (this.xmlProcessor != null) {
            try {
                this.xmlResource = (XMLResource)this.xmlProcessor.load((InputStream)new FileInputStream(file), null);
            }
            catch (IOException e) {
                this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
                return false;
            }
        }
        if (this.xmlResource == null || this.xmlResource.getContents().size() <= 0) {
            this.logger.error("EMFComponent Error: Could not find document root for " + file.getAbsolutePath());
            return false;
        }
        documentRoot = (EObject)this.xmlResource.getContents().get(0);
        if (documentRoot != null) {
            int id = 1;
            this.iceEMFTree = new EMFTreeComposite(documentRoot);
            this.iceEMFTree.setId(id);
            HashMap<EObject, EMFTreeComposite> map = new HashMap<EObject, EMFTreeComposite>();
            map.put(documentRoot, this.iceEMFTree);
            TreeIterator tree = documentRoot.eAllContents();
            EObject obj = null;
            EMFTreeComposite tempTree = null;
            while (tree.hasNext()) {
                obj = (EObject)tree.next();
                tempTree = new EMFTreeComposite(obj);
                tempTree.setId(++id);
                map.put(obj, tempTree);
            }
            for (EObject o : map.keySet()) {
                EObject parent = o.eContainer();
                if (parent == null) continue;
                ((EMFTreeComposite)map.get(parent)).setNextChild((TreeComposite)map.get(o));
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object otherEMFComponent) {
        if (this == otherEMFComponent) {
            return true;
        }
        if (otherEMFComponent == null || !(otherEMFComponent instanceof EMFComponent) || !super.equals(otherEMFComponent)) {
            return false;
        }
        EMFComponent castedComponent = (EMFComponent)otherEMFComponent;
        if (!castedComponent.iceEMFTree.equals(this.iceEMFTree)) {
            this.logger.info("TREES NOT EQUAL");
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 9;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.iceEMFTree.hashCode();
        return hash;
    }

    public void copy(EMFComponent otherEMFComponent) {
        if (otherEMFComponent != null) {
            super.copy(otherEMFComponent);
            this.iceEMFTree.copy(otherEMFComponent.iceEMFTree);
            this.notifyListeners();
        }
    }

    @Override
    public Object clone() {
        EMFComponent emfComponent = new EMFComponent();
        if (this.iceEMFTree.getEcoreMetaData() != null) {
            emfComponent.iceEMFTree.setECoreNodeMetaData(this.iceEMFTree.getEcoreMetaData());
        }
        emfComponent.copy(this);
        return emfComponent;
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }

    public boolean save() {
        if (this.iceEMFTree.getEcoreNode() != null) {
            this.xmlResource.getContents().add((Object)this.iceEMFTree.getEcoreNode());
            try {
                this.xmlProcessor.save((OutputStream)System.out, (Resource)this.xmlResource, null);
            }
            catch (IOException e) {
                this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
                return false;
            }
            return true;
        }
        return true;
    }

    public String saveToString() {
        String retString = null;
        try {
            retString = this.xmlProcessor.saveToString((Resource)this.xmlResource, null);
        }
        catch (IOException e) {
            this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
            return null;
        }
        return retString;
    }
}

