/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.xtext.mtlimport;

import com.google.inject.Injector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.january.geometry.xtext.MTLStandaloneSetup;
import org.eclipse.january.geometry.xtext.mTL.Material;
import org.eclipse.january.geometry.xtext.mTL.MaterialSource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class MTLImporter {
    public ArrayList<Material> load(Path path) {
        Injector injector = new MTLStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(URI.createFileURI((String)path.toFile().getAbsolutePath()), true);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Importing Geometry File", (String)"Error while importing material file(s).", (IStatus)new Status(4, "org.eclipse.january.geometry.xtext", e.getMessage()));
        }
        EList contents = resource.getContents();
        ArrayList<Material> materials = null;
        if (!contents.isEmpty() && contents.get(0) instanceof MaterialSource) {
            MaterialSource source = (MaterialSource)contents.get(0);
            materials = new ArrayList<Material>();
            materials.addAll((Collection<Material>)source.getMaterials());
        }
        return materials;
    }
}

