/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.january.geometry.BoundingBox;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Junction;
import org.eclipse.january.geometry.Pipe;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class JunctionImpl
extends ShapeImpl
implements Junction {
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected double height = 0.0;
    protected static final double ZIN_EDEFAULT = 0.0;
    protected double zIn = 0.0;
    protected static final double ZOUT_EDEFAULT = 0.0;
    protected double zOut = 0.0;
    protected EList<Pipe> input = new BasicEList();
    protected EList<Pipe> output = new BasicEList();

    protected JunctionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.JUNCTION;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double newHeight) {
        if (newHeight != this.height) {
            double oldHeight = this.height;
            this.height = newHeight;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldHeight, this.height));
            }
        }
    }

    @Override
    public double getZIn() {
        return this.zIn;
    }

    @Override
    public void setZIn(double newZIn) {
        if (newZIn != this.zIn) {
            double oldZIn = this.zIn;
            this.zIn = newZIn;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldZIn, this.zIn));
            }
        }
    }

    @Override
    public double getZOut() {
        return this.zOut;
    }

    @Override
    public void setZOut(double newZOut) {
        if (newZOut != this.zOut) {
            double oldZOut = this.zOut;
            this.zOut = newZOut;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldZOut, this.zOut));
            }
        }
    }

    @Override
    public EList<Pipe> getInput() {
        if (this.input == null) {
            this.input = new EObjectContainmentEList(Pipe.class, (InternalEObject)this, 11);
        }
        return this.input;
    }

    @Override
    public EList<Pipe> getOutput() {
        if (this.output == null) {
            this.output = new EObjectContainmentEList(Pipe.class, (InternalEObject)this, 12);
        }
        return this.output;
    }

    @Override
    public EList<Triangle> getTriangles() {
        BoundingBox box;
        this.triangles = new BasicEList();
        if (!this.input.isEmpty()) {
            box = ((Pipe)this.input.get(0)).getLowerEdge();
        } else if (!this.output.isEmpty()) {
            box = ((Pipe)this.output.get(0)).getUpperEdge();
        } else {
            return this.triangles;
        }
        for (Pipe pipe : this.input) {
            box.addArea(pipe.getLowerEdge());
        }
        for (Pipe pipe : this.output) {
            box.addArea(pipe.getUpperEdge());
        }
        double lengthX = Math.max(box.getMaxX() - box.getMinX() + 1.0, 1.0);
        double lengthY = Math.max(box.getMaxY() - box.getMinY() + 1.0, 1.0);
        double lengthZ = Math.max(box.getMaxZ() - box.getMinZ() + 1.0, 1.0);
        double[] points = MeshUtils.createRectangularPrism(lengthX, lengthY, lengthZ);
        this.triangles = MeshUtils.createRectangularPrismMesh(points);
        this.center.setX((box.getMaxX() - box.getMinX()) / 2.0 + box.getMinX());
        this.center.setY((box.getMaxY() - box.getMinY()) / 2.0 + box.getMinY());
        this.center.setZ((box.getMaxZ() - box.getMinZ()) / 2.0 + box.getMinZ());
        return this.triangles;
    }

    @Override
    public Object clone() {
        Junction clone = GeometryFactory.eINSTANCE.createJunction();
        clone.copy(this);
        return clone;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getInput()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getOutput()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getHeight();
            }
            case 9: {
                return this.getZIn();
            }
            case 10: {
                return this.getZOut();
            }
            case 11: {
                return this.getInput();
            }
            case 12: {
                return this.getOutput();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setHeight((Double)newValue);
                return;
            }
            case 9: {
                this.setZIn((Double)newValue);
                return;
            }
            case 10: {
                this.setZOut((Double)newValue);
                return;
            }
            case 11: {
                this.getInput().clear();
                this.getInput().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getOutput().clear();
                this.getOutput().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setHeight(0.0);
                return;
            }
            case 9: {
                this.setZIn(0.0);
                return;
            }
            case 10: {
                this.setZOut(0.0);
                return;
            }
            case 11: {
                this.getInput().clear();
                return;
            }
            case 12: {
                this.getOutput().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.height != 0.0;
            }
            case 9: {
                return this.zIn != 0.0;
            }
            case 10: {
                return this.zOut != 0.0;
            }
            case 11: {
                return this.input != null && !this.input.isEmpty();
            }
            case 12: {
                return this.output != null && !this.output.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (height: ");
        result.append(this.height);
        result.append(", zIn: ");
        result.append(this.zIn);
        result.append(", zOut: ");
        result.append(this.zOut);
        result.append(')');
        return result.toString();
    }
}

