/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ContiguousIterator;
import org.eclipse.january.dataset.ContiguousIteratorWithPosition;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.NullIterator;
import org.eclipse.january.dataset.NullStorelessUnivariateStatistic;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SingleItemIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.Stats;
import org.eclipse.january.dataset.StrideIterator;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.internal.ErrorMetadataImpl;

public abstract class AbstractDataset
extends LazyDatasetBase
implements Dataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected int size;
    protected transient AbstractDataset base;
    protected int[] stride;
    protected int offset;
    protected Serializable odata = null;
    protected transient HashMap<String, Object> storedValues = null;
    protected Format stringFormat = null;
    protected static final char BLOCK_OPEN = '[';
    protected static final char BLOCK_CLOSE = ']';
    private static int maxStringLength = 120;
    private static final int MAX_SUBBLOCKS = 6;
    private static final String SEPARATOR = ",";
    private static final String SPACE = " ";
    private static final String ELLIPSIS = "...";
    private static final String NEWLINE = "\n";
    public static final String STORE_HASH = "hash";
    protected static final String STORE_SHAPELESS_HASH = "shapelessHash";
    public static final String STORE_MAX = "max";
    public static final String STORE_MIN = "min";
    protected static final String STORE_MAX_POS = "maxPos";
    protected static final String STORE_MIN_POS = "minPos";
    protected static final String STORE_STATS = "stats";
    protected static final String STORE_SUM = "sum";
    protected static final String STORE_MEAN = "mean";
    protected static final String STORE_VAR = "var";
    protected static final String STORE_COUNT = "count";
    private static final String STORE_INDEX = "Index";

    protected abstract void setData();

    @Override
    public synchronized Dataset synchronizedCopy() {
        return this.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            if (this.getRank() == 0) {
                return obj.equals(this.getObjectAbs(0));
            }
            return false;
        }
        Dataset other = (Dataset)obj;
        if (this.getElementsPerItem() != other.getElementsPerItem()) {
            return false;
        }
        if (this.size != other.getSize()) {
            return false;
        }
        return Arrays.equals(this.shape, other.getShapeRef());
    }

    @Override
    public int hashCode() {
        return this.getHash();
    }

    @Override
    public abstract AbstractDataset clone();

    @Override
    public void setStringFormat(Format format) {
        this.stringFormat = format;
    }

    @Override
    public Dataset copy(int dtype) {
        if (this.getDType() == dtype) {
            return this;
        }
        return DatasetUtils.copy(this, dtype);
    }

    @Override
    public <T extends Dataset> T copy(Class<T> clazz) {
        return DatasetUtils.copy(clazz, this);
    }

    @Override
    public Dataset cast(int dtype) {
        if (this.getDType() == dtype) {
            return this;
        }
        return DatasetUtils.cast(this, dtype);
    }

    @Override
    public <T extends Dataset> T cast(Class<T> clazz) {
        return DatasetUtils.cast(clazz, this);
    }

    @Override
    public Dataset cast(boolean repeat, int dtype, int isize) {
        if (this.getDType() == dtype && this.getElementsPerItem() == isize) {
            return this;
        }
        return DatasetUtils.cast(this, repeat, dtype, isize);
    }

    @Override
    public abstract AbstractDataset getView(boolean var1);

    protected static void copyToView(Dataset orig, AbstractDataset view, boolean clone, boolean cloneMetadata) {
        view.name = orig.getName();
        view.size = orig.getSize();
        view.odata = orig.getBuffer();
        view.offset = orig.getOffset();
        AbstractDataset abstractDataset = view.base = orig instanceof AbstractDataset ? ((AbstractDataset)orig).base : null;
        if (clone) {
            view.shape = orig.getShape();
            AbstractDataset.copyStoredValues(orig, view, false);
            view.stride = orig instanceof AbstractDataset && ((AbstractDataset)orig).stride != null ? (int[])((AbstractDataset)orig).stride.clone() : null;
        } else {
            view.shape = orig.getShapeRef();
            view.stride = orig instanceof AbstractDataset ? ((AbstractDataset)orig).stride : null;
        }
        view.metadata = AbstractDataset.getMetadataMap(orig, cloneMetadata);
        int odtype = orig.getDType();
        int vdtype = view.getDType();
        if (DTypeUtils.getBestDType(odtype, vdtype) != vdtype) {
            view.storedValues = null;
        }
        if (odtype != vdtype && view.storedValues != null) {
            view.storedValues.remove(STORE_SHAPELESS_HASH);
            view.storedValues.remove(STORE_HASH);
        }
    }

    protected static Map<Class<? extends MetadataType>, List<MetadataType>> getMetadataMap(Dataset a, boolean clone) {
        if (a == null) {
            return null;
        }
        List all = null;
        try {
            all = a.getMetadata(null);
        }
        catch (Exception exception) {}
        if (all == null) {
            return null;
        }
        HashMap<Class<? extends MetadataType>, List<MetadataType>> map = new HashMap<Class<? extends MetadataType>, List<MetadataType>>();
        for (MetadataType m : all) {
            if (m == null) continue;
            Class<? extends MetadataType> c = AbstractDataset.findMetadataTypeSubInterfaces(m.getClass());
            List<MetadataType> l = map.get(c);
            if (l == null) {
                l = new ArrayList<MetadataType>();
                map.put(c, l);
            }
            if (clone) {
                m = m.clone();
            }
            l.add(m);
        }
        return map;
    }

    @Override
    public IntegerDataset getIndices() {
        IntegerDataset ret = DatasetUtils.indices(this.shape);
        if (this.getName() != null) {
            ret.setName("Indices of " + this.getName());
        }
        return ret;
    }

    @Override
    public Dataset getTransposedView(int ... axes) {
        axes = AbstractDataset.checkPermutatedAxes(this.shape, axes);
        AbstractDataset t = this.getView(true);
        if (axes == null || this.getRank() == 1) {
            return t;
        }
        int rank = this.shape.length;
        int[] tstride = new int[rank];
        int[] toffset = new int[1];
        int[] nshape = AbstractDataset.createStrides(new SliceND(this.shape), this, tstride, toffset);
        int[] nstride = new int[rank];
        int i = 0;
        while (i < rank) {
            int ax = axes[i];
            nstride[i] = tstride[ax];
            nshape[i] = this.shape[ax];
            ++i;
        }
        t.shape = nshape;
        t.stride = nstride;
        t.offset = toffset[0];
        t.base = this;
        AbstractDataset.copyStoredValues(this, t, true);
        t.transposeMetadata(axes);
        return t;
    }

    @Override
    public Dataset transpose(int ... axes) {
        Dataset t = this.getTransposedView(axes);
        return t == null ? this.clone() : t.clone();
    }

    @Override
    public Dataset swapAxes(int axis1, int axis2) {
        int rank = this.shape.length;
        if (axis1 < 0) {
            axis1 += rank;
        }
        if (axis2 < 0) {
            axis2 += rank;
        }
        if (axis1 < 0 || axis2 < 0 || axis1 >= rank || axis2 >= rank) {
            logger.error("Axis value invalid - out of range");
            throw new IllegalArgumentException("Axis value invalid - out of range");
        }
        if (rank == 1 || axis1 == axis2) {
            return this;
        }
        int[] axes = new int[rank];
        int i = 0;
        while (i < rank) {
            axes[i] = i;
            ++i;
        }
        axes[axis1] = axis2;
        axes[axis2] = axis1;
        return this.getTransposedView(axes);
    }

    private boolean isContiguous() {
        if (this.stride == null) {
            return true;
        }
        if (this.offset != 0) {
            return false;
        }
        int s = this.getElementsPerItem();
        int j = this.getRank() - 1;
        while (j >= 0) {
            if (this.stride[j] != s) {
                return false;
            }
            s *= this.shape[j];
            --j;
        }
        return true;
    }

    @Override
    public Dataset flatten() {
        if (!this.isContiguous()) {
            return this.clone().flatten();
        }
        return this.reshape(this.size);
    }

    protected void fillData(Object obj, int depth, int[] pos) {
        if (obj == null) {
            int dtype = this.getDType();
            if (dtype == 5) {
                this.set((Object)Float.valueOf(Float.NaN), pos);
            } else if (dtype == 6) {
                this.set((Object)Double.NaN, pos);
            }
            return;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof List) {
            List jl = (List)obj;
            int l = jl.size();
            int i = 0;
            while (i < l) {
                Object lo = jl.get(i);
                this.fillData(lo, depth + 1, pos);
                int n = depth;
                pos[n] = pos[n] + 1;
                ++i;
            }
            pos[depth] = 0;
        } else if (clazz.isArray()) {
            int l = Array.getLength(obj);
            if (clazz.equals(this.odata.getClass())) {
                System.arraycopy(obj, 0, this.odata, this.get1DIndex(pos), l);
            } else if (clazz.getComponentType().isPrimitive()) {
                int i = 0;
                while (i < l) {
                    this.set(Array.get(obj, i), pos);
                    int n = depth;
                    pos[n] = pos[n] + 1;
                    ++i;
                }
                pos[depth] = 0;
            } else {
                int i = 0;
                while (i < l) {
                    this.fillData(Array.get(obj, i), depth + 1, pos);
                    int n = depth;
                    pos[n] = pos[n] + 1;
                    ++i;
                }
                pos[depth] = 0;
            }
        } else if (obj instanceof IDataset) {
            boolean[] a = new boolean[this.shape.length];
            int i = depth;
            while (i < a.length) {
                a[i] = true;
                ++i;
            }
            this.setSlice(obj, this.getSliceIteratorFromAxes(pos, a));
        } else {
            this.set(obj, pos);
        }
    }

    @Override
    public IndexIterator getIterator(boolean withPosition) {
        if (this.stride != null) {
            return this.base.getSize() == 1 ? (withPosition ? new PositionIterator(this.offset, this.shape) : new SingleItemIterator(this.offset, this.size)) : new StrideIterator(this.shape, this.stride, this.offset);
        }
        return withPosition ? new ContiguousIteratorWithPosition(this.shape, this.size) : new ContiguousIterator(this.size);
    }

    @Override
    public IndexIterator getIterator() {
        return this.getIterator(false);
    }

    @Override
    public PositionIterator getPositionIterator(int ... axes) {
        return new PositionIterator(this.shape, axes);
    }

    @Override
    public IndexIterator getSliceIterator(int[] start, int[] stop, int[] step) {
        return this.getSliceIterator(new SliceND(this.shape, start, stop, step));
    }

    public IndexIterator getSliceIterator(SliceND slice) {
        if (ShapeUtils.calcLongSize(slice.getShape()) == 0L) {
            return new NullIterator(this.shape, slice.getShape());
        }
        if (this.stride != null) {
            return new StrideIterator(this.getElementsPerItem(), this.shape, this.stride, this.offset, slice);
        }
        return new SliceIterator(this.shape, this.size, slice);
    }

    @Override
    public SliceIterator getSliceIteratorFromAxes(int[] pos, boolean[] axes) {
        int[] start;
        int rank = this.shape.length;
        int[] stop = new int[rank];
        int[] step = new int[rank];
        if (pos == null) {
            start = new int[rank];
        } else if (pos.length == rank) {
            start = (int[])pos.clone();
        } else {
            throw new IllegalArgumentException("pos array length is not equal to rank of dataset");
        }
        if (axes == null) {
            axes = new boolean[rank];
            Arrays.fill(axes, true);
        } else if (axes.length != rank) {
            throw new IllegalArgumentException("axes array length is not equal to rank of dataset");
        }
        int i = 0;
        while (i < rank) {
            stop[i] = axes[i] ? this.shape[i] : start[i] + 1;
            step[i] = 1;
            ++i;
        }
        return (SliceIterator)this.getSliceIterator(start, stop, step);
    }

    @Override
    public BooleanIterator getBooleanIterator(Dataset choice) {
        return this.getBooleanIterator(choice, true);
    }

    @Override
    public BooleanIterator getBooleanIterator(Dataset choice, boolean value) {
        return new BooleanIterator(this.getIterator(), choice, value);
    }

    @Override
    public Dataset getByBoolean(Dataset selection) {
        this.checkCompatibility(selection);
        int length = ((Number)selection.sum()).intValue();
        int is = this.getElementsPerItem();
        Dataset r = DatasetFactory.zeros(is, new int[]{length}, this.getDType());
        BooleanIterator biter = this.getBooleanIterator(selection);
        int i = 0;
        while (biter.hasNext()) {
            r.setObjectAbs(i, this.getObjectAbs(biter.index));
            i += is;
        }
        return r;
    }

    @Override
    public Dataset getBy1DIndex(IntegerDataset index) {
        int is = this.getElementsPerItem();
        Dataset r = DatasetFactory.zeros(is, index.getShape(), this.getDType());
        IntegerIterator iter = new IntegerIterator(index, this.size, is);
        int i = 0;
        while (iter.hasNext()) {
            r.setObjectAbs(i, this.getObjectAbs(iter.index));
            i += is;
        }
        return r;
    }

    @Override
    public Dataset getByIndexes(Object ... indexes) {
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int is = this.getElementsPerItem();
        Dataset r = DatasetFactory.zeros(is, iter.getShape(), this.getDType());
        int[] pos = iter.getPos();
        int i = 0;
        while (iter.hasNext()) {
            r.setObjectAbs(i, this.getObject(pos));
            i += is;
        }
        return r;
    }

    @Override
    public Class<?> getElementClass() {
        return DTypeUtils.getElementClass(this.getDType());
    }

    @Override
    public boolean hasFloatingPointElements() {
        Class<?> cls = this.getElementClass();
        return cls == Float.class || cls == Double.class;
    }

    @Override
    public int getElementsPerItem() {
        return DTypeUtils.getElementsPerItem(this.getDType());
    }

    @Override
    public int getItemBytes() {
        return DTypeUtils.getItemBytes(this.getDType(), this.getElementsPerItem());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getShape() {
        if (this.shape == null) {
            logger.warn("Shape is null!!!");
            return new int[0];
        }
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape == null ? 0 : this.shape.length;
    }

    @Override
    public int getNbytes() {
        return this.getSize() * this.getItemBytes();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkShape(int[] shape, int size) {
        int rank = shape.length;
        int found = -1;
        int nsize = 1;
        int i = 0;
        while (i < rank) {
            int d = shape[i];
            if (d == -1) {
                if (found != -1) {
                    logger.error("Can only have one -1 placeholder in shape");
                    throw new IllegalArgumentException("Can only have one -1 placeholder in shape");
                }
                found = i;
            } else {
                nsize *= d;
            }
            ++i;
        }
        if (found >= 0) {
            shape[found] = size / nsize;
            return;
        }
        if (nsize == size) return;
        if (rank == 0) {
            if (size == 0) return;
        }
        logger.error("New shape is not same size as old shape");
        throw new IllegalArgumentException("New size is not same as the old size. Old size is " + size + " new size is " + nsize + " and shape is " + Arrays.toString(shape));
    }

    @Override
    public void setShape(int ... shape) {
        int[] nshape = (int[])shape.clone();
        this.checkShape(nshape, this.size);
        if (Arrays.equals(this.shape, nshape)) {
            return;
        }
        if (this.stride != null) {
            int[] oshape = this.shape;
            int orank = oshape.length;
            int nrank = nshape.length;
            int diff = nrank - orank;
            int[] nstride = new int[nrank];
            boolean ones = true;
            int i = 0;
            int j = 0;
            while (i < orank || j < nrank) {
                if (j >= diff && i < orank && j < nrank && oshape[i] == nshape[j]) {
                    nstride[j++] = this.stride[i++];
                    continue;
                }
                if (j < nrank && nshape[j] == 1) {
                    nstride[j++] = 0;
                    continue;
                }
                if (i < orank && oshape[i] == 1) {
                    ++i;
                    continue;
                }
                if (j < nrank) {
                    ++j;
                }
                if (i < orank) {
                    ++i;
                }
                ones = false;
            }
            if (!ones) {
                int[] ostride = this.stride;
                int ob = 0;
                int oe = 1;
                int nb = 0;
                int ne = 1;
                while (ob < orank && nb < nrank) {
                    int nl = nshape[nb];
                    int ol = oshape[ob];
                    if (nl < ol) {
                        while (ne != nrank && (nl *= nshape[ne++]) < ol) {
                        }
                        if (nl != ol) {
                            logger.error("Subshape is incompatible with single dimension");
                            throw new IllegalArgumentException("Subshape is incompatible with single dimension");
                        }
                        int on = ne - 1;
                        while (nshape[on] == 1) {
                            --on;
                        }
                        nstride[on] = ostride[ob];
                        int n = on - 1;
                        while (n >= nb) {
                            if (nshape[n] != 1) {
                                nstride[n] = nshape[on] * nstride[on];
                                on = n;
                            }
                            --n;
                        }
                    } else if (ol < nl) {
                        while (oe != orank && (ol *= oshape[oe++]) < nl) {
                        }
                        if (nl != ol) {
                            logger.error("Single dimension is incompatible with subshape");
                            throw new IllegalArgumentException("Single dimension is incompatible with subshape");
                        }
                        int oo = oe - 1;
                        while (oshape[oo] == 1) {
                            --oo;
                        }
                        int os = ostride[oo];
                        int o = oo - 1;
                        while (o >= ob) {
                            if (oshape[o] != 1) {
                                if (ostride[o] != oshape[oo] * ostride[oo]) {
                                    logger.error("Subshape cannot be a non-contiguous view");
                                    throw new IllegalArgumentException("Subshape cannot be a non-contiguous view");
                                }
                                oo = o;
                            }
                            --o;
                        }
                        nstride[nb] = os;
                    } else {
                        nstride[nb] = ostride[ob];
                    }
                    ob = oe++;
                    nb = ne++;
                }
            }
            this.stride = nstride;
        }
        if (this.shape != null) {
            this.reshapeMetadata(this.shape, nshape);
            this.shape = nshape;
        }
        if (this.storedValues != null) {
            AbstractDataset.filterStoredValues(this.storedValues);
        }
    }

    @Override
    public int[] getShapeRef() {
        return this.shape;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int[] getStrides() {
        return this.stride;
    }

    @Override
    public Serializable getBuffer() {
        return this.odata;
    }

    @Override
    public void overrideInternal(Serializable buffer, int ... shape) {
        if (buffer != null) {
            this.odata = buffer;
            this.setData();
            this.setDirty();
        }
        if (shape != null) {
            this.shape = (int[])shape.clone();
            this.size = ShapeUtils.calcSize(this.shape);
        }
    }

    public static int[] createStrides(Dataset a, int[] offset) {
        return AbstractDataset.createStrides(a.getElementsPerItem(), a.getShapeRef(), a.getStrides(), a.getOffset(), offset);
    }

    public static int[] createStrides(int isize, int[] shape, int[] oStride, int oOffset, int[] offset) {
        int[] stride;
        int rank = shape.length;
        if (oStride == null) {
            offset[0] = 0;
            stride = new int[rank];
            int s = isize;
            int j = rank - 1;
            while (j >= 0) {
                stride[j] = s;
                s *= shape[j];
                --j;
            }
        } else {
            offset[0] = oOffset;
            stride = (int[])oStride.clone();
        }
        return stride;
    }

    public static int[] createStrides(SliceND slice, Dataset a, int[] stride, int[] offset) {
        return AbstractDataset.createStrides(slice, a.getElementsPerItem(), a.getShapeRef(), a.getStrides(), a.getOffset(), stride, offset);
    }

    public static int[] createStrides(SliceND slice, int isize, int[] shape, int[] oStride, int oOffset, int[] stride, int[] offset) {
        int[] lstart = slice.getStart();
        int[] lstep = slice.getStep();
        int[] newShape = slice.getShape();
        int rank = shape.length;
        if (oStride == null) {
            int s = isize;
            offset[0] = 0;
            int j = rank - 1;
            while (j >= 0) {
                stride[j] = s * lstep[j];
                offset[0] = offset[0] + s * lstart[j];
                s *= shape[j];
                --j;
            }
        } else {
            offset[0] = oOffset;
            int j = 0;
            while (j < rank) {
                int s = oStride[j];
                stride[j] = lstep[j] * s;
                offset[0] = offset[0] + lstart[j] * s;
                ++j;
            }
        }
        return newShape;
    }

    @Override
    public Dataset getBroadcastView(int ... broadcastShape) {
        AbstractDataset view = this.getView(true);
        if (!Arrays.equals(this.shape, broadcastShape)) {
            List<int[]> nShapes = BroadcastUtils.broadcastShapesToMax(broadcastShape, new int[][]{this.shape});
            view.setShape(nShapes.get(0));
            view.stride = BroadcastUtils.createBroadcastStrides(view, broadcastShape);
            view.base = this;
            view.shape = (int[])broadcastShape.clone();
            view.size = ShapeUtils.calcSize(broadcastShape);
            view.name = view.name == null || view.name.isEmpty() ? "Broadcast from " + Arrays.toString(this.shape) : "Broadcast of " + view.name + " from " + Arrays.toString(this.shape);
        }
        return view;
    }

    @Override
    public Dataset getSliceView(int[] start, int[] stop, int[] step) {
        return this.getSliceView(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSliceView(Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.getView(true);
        }
        return this.getSliceView(new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSliceView(SliceND slice) {
        if (slice.isAll()) {
            return this.getView(true);
        }
        int rank = this.shape.length;
        int[] sStride = new int[rank];
        int[] sOffset = new int[1];
        int[] sShape = AbstractDataset.createStrides(slice, this, sStride, sOffset);
        AbstractDataset s = this.getView(false);
        s.shape = sShape;
        s.size = ShapeUtils.calcSize(sShape);
        s.stride = sStride;
        s.offset = sOffset[0];
        s.base = this;
        s.metadata = this.copyMetadata();
        s.sliceMetadata(true, slice);
        s.setDirty();
        s.setName(String.valueOf(this.name) + '[' + slice + ']');
        return s;
    }

    private int getFlat1DIndex(int[] pos) {
        int imax = pos.length;
        if (imax == 0) {
            return 0;
        }
        return this.get1DIndexFromShape(pos);
    }

    @Override
    public int get1DIndex(int ... n) {
        int imax = n.length;
        int rank = this.shape.length;
        if (imax == 0) {
            if (rank == 0 || rank == 1 && this.shape[0] <= 1) {
                return this.stride == null ? 0 : this.offset;
            }
            throw new IllegalArgumentException("One or more index parameters must be supplied");
        }
        if (imax > rank) {
            throw new IllegalArgumentException("No of index parameters is different to the shape of data: " + imax + " given " + rank + " required");
        }
        return this.stride == null ? this.get1DIndexFromShape(n) : this.get1DIndexFromStrides(n);
    }

    private static void throwAIOOBException(int i, int s, int d) {
        throw new ArrayIndexOutOfBoundsException("Index (" + i + ") out of range [-" + s + SEPARATOR + s + "] in dimension " + d);
    }

    protected int get1DIndex(int i) {
        if (this.shape.length > 1) {
            logger.debug("This dataset is not 1D but was addressed as such");
            return this.get1DIndex(new int[]{i});
        }
        if (i < 0) {
            i += this.shape[0];
        }
        if (i < 0 || i >= this.shape[0]) {
            AbstractDataset.throwAIOOBException(i, this.shape[0], 0);
        }
        return this.stride == null ? i : i * this.stride[0] + this.offset;
    }

    protected int get1DIndex(int i, int j) {
        if (this.shape.length != 2) {
            logger.debug("This dataset is not 2D but was addressed as such");
            return this.get1DIndex(new int[]{i, j});
        }
        if (i < 0) {
            i += this.shape[0];
        }
        if (i < 0 || i >= this.shape[0]) {
            AbstractDataset.throwAIOOBException(i, this.shape[0], 0);
        }
        if (j < 0) {
            j += this.shape[1];
        }
        if (j < 0 || j >= this.shape[1]) {
            AbstractDataset.throwAIOOBException(i, this.shape[1], 1);
        }
        return this.stride == null ? i * this.shape[1] + j : i * this.stride[0] + j * this.stride[1] + this.offset;
    }

    protected int get1DIndexFromShape(int[] n) {
        return AbstractDataset.get1DIndexFromShape(this.shape, n);
    }

    protected static int get1DIndexFromShape(int[] shape, int[] n) {
        int imax = n.length;
        int rank = shape.length;
        int index = 0;
        int i = 0;
        while (i < imax) {
            int si = shape[i];
            int ni = n[i];
            if (ni < 0) {
                ni += si;
            }
            if (ni < 0 || ni >= si) {
                AbstractDataset.throwAIOOBException(ni, si, i);
            }
            index = index * si + ni;
            ++i;
        }
        while (i < rank) {
            index *= shape[i];
            ++i;
        }
        return index;
    }

    private int get1DIndexFromStrides(int[] n) {
        return AbstractDataset.get1DIndexFromStrides(this.shape, this.stride, this.offset, n);
    }

    private static int get1DIndexFromStrides(int[] shape, int[] stride, int offset, int[] n) {
        int rank = shape.length;
        if (rank != n.length) {
            throw new IllegalArgumentException("Number of position indexes must be equal to rank");
        }
        int index = offset;
        int i = 0;
        while (i < rank) {
            int st = stride[i];
            if (st != 0) {
                int si = shape[i];
                int ni = n[i];
                if (ni < 0) {
                    ni += si;
                }
                if (ni < 0 || ni >= si) {
                    AbstractDataset.throwAIOOBException(ni, si, i);
                }
                index += st * ni;
            }
            ++i;
        }
        return index;
    }

    @Override
    public int[] getNDPosition(int n) {
        if (this.isIndexInRange(n)) {
            throw new IllegalArgumentException("Index provided " + n + "is larger then the size of the containing array");
        }
        return this.stride == null ? ShapeUtils.getNDPositionFromShape(n, this.shape) : this.getNDPositionFromStrides(n);
    }

    private boolean isIndexInRange(int n) {
        if (this.stride == null) {
            return n >= this.size;
        }
        return n >= this.getBufferLength();
    }

    protected abstract int getBufferLength();

    private int[] getNDPositionFromStrides(int n) {
        n -= this.offset;
        int rank = this.shape.length;
        if (rank == 1) {
            return new int[]{n / this.stride[0]};
        }
        int[] output = new int[rank];
        int i = 0;
        while (i != n) {
            int j = rank - 1;
            while (j >= 0) {
                int n2 = j;
                output[n2] = output[n2] + 1;
                i += this.stride[j];
                if (output[j] < this.shape[j]) break;
                output[j] = 0;
                i -= this.shape[j] * this.stride[j];
                --j;
            }
            if (j != -1) continue;
            logger.error("Index was not found in this strided dataset");
            throw new IllegalArgumentException("Index was not found in this strided dataset");
        }
        return output;
    }

    @Override
    public int checkAxis(int axis) {
        return AbstractDataset.checkAxis(this.shape.length, axis);
    }

    protected static int checkAxis(int rank, int axis) {
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IndexOutOfBoundsException("Axis " + axis + " given is out of range [0, " + rank + ")");
        }
        return axis;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean showData) {
        int rank = this.shape == null ? 0 : this.shape.length;
        StringBuilder out = new StringBuilder();
        if (!showData) {
            if (this.name != null && this.name.length() > 0) {
                out.append("Dataset '");
                out.append(this.name);
                out.append("' has shape ");
            } else {
                out.append("Dataset shape is ");
            }
            out.append('[');
            if (rank > 0) {
                out.append(this.shape[0]);
            }
            int i = 1;
            while (i < rank) {
                out.append(", " + this.shape[i]);
                ++i;
            }
            out.append(']');
            return out.toString();
        }
        if (this.size == 0) {
            return out.toString();
        }
        if (rank > 0) {
            int[] pos = new int[rank];
            StringBuilder lead = new StringBuilder();
            this.printBlocks(out, lead, 0, pos);
        } else {
            out.append(this.getString(new int[0]));
        }
        return out.toString();
    }

    public static void setMaxLineLength(int maxLineLength) {
        maxStringLength = maxLineLength;
    }

    public static int getMaxLineLength() {
        return maxStringLength;
    }

    private StringBuilder makeLine(int end, int ... start) {
        int index;
        StringBuilder line = new StringBuilder();
        int[] pos = end >= start.length ? Arrays.copyOf(start, end + 1) : start;
        pos[end] = 0;
        line.append('[');
        line.append(this.getString(pos));
        int length = this.shape[end];
        int excess = length - maxStringLength / 3;
        if (excess > 0) {
            index = (length - excess) / 2;
            int y = 1;
            while (y < index) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
            y = index = (length + excess) / 2;
            while (y < length) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
        } else {
            int y = 1;
            while (y < length) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
        }
        line.append(']');
        excess = line.length() - maxStringLength - ELLIPSIS.length() - 1;
        if (excess > 0) {
            index = line.substring(0, (line.length() - excess) / 2).lastIndexOf(SEPARATOR) + 2;
            StringBuilder out = new StringBuilder(line.subSequence(0, index));
            out.append("...,");
            index = line.substring((line.length() + excess) / 2).indexOf(SEPARATOR) + (line.length() + excess) / 2 + 1;
            out.append(line.subSequence(index, line.length()));
            return out;
        }
        return line;
    }

    private void printBlocks(StringBuilder out, StringBuilder lead, int level, int[] pos) {
        int end;
        char last;
        if (out.length() > 0 && (last = out.charAt(out.length() - 1)) != '[') {
            out.append((CharSequence)lead);
        }
        if (level != (end = this.getRank() - 1)) {
            out.append('[');
            int length = this.shape[level];
            pos[level] = 0;
            StringBuilder newlead = new StringBuilder(lead);
            newlead.append(SPACE);
            this.printBlocks(out, newlead, level + 1, pos);
            if (length < 2) {
                out.append(']');
                return;
            }
            out.append(",\n");
            int i = level + 1;
            while (i < end) {
                out.append(NEWLINE);
                ++i;
            }
            if (length < 6) {
                int x = 1;
                while (x < length - 1) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
            } else {
                int excess = length - 6;
                int xmax = (length - excess) / 2;
                int x = 1;
                while (x < xmax) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
                out.append((CharSequence)newlead);
                out.append("...,\n");
                x = xmax = (length + excess) / 2;
                while (x < length - 1) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
            }
            pos[level] = length - 1;
            this.printBlocks(out, newlead, level + 1, pos);
            out.append(']');
        } else {
            out.append((CharSequence)this.makeLine(end, pos));
        }
    }

    @Override
    public void setDirty() {
        if (this.storedValues != null) {
            this.storedValues.clear();
        }
    }

    @Override
    public Dataset squeezeEnds() {
        return this.squeeze(true);
    }

    @Override
    public Dataset squeeze() {
        return this.squeeze(false);
    }

    @Override
    public Dataset squeeze(boolean onlyFromEnds) {
        int[] tshape = ShapeUtils.squeezeShape(this.shape, onlyFromEnds);
        int[] oshape = this.shape;
        if (this.stride == null) {
            this.shape = tshape;
        } else {
            int trank = tshape.length;
            int rank = this.shape.length;
            if (trank < rank) {
                int[] tstride = new int[tshape.length];
                if (onlyFromEnds) {
                    int i = 0;
                    while (i < rank) {
                        if (this.shape[i] != 1) {
                            int k = 0;
                            while (k < trank) {
                                tstride[k] = this.stride[i++];
                                ++k;
                            }
                            break;
                        }
                        ++i;
                    }
                } else {
                    int t = 0;
                    int i = 0;
                    while (i < rank) {
                        if (this.shape[i] != 1) {
                            tstride[t++] = this.stride[i];
                        }
                        ++i;
                    }
                }
                this.shape = tshape;
                this.stride = tstride;
            }
        }
        this.reshapeMetadata(oshape, this.shape);
        return this;
    }

    @Override
    public boolean isCompatibleWith(ILazyDataset g) {
        return ShapeUtils.areShapesCompatible(this.shape, g.getShape());
    }

    @Override
    public void checkCompatibility(ILazyDataset g) throws IllegalArgumentException {
        ShapeUtils.checkCompatibility(this, g);
    }

    @Override
    public Dataset reshape(int ... shape) {
        Dataset a = this.getView(true);
        try {
            a.setShape(shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a = a.clone();
            a.setShape(shape);
        }
        return a;
    }

    protected static int calcSteps(double start, double stop, double step) {
        if (step > 0.0) {
            return (int)Math.ceil((stop - start) / step);
        }
        return (int)Math.ceil((stop - start) / step);
    }

    @Override
    public boolean isComplex() {
        int type = this.getDType();
        return type == 7 || type == 8;
    }

    @Override
    public Dataset getReal() {
        return this;
    }

    @Override
    public Dataset getRealView() {
        return this.getView(true);
    }

    @Override
    public Dataset getSlice(int[] start, int[] stop, int[] step) {
        return this.getSlice(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(Slice ... slice) {
        return this.getSlice(new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, Slice ... slice) {
        return this.getSlice(slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, SliceND slice) {
        return this.getSlice(slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, int[] start, int[] stop, int[] step) {
        return this.getSlice(start, stop, step);
    }

    @Override
    public Dataset getSlice(SliceND slice) {
        SliceIterator it = (SliceIterator)this.getSliceIterator(slice);
        AbstractDataset s = this.getSlice(it);
        s.metadata = this.copyMetadata();
        s.sliceMetadata(true, slice);
        return s;
    }

    public abstract AbstractDataset getSlice(SliceIterator var1);

    @Override
    public Dataset setSlice(Object obj, SliceND slice) {
        Dataset ds;
        if (obj instanceof Dataset) {
            ds = (Dataset)obj;
        } else if (obj instanceof IDataset) {
            ds = DatasetUtils.convertToDataset((IDataset)obj);
        } else {
            int dtype = this.getDType();
            if (dtype != 0) {
                dtype = DTypeUtils.getLargestDType(dtype);
            }
            ds = DatasetFactory.createFromObject(this.getElementsPerItem(), dtype, obj, new int[0]);
        }
        return this.setSlicedView(this.getSliceView(slice), ds);
    }

    @Override
    public Dataset setSlice(Object obj, int[] start, int[] stop, int[] step) {
        return this.setSlice(obj, new SliceND(this.shape, start, stop, step));
    }

    abstract Dataset setSlicedView(Dataset var1, Dataset var2);

    @Override
    public Dataset setSlice(Object obj, Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.setSlice(obj, new SliceND(this.shape));
        }
        return this.setSlice(obj, new SliceND(this.shape, slice));
    }

    @Override
    public boolean all() {
        return Comparisons.allTrue(this);
    }

    @Override
    public BooleanDataset all(int axis) {
        return Comparisons.allTrue(this, axis);
    }

    @Override
    public boolean any() {
        return Comparisons.anyTrue(this);
    }

    @Override
    public BooleanDataset any(int axis) {
        return Comparisons.anyTrue(this, axis);
    }

    @Override
    public Dataset ifloorDivide(Object o) {
        return this.idivide(o).ifloor();
    }

    @Override
    public double residual(Object o) {
        return this.residual(o, null, false);
    }

    @Override
    public double residual(Object o, boolean ignoreNaNs) {
        return this.residual(o, null, ignoreNaNs);
    }

    public Object getStoredValue(String key) {
        if (this.storedValues == null) {
            return null;
        }
        return this.storedValues.get(key);
    }

    public void setStoredValue(String key, Object obj) {
        if (this.storedValues == null) {
            this.storedValues = new HashMap();
        }
        this.storedValues.put(key, obj);
    }

    protected static String storeName(boolean ignoreNaNs, String name) {
        return AbstractDataset.storeName(ignoreNaNs, false, name);
    }

    protected static String storeName(boolean ignoreNaNs, boolean ignoreInfs, String name) {
        return String.valueOf(ignoreInfs ? "inf" : "") + (ignoreNaNs ? "nan" : "") + name;
    }

    protected static void copyStoredValues(IDataset orig, AbstractDataset derived, boolean shapeChanged) {
        if (orig instanceof AbstractDataset && ((AbstractDataset)orig).storedValues != null) {
            derived.storedValues = new HashMap<String, Object>(((AbstractDataset)orig).storedValues);
            if (shapeChanged) {
                AbstractDataset.filterStoredValues(derived.storedValues);
            }
        }
    }

    private static void filterStoredValues(Map<String, Object> map) {
        map.remove(STORE_HASH);
        ArrayList<String> keys = new ArrayList<String>();
        for (String n : map.keySet()) {
            if (!n.contains("-")) continue;
            keys.add(n);
        }
        for (String n : keys) {
            map.remove(n);
        }
    }

    protected void calculateMaxMin(boolean ignoreNaNs, boolean ignoreInfs) {
        IndexIterator iter = this.getIterator();
        double amax = Double.NEGATIVE_INFINITY;
        double amin = Double.POSITIVE_INFINITY;
        double hash = 0.0;
        boolean hasNaNs = false;
        while (iter.hasNext()) {
            double val = this.getElementDoubleAbs(iter.index);
            if (Double.isNaN(val)) {
                hash = hash * 19.0 % 2.147483647E9;
                if (ignoreNaNs) continue;
                hasNaNs = true;
            } else if (Double.isInfinite(val)) {
                hash = hash * 19.0 % 2.147483647E9;
                if (ignoreInfs) {
                    continue;
                }
            } else {
                hash = (hash * 19.0 + val) % 2.147483647E9;
            }
            if (val > amax) {
                amax = val;
            }
            if (!(val < amin)) continue;
            amin = val;
        }
        int ihash = (int)hash * 19 + this.getDType() * 17 + this.getElementsPerItem();
        this.setStoredValue(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, STORE_SHAPELESS_HASH), ihash);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, STORE_MAX), hasNaNs ? (Number)Double.NaN : (Number)this.fromDoubleToNumber(amax));
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, STORE_MIN), hasNaNs ? (Number)Double.NaN : (Number)this.fromDoubleToNumber(amin));
    }

    /*
     * Unable to fully structure code
     */
    protected void calculateSummaryStats(boolean ignoreNaNs, boolean ignoreInfs, String name) {
        block7: {
            iter = this.getIterator();
            stats = new SummaryStatistics();
            stats.setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
            if (this.storedValues != null && this.storedValues.containsKey("hash")) ** GOTO lbl34
            hasNaNs = false;
            hash = 0.0;
            while (iter.hasNext()) {
                val = this.getElementDoubleAbs(iter.index);
                if (Double.isNaN(val)) {
                    hash = hash * 19.0 % 2.147483647E9;
                    if (ignoreNaNs) continue;
                    hasNaNs = true;
                } else if (Double.isInfinite(val)) {
                    hash = hash * 19.0 % 2.147483647E9;
                    if (ignoreInfs) {
                        continue;
                    }
                } else {
                    hash = (hash * 19.0 + val) % 2.147483647E9;
                }
                stats.addValue(val);
            }
            ihash = (int)hash * 19 + this.getDType() * 17 + this.getElementsPerItem();
            this.setStoredValue(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "shapelessHash"), ihash);
            this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "max"), hasNaNs != false ? Double.valueOf(NaN) : this.fromDoubleToNumber(stats.getMax()));
            this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "min"), hasNaNs != false ? Double.valueOf(NaN) : this.fromDoubleToNumber(stats.getMin()));
            this.storedValues.put(name, stats);
            break block7;
lbl-1000:
            // 1 sources

            {
                val = this.getElementDoubleAbs(iter.index);
                if (ignoreNaNs && Double.isNaN(val) || ignoreInfs && Double.isInfinite(val)) continue;
                stats.addValue(val);
lbl34:
                // 3 sources

                ** while (iter.hasNext())
            }
lbl35:
            // 1 sources

            this.storedValues.put(name, stats);
        }
    }

    protected void calculateSummaryStats(boolean ignoreNaNs, boolean ignoreInfs, int axis) {
        int rank = this.getRank();
        int[] oshape = this.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        int[] nshape = new int[rank - 1];
        int i = 0;
        while (i < axis) {
            nshape[i] = oshape[i];
            ++i;
        }
        i = axis + 1;
        while (i < rank) {
            nshape[i - 1] = oshape[i];
            ++i;
        }
        int dtype = this.getDType();
        IntegerDataset count = new IntegerDataset(nshape);
        Dataset max = DatasetFactory.zeros(nshape, dtype);
        Dataset min = DatasetFactory.zeros(nshape, dtype);
        IntegerDataset maxIndex = new IntegerDataset(nshape);
        IntegerDataset minIndex = new IntegerDataset(nshape);
        Dataset sum = DatasetFactory.zeros(nshape, DTypeUtils.getLargestDType(dtype));
        DoubleDataset mean = new DoubleDataset(nshape);
        DoubleDataset var = new DoubleDataset(nshape);
        IndexIterator qiter = max.getIterator(true);
        int[] qpos = qiter.getPos();
        int[] spos = (int[])oshape.clone();
        while (qiter.hasNext()) {
            double val;
            int j;
            boolean hasNaNs;
            double amin;
            double amax;
            SummaryStatistics stats;
            block38: {
                int j2;
                block37: {
                    int i2 = 0;
                    while (i2 < axis) {
                        spos[i2] = qpos[i2];
                        ++i2;
                    }
                    spos[i2++] = 0;
                    while (i2 < rank) {
                        spos[i2] = qpos[i2 - 1];
                        ++i2;
                    }
                    stats = new SummaryStatistics();
                    stats.setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
                    amax = Double.NEGATIVE_INFINITY;
                    amin = Double.POSITIVE_INFINITY;
                    hasNaNs = false;
                    if (!ignoreNaNs) break block37;
                    j2 = 0;
                    while (j2 < alen) {
                        spos[axis] = j2;
                        double val2 = this.getDouble(spos);
                        if (Double.isNaN(val2)) {
                            hasNaNs = true;
                        } else if (!ignoreInfs || !Double.isInfinite(val2)) {
                            if (val2 > amax) {
                                amax = val2;
                            }
                            if (val2 < amin) {
                                amin = val2;
                            }
                            stats.addValue(val2);
                        }
                        ++j2;
                    }
                    break block38;
                }
                j2 = 0;
                while (j2 < alen) {
                    block40: {
                        double val3;
                        block42: {
                            block41: {
                                block39: {
                                    spos[axis] = j2;
                                    val3 = this.getDouble(spos);
                                    if (!hasNaNs) break block39;
                                    if (!Double.isNaN(val3)) {
                                        stats.addValue(0.0);
                                    }
                                    break block40;
                                }
                                if (!Double.isNaN(val3)) break block41;
                                amax = Double.NaN;
                                amin = Double.NaN;
                                hasNaNs = true;
                                break block42;
                            }
                            if (ignoreInfs && Double.isInfinite(val3)) break block40;
                            if (val3 > amax) {
                                amax = val3;
                            }
                            if (val3 < amin) {
                                amin = val3;
                            }
                        }
                        stats.addValue(val3);
                    }
                    ++j2;
                }
            }
            count.setAbs(qiter.index, (int)stats.getN());
            max.setObjectAbs(qiter.index, amax);
            min.setObjectAbs(qiter.index, amin);
            boolean fmax = false;
            boolean fmin = false;
            if (hasNaNs) {
                if (ignoreNaNs) {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        val = this.getDouble(spos);
                        if (!Double.isNaN(val)) {
                            if (!fmax && val == amax) {
                                maxIndex.setAbs(qiter.index, j);
                                fmax = true;
                                if (fmin) break;
                            }
                            if (!fmin && val == amin) {
                                minIndex.setAbs(qiter.index, j);
                                fmin = true;
                                if (fmax) break;
                            }
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        val = this.getDouble(spos);
                        if (!Double.isNaN(val)) continue;
                        maxIndex.setAbs(qiter.index, j);
                        minIndex.setAbs(qiter.index, j);
                        break;
                    }
                }
            } else {
                j = 0;
                while (j < alen) {
                    spos[axis] = j;
                    val = this.getDouble(spos);
                    if (!fmax && val == amax) {
                        maxIndex.setAbs(qiter.index, j);
                        fmax = true;
                        if (fmin) break;
                    }
                    if (!fmin && val == amin) {
                        minIndex.setAbs(qiter.index, j);
                        fmin = true;
                        if (fmax) break;
                    }
                    ++j;
                }
            }
            sum.setObjectAbs(qiter.index, stats.getSum());
            mean.setAbs(qiter.index, stats.getMean());
            var.setAbs(qiter.index, stats.getVariance());
        }
        this.setStoredValue(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "count-" + axis), count);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "max-" + axis), max);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "min-" + axis), min);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "sum-" + axis), sum);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "mean-" + axis), mean);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "var-" + axis), var);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "maxIndex-" + axis), maxIndex);
        this.storedValues.put(AbstractDataset.storeName(ignoreNaNs, ignoreInfs, "minIndex-" + axis), minIndex);
    }

    protected abstract Number fromDoubleToNumber(double var1);

    private SummaryStatistics getStatistics(boolean ignoreNaNs) {
        String n;
        SummaryStatistics stats;
        boolean ignoreInfs = false;
        if (!this.hasFloatingPointElements()) {
            ignoreNaNs = false;
        }
        if ((stats = (SummaryStatistics)this.getStoredValue(n = AbstractDataset.storeName(ignoreNaNs, ignoreInfs, STORE_STATS))) == null) {
            this.calculateSummaryStats(ignoreNaNs, ignoreInfs, n);
            stats = (SummaryStatistics)this.getStoredValue(n);
        }
        return stats;
    }

    @Override
    public int[] maxPos() {
        return this.maxPos(false);
    }

    @Override
    public int[] minPos() {
        return this.minPos(false);
    }

    private int getHash() {
        Object value = this.getStoredValue(STORE_HASH);
        if (value == null) {
            value = this.getStoredValue(STORE_SHAPELESS_HASH);
            if (value == null) {
                this.calculateMaxMin(false, false);
                value = this.getStoredValue(STORE_SHAPELESS_HASH);
            }
            int ihash = (Integer)value;
            int rank = this.shape.length;
            int i = 0;
            while (i < rank) {
                ihash = ihash * 17 + this.shape[i];
                ++i;
            }
            this.storedValues.put(STORE_HASH, ihash);
            return ihash;
        }
        return (Integer)value;
    }

    protected Object getMaxMin(boolean ignoreNaNs, boolean ignoreInfs, String key) {
        Object value;
        if (!this.hasFloatingPointElements()) {
            ignoreNaNs = false;
            ignoreInfs = false;
        }
        if ((value = this.getStoredValue(key = AbstractDataset.storeName(ignoreNaNs, ignoreInfs, key))) == null) {
            this.calculateMaxMin(ignoreNaNs, ignoreInfs);
            value = this.getStoredValue(key);
        }
        return value;
    }

    private Object getStatistics(boolean ignoreNaNs, int axis, String stat) {
        if (!this.hasFloatingPointElements()) {
            ignoreNaNs = false;
        }
        boolean ignoreInfs = false;
        stat = AbstractDataset.storeName(ignoreNaNs, ignoreInfs, stat);
        axis = this.checkAxis(axis);
        Object obj = this.getStoredValue(stat);
        if (obj == null) {
            this.calculateSummaryStats(ignoreNaNs, ignoreInfs, axis);
            obj = this.getStoredValue(stat);
        }
        return obj;
    }

    @Override
    public Number max(boolean ... ignoreInvalids) {
        boolean igNan = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
        boolean igInf = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : igNan;
        return (Number)this.getMaxMin(igNan, igInf, STORE_MAX);
    }

    @Override
    public Dataset max(int axis) {
        return this.max(false, axis);
    }

    @Override
    public Dataset max(boolean ignoreNaNs, int axis) {
        return (Dataset)this.getStatistics(ignoreNaNs, axis, "max-" + axis);
    }

    @Override
    public Number min(boolean ... ignoreInvalids) {
        boolean igNan = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
        boolean igInf = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : igNan;
        return (Number)this.getMaxMin(igNan, igInf, STORE_MIN);
    }

    @Override
    public Dataset min(int axis) {
        return this.min(false, axis);
    }

    @Override
    public Dataset min(boolean ignoreNaNs, int axis) {
        return (Dataset)this.getStatistics(ignoreNaNs, axis, "min-" + axis);
    }

    @Override
    public int argMax() {
        return this.argMax(false);
    }

    @Override
    public int argMax(boolean ignoreInvalids) {
        return this.getFlat1DIndex(this.maxPos(ignoreInvalids));
    }

    @Override
    public IntegerDataset argMax(int axis) {
        return this.argMax(false, axis);
    }

    @Override
    public IntegerDataset argMax(boolean ignoreNaNs, int axis) {
        return (IntegerDataset)this.getStatistics(ignoreNaNs, axis, "maxIndex-" + axis);
    }

    @Override
    public int argMin() {
        return this.argMin(false);
    }

    @Override
    public int argMin(boolean ignoreInvalids) {
        return this.getFlat1DIndex(this.minPos(ignoreInvalids));
    }

    @Override
    public IntegerDataset argMin(int axis) {
        return this.argMin(false, axis);
    }

    @Override
    public IntegerDataset argMin(boolean ignoreNaNs, int axis) {
        return (IntegerDataset)this.getStatistics(ignoreNaNs, axis, "minIndex-" + axis);
    }

    @Override
    public Number peakToPeak() {
        return this.fromDoubleToNumber(this.max(new boolean[0]).doubleValue() - this.min(new boolean[0]).doubleValue());
    }

    @Override
    public Dataset peakToPeak(int axis) {
        return Maths.subtract(this.max(axis), this.min(axis));
    }

    @Override
    public long count() {
        return this.count(false);
    }

    @Override
    public long count(boolean ignoreNaNs) {
        return this.getStatistics(ignoreNaNs).getN();
    }

    @Override
    public Dataset count(int axis) {
        return this.count(false, axis);
    }

    @Override
    public Dataset count(boolean ignoreNaNs, int axis) {
        return (Dataset)this.getStatistics(ignoreNaNs, axis, "count-" + axis);
    }

    @Override
    public Object sum() {
        return this.sum(false);
    }

    @Override
    public Object sum(boolean ignoreNaNs) {
        return this.getStatistics(ignoreNaNs).getSum();
    }

    @Override
    public Dataset sum(int axis) {
        return this.sum(false, axis);
    }

    @Override
    public Dataset sum(boolean ignoreNaNs, int axis) {
        return (Dataset)this.getStatistics(ignoreNaNs, axis, "sum-" + axis);
    }

    @Override
    public Object typedSum() {
        return this.typedSum(this.getDType());
    }

    @Override
    public Object typedSum(int dtype) {
        return DTypeUtils.fromDoubleToBiggestNumber(this.getStatistics(false).getSum(), dtype);
    }

    @Override
    public Dataset typedSum(int dtype, int axis) {
        return DatasetUtils.cast(this.sum(axis), dtype);
    }

    @Override
    public Object product() {
        return Stats.product(this);
    }

    @Override
    public Dataset product(int axis) {
        return Stats.product((Dataset)this, axis);
    }

    @Override
    public Object typedProduct(int dtype) {
        return Stats.typedProduct(this, dtype);
    }

    @Override
    public Dataset typedProduct(int dtype, int axis) {
        return Stats.typedProduct((Dataset)this, dtype, axis);
    }

    @Override
    public Object mean(boolean ... ignoreNaNs) {
        boolean ig = ignoreNaNs != null && ignoreNaNs.length > 0 ? ignoreNaNs[0] : false;
        return this.getStatistics(ig).getMean();
    }

    @Override
    public Dataset mean(int axis) {
        return this.mean(false, axis);
    }

    @Override
    public Dataset mean(boolean ignoreNaNs, int axis) {
        return (Dataset)this.getStatistics(ignoreNaNs, axis, "mean-" + axis);
    }

    @Override
    public Number variance() {
        return this.variance(false);
    }

    @Override
    public Number variance(boolean isDatasetWholePopulation) {
        SummaryStatistics stats = this.getStatistics(false);
        return isDatasetWholePopulation ? stats.getPopulationVariance() : stats.getVariance();
    }

    @Override
    public Dataset variance(int axis) {
        return (Dataset)this.getStatistics(false, axis, "var-" + axis);
    }

    @Override
    public Number stdDeviation() {
        return Math.sqrt(this.variance().doubleValue());
    }

    @Override
    public Number stdDeviation(boolean isDatasetWholePopulation) {
        return Math.sqrt(this.variance(isDatasetWholePopulation).doubleValue());
    }

    @Override
    public Dataset stdDeviation(int axis) {
        Dataset v = (Dataset)this.getStatistics(false, axis, "var-" + axis);
        return Maths.sqrt(v);
    }

    @Override
    public Number rootMeanSquare() {
        SummaryStatistics stats = this.getStatistics(false);
        double mean = stats.getMean();
        return Math.sqrt(stats.getVariance() + mean * mean);
    }

    @Override
    public Dataset rootMeanSquare(int axis) {
        Dataset v = (Dataset)this.getStatistics(false, axis, "var-" + axis);
        Dataset m = (Dataset)this.getStatistics(false, axis, "mean-" + axis);
        Dataset result = Maths.power(m, 2);
        return Maths.sqrt(result.iadd(v));
    }

    protected abstract void setItemDirect(int var1, int var2, Object var3);

    private Dataset getBroadcastedInternalError() {
        ILazyDataset led = super.getError();
        if (led == null) {
            return null;
        }
        Dataset ed = null;
        try {
            ed = DatasetUtils.sliceAndConvertLazyDataset(led);
        }
        catch (DatasetException e) {
            logger.error("Could not get data from lazy dataset", (Throwable)e);
        }
        if (led != ed) {
            this.setError(ed);
        }
        return ed.getBroadcastView(this.shape);
    }

    @Override
    public Dataset getError() {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return ed;
    }

    @Override
    public double getError(int i) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(i);
    }

    @Override
    public double getError(int i, int j) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(i, j);
    }

    @Override
    public double getError(int ... pos) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(pos);
    }

    @Override
    public double[] getErrorArray(int i) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(i)};
    }

    @Override
    public double[] getErrorArray(int i, int j) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(i, j)};
    }

    @Override
    public double[] getErrorArray(int ... pos) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(pos)};
    }

    protected Dataset getInternalSquaredError() {
        Dataset sed = this.getErrorBuffer().getBroadcastView(this.shape);
        return sed;
    }

    @Override
    public Dataset getErrorBuffer() {
        ErrorMetadata emd = this.getErrorMetadata();
        if (emd == null) {
            return null;
        }
        if (!(emd instanceof ErrorMetadataImpl)) {
            ILazyDataset led = emd.getError();
            try {
                Dataset ed = DatasetUtils.sliceAndConvertLazyDataset(led);
                emd = MetadataFactory.createMetadata(ErrorMetadata.class, new Object[0]);
                this.setMetadata(emd);
                emd.setError(ed);
            }
            catch (MetadataException me) {
                logger.error("Could not create metadata", (Throwable)me);
            }
            catch (DatasetException e) {
                logger.error("Could not get data from lazy dataset", (Throwable)e);
            }
        }
        return ((ErrorMetadataImpl)emd).getSquaredError();
    }

    @Override
    public void setErrorBuffer(Serializable buffer) {
        if (buffer == null) {
            this.clearMetadata(ErrorMetadata.class);
            return;
        }
        IDataset d = (IDataset)this.createFromSerializable(buffer, false);
        ErrorMetadata emd = this.getErrorMetadata();
        if (!(emd instanceof ErrorMetadataImpl)) {
            try {
                emd = MetadataFactory.createMetadata(ErrorMetadata.class, new Object[0]);
                this.setMetadata(emd);
            }
            catch (MetadataException me) {
                logger.error("Could not create metadata", (Throwable)me);
            }
        }
        ((ErrorMetadataImpl)emd).setSquaredError(d);
    }
}

