/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._double.maxinclusive.maxinclusive_3;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive3_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive3_ValidateCTTests test = new maxInclusive3_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final double[] validValues = {0.0, -Double.MIN_VALUE, -1.0, -Double.MAX_VALUE
                                 , Double.NEGATIVE_INFINITY};
    
    final double[] invalidValues = {1.0, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE
                                   , Double.POSITIVE_INFINITY};
    
    JAXBElement<Double> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<Double>)unmarshal("maxInclusive-3-1.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<Double>)unmarshal("maxInclusive-3-1.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<Double>)(new ObjectFactory()).createNISTSchemaDoubleMaxInclusive3(validValues[0]);
        
        return testValid();
    }

    public Status Created002( ) {
        elemObj = (JAXBElement<Double>)(new ObjectFactory()).createNISTSchemaDoubleMaxInclusive3(validValues[0]);
        
        return testInvalid();
    }


}

