/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)DatatypeConverter.test.xml	1.1 05/08/20 Alexey Vishentsev
 * Generated from : api/jakarta_xml/bind/DatatypeConverter/DatatypeConverter.test.xml
 *
 * Provides DatatypeConverter tests.
 * DatatypeConverter tests. Conversion tests are done while unmarshalling
 * xml data.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.DatatypeConverter;

import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.DatatypeConverterInterface;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.TimeZone;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;


public class DatatypeConverterTests extends MultiTest {

 	private static NamespaceContext xsdNamespaceContext = new NamespaceContext(){

        public String getNamespaceURI(String prefix) {
            if("xsd".equals(prefix)){
                return XMLConstants.W3C_XML_SCHEMA_NS_URI;
            }
            return null;
        }

        public String getPrefix(String namespaceURI) {
            if(XMLConstants.W3C_XML_SCHEMA_NS_URI.equals(namespaceURI)){
                return "xsd";
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Collections.singleton("xsd").iterator();
        }
        
    }; 
    
    
    public Status test(DatatypeConverterTestDriver.Test test){
        String document = 
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n"+
        "<jck:root xmlns:jck=\"jck-jaxb-test/DatatypeConverter\"\n"+ 
        "          xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"+ 
        "          xsi:schemaLocation=\"jck-jaxb-test/DatatypeConverter DatatypeConverter.xsd \">\n"+
        "    <child>test</child>\n"+
        "</jck:root>";
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(Root.class);
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        Unmarshaller unmarshaller; 
        try {
            unmarshaller = context.createUnmarshaller();
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create unmarshaller: "+e);
        }
        DatatypeConverterTestDriver.init(test);
        try {
            unmarshaller.unmarshal(new StringReader(document));
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Error on unmarshalling: "+e);
        }
        return DatatypeConverterTestDriver.returnStatus();
    }

    /* standalone interface */
    public static void main(String argv[]) {
        DatatypeConverterTests test = new DatatypeConverterTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public static java.lang.String parseString(java.lang.String lexicalXSDString),
     * parseString method test..
     */
    public Status parseString001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "string";
                    String parsed = DatatypeConverter.parseString(str);
                    if(!str.equals(parsed)){
                        return Status.failed("\""+str+"\" --> \""+parsed+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.math.BigInteger parseInteger(java.lang.String lexicalXSDInteger),
     * parseInteger method test..
     */
    public Status parseInteger001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " +238 ";
                    BigInteger bigI = DatatypeConverter.parseInteger(str);
                    if(!bigI.equals(new BigInteger("238"))){
                        return Status.failed("\""+str+"\" --> \""+bigI+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static int parseInt(java.lang.String lexicalXSDInt),
     * parseInt method test..
     */
    public Status parseInt001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " +238 ";
                    int i = DatatypeConverter.parseInt(str);
                    if(i != 238){
                        return Status.failed("\""+str+"\" --> \""+i+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static long parseLong(java.lang.String lexicalXSDLong),
     * parseLong method test..
     */
    public Status parseLong001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " +238 ";
                    long l = DatatypeConverter.parseLong(str);
                    if(l != 238L){
                        return Status.failed("\""+str+"\" --> \""+l+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static short parseShort(java.lang.String lexicalXSDShort),
     * parseShort method test..
     */
    public Status parseShort001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " +32767 ";
                    short s = DatatypeConverter.parseShort(str);
                    if(s != 32767){
                        return Status.failed("\""+str+"\" --> \""+s+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.math.BigDecimal parseDecimal(java.lang.String lexicalXSDDecimal),
     * parseDecimal method test..
     */
    public Status parseDecimal001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " +12678967.543233 ";
                    BigDecimal bigD = DatatypeConverter.parseDecimal(str);
                    if(!bigD.equals(new BigDecimal("12678967.543233"))){
                        return Status.failed("\""+str+"\" --> \""+bigD+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static float parseFloat(java.lang.String lexicalXSDFloat),
     * parseFloat method test..
     */
    public Status parseFloat001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 1.278e-2 ";
                    float f = DatatypeConverter.parseFloat(str);
                    if(Math.abs(f-0.01278f)>0.0000001f){
                        return Status.failed("\""+str+"\" --> \""+f+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static double parseDouble(java.lang.String lexicalXSDDouble),
     * parseDouble method test..
     */
    public Status parseDouble001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 1.278e-2 ";
                    double d = DatatypeConverter.parseDouble(str);
                    if(Math.abs(d-0.01278)>0.0000001f){
                        return Status.failed("\""+str+"\" --> \""+d+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static boolean parseBoolean(java.lang.String lexicalXSDBoolean),
     * parseBoolean method test..
     */
    public Status parseBoolean001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " true ";
                    boolean b = DatatypeConverter.parseBoolean(str);
                    if(!b){
                        return Status.failed("\""+str+"\" --> \""+b+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static boolean parseBoolean(java.lang.String lexicalXSDBoolean),
     * parseBoolean method test..
     */
    public Status parseBoolean002() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 1 ";
                    boolean b = DatatypeConverter.parseBoolean(str);
                    if(!b){
                        return Status.failed("\""+str+"\" --> \""+b+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static boolean parseBoolean(java.lang.String lexicalXSDBoolean),
     * parseBoolean method test..
     */
    public Status parseBoolean003() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 0 ";
                    boolean b = DatatypeConverter.parseBoolean(str);
                    if(b){
                        return Status.failed("\""+str+"\" --> \""+b+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static boolean parseBoolean(java.lang.String lexicalXSDBoolean),
     * parseBoolean method test..
     */
    public Status parseBoolean004() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " false ";
                    boolean b = DatatypeConverter.parseBoolean(str);
                    if(b){
                        return Status.failed("\""+str+"\" --> \""+b+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static byte parseByte(java.lang.String lexicalXSDByte),
     * parseByte method test..
     */
    public Status parseByte001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 126 ";
                    byte b = DatatypeConverter.parseByte(str);
                    if(b != 126){
                        return Status.failed("\""+str+"\" --> \""+b+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static javax.xml.namespace.QName parseQName(java.lang.String lexicalXSDQName,javax.xml.namespace.NamespaceContext nsc),
     * parseQName method test..
     */
    public Status parseQName001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " xsd:element ";
                    QName qname = DatatypeConverter.parseQName(str,xsdNamespaceContext);
                    if(!"element".equals(qname.getLocalPart()) || !"xsd".equals(qname.getPrefix()) || !XMLConstants.W3C_XML_SCHEMA_NS_URI.equals(qname.getNamespaceURI())){
                        return Status.failed("\""+str+"\" --> \""+qname+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.util.Calendar parseDateTime(java.lang.String lexicalXSDDateTime),
     * parseDateTime method test..
     */
    public Status parseDateTime001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "2000-01-20T12:00:00.7+12:00";

                    Calendar cal = DatatypeConverter.parseDateTime(str);
                    if(cal.get(Calendar.YEAR) !=2000                   ||
                       cal.get(Calendar.MONTH) != Calendar.JANUARY     ||
                       cal.get(Calendar.DAY_OF_MONTH) != 20            ||
                       cal.get(Calendar.HOUR_OF_DAY) != 12             ||
                       cal.get(Calendar.MINUTE) != 0                   ||
                       cal.get(Calendar.SECOND) != 0                   ||
                       cal.get(Calendar.MILLISECOND) != 700            ||
                       cal.get(Calendar.ZONE_OFFSET) != 12/*hours*/*60/*minutes*/*60/*seconds*/*1000/*milliseconds*/){

                        return Status.failed("\""+str+"\" --> \""+cal+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static byte[] parseBase64Binary(java.lang.String lexicalXSDBase64Binary),
     * parseBase64Binary method test..
     */
    public Status parseBase64Binary001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "51IK0w==";
                    byte[] bytes = new byte[]{-25,82,10,-45};
                    byte[] decoded = DatatypeConverter.parseBase64Binary(str);

                    StringBuffer bytesBuffer = new StringBuffer();
                    for(byte b: bytes){
                        bytesBuffer.append(b).append(',');
                    }
                    bytesBuffer.setLength(bytesBuffer.length()-1);
                    StringBuffer decodedBuffer = new StringBuffer();
                    for(byte b: decoded){
                        decodedBuffer.append(b).append(',');
                    }
                    decodedBuffer.setLength(decodedBuffer.length()-1);
                    if(bytesBuffer.length() != decodedBuffer.length() || !bytesBuffer.toString().equals(decodedBuffer.toString())){
                        return Status.failed("\""+str+"\" ("+bytesBuffer+") --> ("+decodedBuffer+")");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static byte[] parseHexBinary(java.lang.String lexicalXSDHexBinary),
     * parseHexBinary method test..
     */
    public Status parseHexBinary001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "E7520AD3";
                    byte[] bytes = new byte[]{-25,82,10,-45};
                    byte[] decoded = DatatypeConverter.parseHexBinary(str);

                    StringBuffer bytesBuffer = new StringBuffer();
                    for(byte b: bytes){
                        bytesBuffer.append(b).append(',');
                    }
                    bytesBuffer.setLength(bytesBuffer.length()-1);
                    StringBuffer decodedBuffer = new StringBuffer();
                    for(byte b: decoded){
                        decodedBuffer.append(b).append(',');
                    }
                    decodedBuffer.setLength(decodedBuffer.length()-1);
                    if(bytesBuffer.length() != decodedBuffer.length() || !bytesBuffer.toString().equals(decodedBuffer.toString())){
                        return Status.failed("\""+str+"\" ("+bytesBuffer+") --> ("+decodedBuffer+")");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static long parseUnsignedInt(java.lang.String lexicalXSDUnsignedInt),
     * parseUnsignedInt method test..
     */
    public Status parseUnsignedInt001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 126 ";
                    long l = DatatypeConverter.parseUnsignedInt(str);
                    if(l != 126){
                        return Status.failed("\""+str+"\" --> \""+l+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static int parseUnsignedShort(java.lang.String lexicalXSDUnsignedShort),
     * parseUnsignedShort method test..
     */
    public Status parseUnsignedShort001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = " 65534 ";
                    int i = DatatypeConverter.parseUnsignedShort(str);
                    if(i != 65534){
                        return Status.failed("\""+str+"\" --> \""+i+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.util.Calendar parseTime(java.lang.String lexicalXSDTime),
     * parseTime method test..
     */
    public Status parseTime001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "03:15:25.05-03:00";

                    Calendar cal = DatatypeConverter.parseDate(str);
                    if(cal.get(Calendar.HOUR_OF_DAY) !=3               ||
                       cal.get(Calendar.MINUTE) != 15                  ||
                       cal.get(Calendar.SECOND) != 25                  ||
                       cal.get(Calendar.MILLISECOND) != 50             ||
                       cal.get(Calendar.ZONE_OFFSET) != -3/*hours*/*60/*minutes*/*60/*seconds*/*1000/*milliseconds*/){

                        return Status.failed("\""+str+"\" --> \""+cal+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.util.Calendar parseDate(java.lang.String lexicalXSDDate),
     * parseDate method test..
     */
    public Status parseDate001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "03:15:25.05-03:00";

                    Calendar cal = DatatypeConverter.parseDate(str);
                    if(cal.get(Calendar.HOUR_OF_DAY) !=3               ||
                       cal.get(Calendar.MINUTE) != 15                  ||
                       cal.get(Calendar.SECOND) != 25                  ||
                       cal.get(Calendar.MILLISECOND) != 50             ||
                       cal.get(Calendar.ZONE_OFFSET) != -3/*hours*/*60/*minutes*/*60/*seconds*/*1000/*milliseconds*/){

                        return Status.failed("\""+str+"\" --> \""+cal+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String parseAnySimpleType(java.lang.String lexicalXSDAnySimpleType),
     * parseAnySimpleType method test..
     */
    public Status parseAnySimpleType001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "string";
                    String parsed = DatatypeConverter.parseAnySimpleType(str);
                    if(!str.equals(parsed)){
                        return Status.failed("\""+str+"\" --> \""+parsed+"\"");
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printString(java.lang.String val),
     * printString method test..
     */
    public Status printString001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String str = "string";
                    String expectedResult = str;
                    String printed = DatatypeConverter.printString(str);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+str+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printInteger(java.math.BigInteger val),
     * printInteger method test..
     */
    public Status printInteger001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    BigInteger bigI = new BigInteger("12382");
                    String expectedResult = bigI.toString();
                    String printed = DatatypeConverter.printInteger(bigI);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+bigI+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printInt(int val),
     * printInt method test..
     */
    public Status printInt001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    int i = 123472;
                    String expectedResult = ""+i;
                    String printed = DatatypeConverter.printInt(i);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+i+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printLong(long val),
     * printLong method test..
     */
    public Status printLong001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    long l = 123472;
                    String expectedResult = ""+l;
                    String printed = DatatypeConverter.printLong(l);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+l+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printShort(short val),
     * printShort method test..
     */
    public Status printShort001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    short s = 23000;
                    String expectedResult = ""+s;
                    String printed = DatatypeConverter.printShort(s);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+s+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printDecimal(java.math.BigDecimal val),
     * printDecimal method test..
     */
    public Status printDecimal001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    BigDecimal bigD = new BigDecimal("12382.234");
                    String expectedResult = bigD.toString();
                    String printed = DatatypeConverter.printDecimal(bigD);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+bigD+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printFloat(float val),
     * printFloat method test..
     */
    public Status printFloat001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    float f = 123.32442f;
                    String expectedResult = ""+f;
                    String printed = DatatypeConverter.printFloat(f);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+f+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printDouble(double val),
     * printDouble method test..
     */
    public Status printDouble001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    double d = 123.32442;
                    String expectedResult = ""+d;
                    String printed = DatatypeConverter.printDouble(d);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+d+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printBoolean(boolean val),
     * printBoolean method test..
     */
    public Status printBoolean001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    boolean b = true;
                    String expectedResult = "true";
                    String printed = DatatypeConverter.printBoolean(b);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+b+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printBoolean(boolean val),
     * printBoolean method test..
     */
    public Status printBoolean002() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    boolean b = false;
                    String expectedResult = "false";
                    String printed = DatatypeConverter.printBoolean(b);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+b+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printByte(byte val),
     * printByte method test..
     */
    public Status printByte001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    byte b = 123;
                    String expectedResult = ""+b;
                    String printed = DatatypeConverter.printByte(b);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+b+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printQName(javax.xml.namespace.QName val,javax.xml.namespace.NamespaceContext nsc),
     * printQName method test..
     */
    public Status printQName001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    QName qname = new QName(XMLConstants.W3C_XML_SCHEMA_NS_URI,"element");
                    String expectedResult = "xsd:element";
                    String printed = DatatypeConverter.printQName(qname,xsdNamespaceContext);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+qname+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printDateTime(java.util.Calendar val),
     * printDateTime method test..
     */
    public Status printDateTime001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+12"));
                    cal.set(Calendar.YEAR,2000);
                    cal.set(Calendar.MONTH,Calendar.JANUARY);
                    cal.set(Calendar.DAY_OF_MONTH,20);
                    cal.set(Calendar.HOUR_OF_DAY,12);
                    cal.set(Calendar.MINUTE,0);
                    cal.set(Calendar.SECOND,0);
                    cal.set(Calendar.MILLISECOND,0);
                    String expectedResult = "2000-01-20T12:00:00+12:00";
                    String printed = DatatypeConverter.printDateTime(cal);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+cal+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printBase64Binary(byte[] val),
     * printBase64Binary method test..
     */
    public Status printBase64Binary001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    byte[] bytes = new byte[]{-25,82,10,-45};
                    String expectedResult = "51IK0w==";
                    String printed = DatatypeConverter.printBase64Binary(bytes);
                    if(!expectedResult.equals(printed)){
                        StringBuffer bytesBuffer = new StringBuffer();
                        bytesBuffer.append('(');
                        for(byte b: bytes){
                            bytesBuffer.append(b).append(',');
                        }
                        bytesBuffer.setLength(bytesBuffer.length()-1);
                        bytesBuffer.append(')');
                        return Status.failed("\""+bytesBuffer+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printHexBinary(byte[] val),
     * printHexBinary method test..
     */
    public Status printHexBinary001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    byte[] bytes = new byte[]{-25,82,10,-45};
                    String expectedResult = "E7520AD3";
                    String printed = DatatypeConverter.printHexBinary(bytes);
                    if(!expectedResult.equals(printed)){
                        StringBuffer bytesBuffer = new StringBuffer();
                        bytesBuffer.append('(');
                        for(byte b: bytes){
                            bytesBuffer.append(b).append(',');
                        }
                        bytesBuffer.setLength(bytesBuffer.length()-1);
                        bytesBuffer.append(')');
                        return Status.failed("\""+bytesBuffer+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printUnsignedInt(long val),
     * printUnsignedInt method test..
     */
    public Status printUnsignedInt001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    long ui = 123;
                    String expectedResult = ""+ui;
                    String printed = DatatypeConverter.printUnsignedInt(ui);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+ui+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printUnsignedShort(int val),
     * printUnsignedShort method test..
     */
    public Status printUnsignedShort001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    int us = 123;
                    String expectedResult = ""+us;
                    String printed = DatatypeConverter.printUnsignedShort(us);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+us+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printTime(java.util.Calendar val),
     * printTime method test..
     */
    public Status printTime001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+12"));
                    cal.set(Calendar.YEAR,2000);
                    cal.set(Calendar.MONTH,Calendar.JANUARY);
                    cal.set(Calendar.DAY_OF_MONTH,20);
                    cal.set(Calendar.HOUR_OF_DAY,12);
                    cal.set(Calendar.MINUTE,0);
                    cal.set(Calendar.SECOND,0);
                    cal.set(Calendar.MILLISECOND,0);
                    String expectedResult = "12:00:00+12:00";
                    String printed = DatatypeConverter.printTime(cal);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+cal+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printDate(java.util.Calendar val),
     * printDate method test..
     */
    public Status printDate001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+12"));
                    cal.set(Calendar.YEAR,2000);
                    cal.set(Calendar.MONTH,Calendar.JANUARY);
                    cal.set(Calendar.DAY_OF_MONTH,20);
                    cal.set(Calendar.HOUR_OF_DAY,12);
                    cal.set(Calendar.MINUTE,0);
                    cal.set(Calendar.SECOND,0);
                    cal.set(Calendar.MILLISECOND,0);
                    String expectedResult = "2000-01-20+12:00";
                    String printed = DatatypeConverter.printDate(cal);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+cal+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static java.lang.String printAnySimpleType(java.lang.String val),
     * printAnySimpleType method test..
     */
    public Status printAnySimpleType001() {
        return test(new DatatypeConverterTestDriver.Test(ref){
                public Status test() {
                    String anySimpleType = "string";
                    String expectedResult = anySimpleType;
                    String printed = DatatypeConverter.printAnySimpleType(anySimpleType);
                    if(!expectedResult.equals(printed)){
                        return Status.failed("\""+anySimpleType+"\" --> \""+printed+"\"  expected: "+expectedResult);
                    }
                    return Status.passed("Ok");
                }
            });
                }

    /**
     * Assertion testing
     * for public static void setDatatypeConverter(DatatypeConverterInterface converter),
     * setDatatypeConverter method test..
     */
    public Status setDatatypeConverter001() {
        DatatypeConverterInterface aConverter = new DatatypeConverterInterface(){
                public String parseString(String lexicalXSDString) {
                    return null;
                }

                public BigInteger parseInteger(String lexicalXSDInteger) {
                    return null;
                }

                public int parseInt(String lexicalXSDInt) {
                    return 0;
                }

                public long parseLong(String lexicalXSDLong) {
                    return 0;
                }

                public short parseShort(String lexicalXSDShort) {
                    return 0;
                }

                public BigDecimal parseDecimal(String lexicalXSDDecimal) {
                    return null;
                }

                public float parseFloat(String lexicalXSDFloat) {
                    return 0;
                }

                public double parseDouble(String lexicalXSDDouble) {
                    return 0;
                }

                public boolean parseBoolean(String lexicalXSDBoolean) {
                    return false;
                }

                public byte parseByte(String lexicalXSDByte) {
                    return 0;
                }

                public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
                    return null;
                }

                public Calendar parseDateTime(String lexicalXSDDateTime) {
                    return null;
                }

                public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
                    return null;
                }

                public byte[] parseHexBinary(String lexicalXSDHexBinary) {
                    return null;
                }

                public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
                    return 0;
                }

                public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
                    return 0;
                }

                public Calendar parseTime(String lexicalXSDTime) {
                    return null;
                }

                public Calendar parseDate(String lexicalXSDDate) {
                    return null;
                }

                public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
                    return null;
                }

                public String printString(String val) {
                    return null;
                }

                public String printInteger(BigInteger val) {
                    return null;
                }

                public String printInt(int val) {
                    return null;
                }

                public String printLong(long val) {
                    return null;
                }

                public String printShort(short val) {
                    return null;
                }

                public String printDecimal(BigDecimal val) {
                    return null;
                }

                public String printFloat(float val) {
                    return null;
                }

                public String printDouble(double val) {
                    return null;
                }

                public String printBoolean(boolean val) {
                    return null;
                }

                public String printByte(byte val) {
                    return null;
                }

                public String printQName(QName val, NamespaceContext nsc) {
                    return null;
                }

                public String printDateTime(Calendar val) {
                    return null;
                }

                public String printBase64Binary(byte[] val) {
                    return null;
                }

                public String printHexBinary(byte[] val) {
                    return null;
                }

                public String printUnsignedInt(long val) {
                    return null;
                }

                public String printUnsignedShort(int val) {
                    return null;
                }

                public String printTime(Calendar val) {
                    return null;
                }

                public String printDate(Calendar val) {
                    return null;
                }

                public String printAnySimpleType(String val) {
                    return null;
                }
            };
            try{
                DatatypeConverter.setDatatypeConverter(aConverter);
                DatatypeConverter.setDatatypeConverter(aConverter);
            }catch(Throwable t){
                t.printStackTrace(ref);
                return Status.failed("Datatype converter has thrown "+t);
            }
            return Status.passed("Ok");
                }

    /**
     * Assertion testing
     * for public static void setDatatypeConverter(DatatypeConverterInterface converter),
     * setDatatypeConverter method test..
     */
    public Status setDatatypeConverter002() {
        try{
                DatatypeConverter.setDatatypeConverter(null);
            }catch(IllegalArgumentException x){
                return Status.passed("Ok");
            }catch(Throwable t){
                t.printStackTrace(ref);
                return Status.failed("setDatatypeConverter with null parameter should throw IllegalArgumentException, but what thrown is "+t);
            }
            return Status.failed("setDatatypeConverter with null parameter should throw IllegalArgumentException.");
                }
}
