/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jaxrs.spec.resource.requestmatching;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("yas")
public class YetAnotherSubresource {
  @GET
  @Produces("text/*")
  public String getTextStar() {
    return "text/*";
  }

  @POST
  @Consumes("text/*")
  public String postTextStar() {
    return "text/*";
  }

  @POST
  @Consumes("text/xml;qs=0.7")
  public String xml() {
    return MediaType.TEXT_XML;
  }

  @GET
  @Produces("text/xml;qs=0.7")
  public String xmlGet() {
    return MediaType.TEXT_XML;
  }

  @GET
  @Produces("application/xml;qs=0.8")
  public String appXmlGet() {
    return MediaType.APPLICATION_XML;
  }

  @GET
  @Produces("testiii/textiii;qs=0.7")
  public String testiiiTextiiiGet() {
    return "testiii/textiii";
  }

  @GET
  @Produces("testi/*")
  public String testStar() {
    return "test/*";
  }

  @GET
  @Produces("testi/text")
  public String testText() {
    return "test/text";
  }

  @GET
  @Produces("testii/texta")
  public String testIITextA() {
    return "textA";
  }

  @GET
  @Produces("testii/textb")
  public String testIITextB() {
    return "textB";
  }

}
