/*
 * Copyright (c) 2007, 2018 Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2002 International Business Machines Corp. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jaxrpc.sharedwebservices.helloservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;

public class DummyServlet extends HttpServlet {

  public void init(ServletConfig servletConfig) throws ServletException {
    super.init(servletConfig);
    TestUtil.logTrace("init");
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {
    TestUtil.logTrace("doGet");

    res.setContentType("text/plain");
    PrintWriter out = res.getWriter();

    out.println("Hello, World!");
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {
    TestUtil.logTrace("doPost");
    doGet(req, res);
  }
}
