/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.attributeorder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.attributeorder.model.ExtendedContainer;
import com.sun.ts.tests.jsonb.defaultmapping.attributeorder.model.SimpleContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class AttributeOrderMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        AttributeOrderMappingTest t = new AttributeOrderMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testClassAttributeOrder() throws EETest.Fault {
        String toMatch;
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setIntInstance(0);
                this.setStringInstance("Test String");
                this.setLongInstance(0L);
            }
        });
        if (!jsonString.matches(toMatch = "\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            System.out.append("serialized json string ").println(jsonString);
            System.out.append("does not match expected ").println(toMatch);
            throw new EETest.Fault("Failed to lexicographically order class attributes.");
        }
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", SimpleContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to set class attributes in order of appearance.");
        }
    }

    public Status testExtendedClassAttributeOrder() throws EETest.Fault {
        String toMatch;
        String jsonString = this.jsonb.toJson((Object)new ExtendedContainer(){
            {
                this.setIntInstance(0);
                this.setStringInstance("Test String");
                this.setLongInstance(0L);
                this.setFloatInstance(0.0f);
                this.setShortInstance((short)0);
            }
        });
        if (!jsonString.matches(toMatch = "\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\,\\s*\"floatInstance\"\\s*\\:\\s*0.0\\s*,\\s*\"shortInstance\"\\s*\\:\\s*0\\s*}")) {
            System.out.append("serialized json string ").println(jsonString);
            System.out.append("does not match expected ").println(toMatch);
            throw new EETest.Fault("Failed to correctly order extended class attributes.");
        }
        jsonString = "{ \"intInstance\" : 1, \"shortInstance\" : 0, \"stringInstance\" : \"Test String\", \"floatInstance\" : 0.0, \"longInstance\" : 0 }";
        ExtendedContainer unmarshalledObject = (ExtendedContainer)this.jsonb.fromJson(jsonString, ExtendedContainer.class);
        if (unmarshalledObject.getIntInstance() != 5) {
            throw new EETest.Fault("Failed to set extended class attributes in order of appearance.");
        }
        return Status.passed((String)"OK");
    }
}

