/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.mdb.dest.common;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public abstract class DestBeanBase {
    public static final String test1 = "test1";
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;

    public abstract EJBContext getEJBContext();

    public void onMessage(Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        int testNumber = 0;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            testNumber = msg.getIntProperty("TestCaseNum");
        }
        catch (JMSException e) {
            status = false;
            reason = this.getClass().getName() + "Failed to get test name/number from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
            return;
        }
        if (testname.equals(test1) && testNumber == 0) {
            status = true;
            reason = this.getClass().getName() + " received message from " + testname + ", status " + status;
        } else {
            status = false;
            reason = this.getClass().getName() + "Unrecognized testname: " + testname + ", testnum: " + testNumber;
        }
        StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
    }
}

