/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.TelephoneNumber;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Properties;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.TelephoneNumber;

public class JAXRClient
extends JAXRCommonClient {
    private static final int SETAREACODE = 0;
    private static final int SETCOUNTRYCODE = 1;
    private static final int SETEXTENSION = 2;
    private static final int SETURL = 3;
    private static final int GETAREACODE = 4;
    private static final int GETCOUNTRYCODE = 5;
    private static final int GETEXTENSION = 6;
    private static final int GETURL = 7;
    private static final int NUM_METHODS = 8;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void telephoneNumber_setGetNumberTest() throws EETest.Fault {
        String testName = "telephoneNumber_setGetNumberTest";
        String telno = "123-1234";
        boolean pass = false;
        try {
            TelephoneNumber number = this.blm.createTelephoneNumber();
            this.debug.add("Setting the number to " + telno + "\n");
            number.setNumber(telno);
            String retNo = number.getNumber();
            this.debug.add("getNumber returned " + retNo + "\n");
            if (retNo.equals(telno)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void telephoneNumber_setGetTypeTest() throws EETest.Fault {
        String testName = "telephoneNumber_setGetTypeTest";
        String type = "fax";
        boolean pass = false;
        try {
            TelephoneNumber number = this.blm.createTelephoneNumber();
            this.debug.add("Setting the type to " + type + "\n");
            number.setType(type);
            String rettype = number.getType();
            this.debug.add("getType returned " + rettype + "\n");
            if (rettype.equals(type)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void TelephoneNumber_UnsupportedCapabilityException_Test() throws EETest.Fault {
        String testName = "TelephoneNumber_UnsupportedCapabilityException_Test";
        int failcount = 0;
        try {
            int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            this.debug.add("This provider reports capability level = " + providerlevel + "\n");
            TelephoneNumber nm = this.blm.createTelephoneNumber();
            String areaCode = "302";
            String countryCode = "IT";
            String extension = "1234";
            String url = "url";
            for (int method = 0; method < 8; ++method) {
                try {
                    switch (method) {
                        case 0: {
                            this.debug.add("Calling setAreaCode\n");
                            nm.setAreaCode(areaCode);
                            break;
                        }
                        case 1: {
                            this.debug.add("Calling setCountryCode\n");
                            nm.setCountryCode(countryCode);
                            break;
                        }
                        case 2: {
                            this.debug.add("Calling setExtension\n");
                            nm.setExtension(extension);
                            break;
                        }
                        case 3: {
                            this.debug.add("Calling setUrl\n");
                            nm.setUrl(url);
                            break;
                        }
                        case 4: {
                            this.debug.add("Calling getAreaCode\n");
                            String retAreaCode = nm.getAreaCode();
                            if (providerlevel <= 0 || nm.getAreaCode().equals(areaCode)) break;
                            this.debug.add(" level 1 provider -  failed to get a match for areacode\n");
                            ++failcount;
                            break;
                        }
                        case 5: {
                            this.debug.add("Calling getCountryCode\n");
                            String retCountryCode = nm.getCountryCode();
                            if (providerlevel <= 0 || nm.getCountryCode().equals(countryCode)) break;
                            this.debug.add(" level 1 provider -  failed to get a match for countrycode\n");
                            ++failcount;
                            break;
                        }
                        case 6: {
                            this.debug.add("Calling getExtension\n");
                            String retExtension = nm.getExtension();
                            if (providerlevel <= 0 || nm.getExtension().equals(extension)) break;
                            this.debug.add(" level 1 provider -  failed to get a match for extension\n");
                            ++failcount;
                            break;
                        }
                        case 7: {
                            this.debug.add("Calling getUrl\n");
                            String retUrl = nm.getUrl();
                            if (providerlevel <= 0 || nm.getUrl().equals(url)) break;
                            this.debug.add(" level 1 provider -  failed to get a match for url\n");
                            ++failcount;
                            break;
                        }
                        default: {
                            throw new EETest.Fault("Test Error - Unknown method: " + method);
                        }
                    }
                    if (providerlevel != 0) continue;
                    this.debug.add("Error: UnsupportedCapabilityException expected for capability level 0\n");
                    ++failcount;
                    continue;
                }
                catch (UnsupportedCapabilityException ue) {
                    if (providerlevel == 0) {
                        this.debug.add("Good it threw an UnsupportedCapabilityException\n");
                        TestUtil.printStackTrace((Throwable)ue);
                        continue;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this capability level\n");
                    ++failcount;
                    continue;
                }
                catch (Exception ee) {
                    this.debug.add("Error threw an unexpected exception \n");
                    TestUtil.printStackTrace((Throwable)ee);
                    ++failcount;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        if (failcount > 0) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

