/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.QNameHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.QNameHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final QName myQName = new QName("http://someURI.org/", "someLocalPart");

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void QNameHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"QNameHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QNameHolder() ...");
            QNameHolder n = new QNameHolder();
            if (n != null) {
                TestUtil.logMsg((String)"QNameHolder object created successfully");
            } else {
                TestUtil.logErr((String)"QNameHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("QNameHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("QNameHolderConstructorTest1 failed");
        }
    }

    public void QNameHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"QNameHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QNameHolder(QName) ...");
            QNameHolder n = new QNameHolder(myQName);
            if (n != null) {
                TestUtil.logMsg((String)"QNameHolder object created successfully");
            } else {
                TestUtil.logErr((String)"QNameHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("QNameHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("QNameHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QNameHolder() ...");
            QNameHolder n = new QNameHolder();
            if (n != null) {
                QName v = n.value;
                if (v == null) {
                    TestUtil.logMsg((String)"Value set to null as expected");
                } else {
                    TestUtil.logErr((String)("Value: expected - null, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QNameHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QNameHolder(QName) ...");
            QNameHolder n = new QNameHolder(myQName);
            if (n != null) {
                QName v = n.value;
                if (v.equals(myQName)) {
                    TestUtil.logMsg((String)("Value set as expected to " + myQName));
                } else {
                    TestUtil.logErr((String)("Value: expected - " + myQName + ", received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QNameHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

