/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.detach.oneXmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.detach.oneXmany.A;
import com.sun.ts.tests.jpa.core.entitytest.detach.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionRolledbackException;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1XMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detach1XMTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Persist Instance");
            TestUtil.logTrace((String)"Call contains to determined if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                TestUtil.logTrace((String)"entity is not detached, cannot proceed with test.");
                pass = false;
            } else {
                try {
                    TestUtil.logTrace((String)"Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"IllegalArgumentException thrown trying to persist a detached entity", (Throwable)iae);
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    TestUtil.logTrace((String)"entityExistsException thrown trying to persist a detached entity", (Throwable)eee);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detach1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1XMTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detach1XMTest2");
        boolean pass = false;
        try {
            B b1 = new B("1", "b1", 2);
            B b2 = new B("2", "b2", 2);
            B b3 = new B("3", "b3", 2);
            B b4 = new B("4", "b4", 2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.clearCache();
            TestUtil.logTrace((String)"Begin Transaction and make sure instance is detached prior to remove");
            this.getEntityTransaction().begin();
            if (!this.getEntityManager().contains((Object)aRef) && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    TestUtil.logTrace((String)"aref is detached, Try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"IllegalArgumentException thrown trying to remove a detached entity", (Throwable)iae);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)("Unexpected exception caught trying to  remove entity instance :" + fe));
            }
        }
        if (!pass) {
            throw new EETest.Fault("detach1XMTest2 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

