/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimeoutStatusBean;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;

public class ClientBase
extends EJBLiteClientBase {
    protected static final long WAIT_FOR_TIMEOUT_STATUS = 60000L;
    protected static final long WAIT_FOR_NO_TIMEOUT_STATUS = 60000L;
    protected static final int NUM_OF_RECURRING_RECORDS = 3;
    protected static final long POLL_INTERVAL = 1000L;
    protected static final long DEFAULT_DURATION = 100L;
    protected static final long DEFAULT_INTERVAL = 100L;
    @EJB(beanName="TimeoutStatusBean")
    protected TimeoutStatusBean statusSingleton;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        if (this.needToRemoveStatusAndRecords()) {
            this.removeStatusAndRecords(new String[0]);
        }
    }

    protected boolean needToRemoveStatusAndRecords() {
        return true;
    }

    protected void passIfNoTimeout(long ... waitMillis) {
        this.passIfNoTimeout(this.getTestName(), waitMillis);
    }

    protected void passIfNoTimeout(String timerName, long ... waitMillis) {
        long waitFor = 60000L;
        if (waitMillis.length != 0) {
            waitFor = waitMillis[0];
        }
        Boolean status = this.pollTimeoutStatus(timerName, waitFor, false);
        this.assertEquals("Timeout status must not be set.", null, status);
        this.assertEquals("Timeout result must not be set.", 0, this.statusSingleton.getRecords(timerName).size());
    }

    protected void passIfTimeout(long ... waitMillis) {
        this.passIfTimeout(this.getTestName(), waitMillis);
    }

    protected void passIfTimeout(String timerName, long ... waitMillis) {
        long waitFor = 60000L;
        if (waitMillis.length != 0) {
            waitFor = waitMillis[0];
        }
        Boolean status = this.pollTimeoutStatus(timerName, waitFor, false);
        this.appendReason(this.statusSingleton.getRecords(timerName));
        this.assertEquals("Check timeout status", Boolean.TRUE, status);
    }

    protected void passIfTimeoutOnce(long ... waitMillis) {
        this.passIfTimeoutOnce(this.getTestName(), waitMillis);
    }

    protected void passIfTimeoutOnce(String timerName, long ... waitMillis) {
        this.passIfTimeout(timerName, waitMillis);
        long waitFor = waitMillis.length != 0 ? waitMillis[0] : 60000L;
        TestUtil.sleepMsec((int)((int)waitFor));
        this.assertEquals("Check num of expirations", 1, this.statusSingleton.getRecords(timerName).size());
    }

    protected void passIfRecurringTimeout(long ... waitMillis) {
        this.passIfRecurringTimeout(this.getTestName(), waitMillis);
    }

    protected void passIfRecurringTimeout(String timerName, long ... waitMillis) {
        long waitFor = 180000L;
        if (waitMillis.length != 0) {
            waitFor = waitMillis[0];
        }
        Boolean status = this.pollTimeoutStatus(timerName, waitFor, true);
        List<String> records = this.statusSingleton.getRecords(timerName);
        this.appendReason(records);
        this.assertEquals("Check timeout status", Boolean.TRUE, status);
        this.assertGreaterThan("Check num of timeout records", records.size(), 2L);
    }

    private Boolean pollTimeoutStatus(String timerName, long waitMillis, boolean recurringTimer) {
        long end = System.currentTimeMillis() + waitMillis;
        Boolean status = null;
        List<Object> records = Collections.emptyList();
        if (recurringTimer) {
            while (records.size() < 3 && System.currentTimeMillis() < end) {
                TestUtil.sleepMsec((int)1000);
                records = this.statusSingleton.getRecords(timerName);
            }
            status = this.statusSingleton.getStatus(timerName);
            if (records.size() < 3) {
                Helper.getLogger().fine("Polling recurring Timeout records timed out after " + waitMillis + " millis for timerName " + timerName);
            }
        } else {
            while (status == null && System.currentTimeMillis() < end) {
                TestUtil.sleepMsec((int)1000);
                status = this.statusSingleton.getStatus(timerName);
            }
            if (status == null) {
                Helper.getLogger().fine("Polling Timeout status timed out after " + waitMillis + " millis for timerName " + timerName);
            }
        }
        return status;
    }

    protected void removeStatusAndRecords(String ... timerName) {
        String tn = timerName.length == 0 ? this.getTestName() : timerName[0];
        this.statusSingleton.removeStatus(tn);
        this.statusSingleton.removeRecords(tn);
    }
}

