/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.CSIv2TestLogicImpl;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class CSIv2SessionBean
implements SessionBean {
    private SessionContext context;
    private Properties hProps = null;

    public void ejbCreate(Properties p, boolean recording) throws CreateException {
        if (recording) {
            this.methodEJBCreateInvoke(p);
        } else {
            this.methodEJBCreate(p);
        }
    }

    private void methodEJBCreate(Properties p) throws CreateException {
        try {
            this.hProps = p;
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    private void methodEJBCreateInvoke(Properties p) throws CreateException {
        try {
            this.hProps = p;
            TestUtil.init((Properties)p);
            TestUtil.logTrace((String)"CSIv2SessionBean.ejbCreateInvoke()");
            CSIv2Log log = CSIv2Log.getLog();
            log.logStartServer();
            log.logInvocationPrincipal(this.context.getCallerPrincipal().getName());
            TestUtil.logMsg((String)("CSIv2SessionBean caller principal : " + this.context.getCallerPrincipal().getName()));
            log.logEndServer();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        throw new CreateException("(expected result)");
    }

    public void invoke(ArrayList chain, Properties p) {
        TestUtil.logTrace((String)"CSIv2SessionBean.invoke()");
        CSIv2TestLogicImpl csiv2TestLogicImpl = new CSIv2TestLogicImpl();
        CSIv2Log log = CSIv2Log.getLog();
        log.logStartServer();
        log.logInvocationPrincipal(this.context.getCallerPrincipal().getName());
        csiv2TestLogicImpl.invoke(chain, p);
        log.logEndServer();
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }
}

