/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ConnectionHelper {
    private static final String CLASSNAME = ConnectionHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    public static final String jndiName = "java:module/env/jdbc/orderDB";
    public static final String INSERT_INVENTORY = "insert into inventory values(?, ?)";
    public static final String UPDATE_INVENTORY = "update inventory set quantity = ? where itemID = ?";
    public static final String SELECT_INVENTORY = "select itemID, quantity from inventory where itemID = ?";
    public static final String DELETE_INVENTORY = "delete from Inventory where itemID = ?";
    public static final String DELETE_ALL_ORDERS = "delete from Orders where orderID > 0";
    public static final String INSERT_ORDER = "insert into Orders values(DEFAULT, ?, ?)";
    public static final String COUNT_ORDERS = "select COUNT(*) AS rowcount from Orders";

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        Connection conn = dataSource.getConnection();
        return conn;
    }

    public static Connection getConnection(DataSource dataSource, boolean autoCommit) throws SQLException {
        Connection conn = dataSource.getConnection();
        conn.setAutoCommit(autoCommit);
        return conn;
    }

    public static void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, rs, statement});
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }
}

