/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.stateful.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.stateful.common.SecTest;
import com.sun.ts.tests.ejb.ee.sec.stateful.common.SecTestHome;
import com.sun.ts.tests.ejb.ee.sec.stateful.common.SecTestRoleRef;
import com.sun.ts.tests.ejb.ee.sec.stateful.common.SecTestRoleRefHome;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class TestEJB
implements SessionBean {
    private static final String ejb1name = "java:comp/env/ejb/SecTest";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRef";
    private SecTestHome ejb1home = null;
    private SecTest ejb1ref = null;
    private SecTestRoleRefHome ejb2home = null;
    private SecTestRoleRef ejb2ref = null;
    private SessionContext sctx = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private Properties props = null;
    private TSNamingContext nctx = null;

    public void ejbCreate(Properties p) throws CreateException {
        this.props = p;
        try {
            TestUtil.init((Properties)p);
            this.setup();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"TestEJB initLogging failed.");
            throw new CreateException(e.getMessage());
        }
    }

    void setup() {
        try {
            this.nctx = new TSNamingContext();
            this.ejb1home = (SecTestHome)this.nctx.lookup(ejb1name, SecTestHome.class);
            this.ejb2home = (SecTestRoleRefHome)this.nctx.lookup(ejb2name, SecTestRoleRefHome.class);
            TestUtil.logMsg((String)"Setup OK in TestEJB");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in Setup: ", (Throwable)e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public boolean IsCallerB1(String caller) {
        String name = this.sctx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    public boolean InRole(String role) {
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbNotAuthz() {
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            this.ejb1ref.remove();
            return false;
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)"Caught java.rmi.RemoteException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    private void cleanup(SecTest ejbref) {
        if (ejbref != null) {
            try {
                ejbref.remove();
                ejbref = null;
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Cannot remove the bean: ", (Throwable)ex);
            }
        } else {
            TestUtil.logMsg((String)"ejbref == null");
        }
    }

    public boolean EjbIsAuthz() {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean EjbSecRoleRef(String role) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRef1(String role) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRefScope(String role) {
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
            this.ejb2ref = this.ejb2home.create(this.props);
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            this.ejb2ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            this.ejb1ref.remove();
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1ref = this.ejb1home.create(this.props);
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            this.ejb1ref.remove();
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    public boolean checktest1() {
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.checktest1();
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception for checktest1: ", (Throwable)e);
            return false;
        }
    }

    public boolean excludetest1() {
        try {
            this.ejb1ref = this.ejb1home.create(this.props);
            boolean result = this.ejb1ref.excludetest1();
            TestUtil.logErr((String)"Should not be here.");
            this.ejb1ref.remove();
            return false;
        }
        catch (RemoteException e) {
            TestUtil.logTrace((String)"Got expected RemoteException");
            return true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Got wrong Exception in excludetest1:", (Throwable)ex);
            return false;
        }
    }
}

