/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topicConnection;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.ConnectionMetaData;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicConnectionTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.topicConnection.TopicConnectionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        TopicConnectionTests theTests = new TopicConnectionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void connNotStartedTopicTest() throws EETest.Fault {
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        int NUM_MSGS = 5;
        try {
            int i;
            Topic topic = null;
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TopicConnection nonStartedConn = null;
            TopicSession nonStartedSess = null;
            TopicSubscriber nonStartedSub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            topic = this.tool.getDefaultTopic();
            nonStartedConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(nonStartedConn);
            nonStartedSess = nonStartedConn.createTopicSession(false, 1);
            nonStartedSub = nonStartedSess.createSubscriber(topic);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Creating message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "connNotStartedTopicTest");
            this.logMsg("Publishing messages");
            for (i = 0; i < 5; ++i) {
                messageSent.setText("just a test. Msg num " + i);
                this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            }
            this.logMsg("Receive  messages on started connection");
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                if (messageReceived != null) continue;
                this.logMsg("Fail: Did not receive expected message");
                pass = false;
            }
            this.logMsg("Ensure messages not received on non-started connection");
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)nonStartedSub.receiveNoWait();
                if (messageReceived == null) continue;
                this.logMsg("Fail: Received message on a non-started connection");
                pass = false;
            }
            this.logMsg("Ensure messages received on now started connection");
            nonStartedConn.start();
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)nonStartedSub.receive(this.timeout);
                if (messageReceived != null) continue;
                this.logMsg("Fail: Did not receive expected message");
                pass = false;
            }
            nonStartedConn.close();
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("connNotStartedTopicTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaDataTests() throws EETest.Fault {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            data = this.tool.getDefaultTopicConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultTopicConnection().close();
            }
            catch (Exception e) {
                this.logErr("Error closing TopicConnection in metaDataTests : ", e);
            }
        }
        try {
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            data = this.tool.getDefaultConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultConnection().close();
            }
            catch (Exception e) {
                this.logErr("Error closing Connection in metaDataTests : ", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("Error: metaDataTests failed");
        }
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            TestUtil.logTrace((String)("JMSVersion=" + tmp2));
            if (!tmp2.equals("2.0")) {
                this.logErr("Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            TestUtil.logTrace((String)("JMSMajorVersion=" + tmp3));
            if (tmp3 != 2) {
                this.logErr("Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for JMSMajorVersion: ", e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            TestUtil.logTrace((String)("JMSMinorVersion=" + tmp4));
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for JMSMinorVersion: ", e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            TestUtil.logTrace((String)("JMSProviderName=" + tmp));
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for JMSProviderName: ", e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            TestUtil.logTrace((String)("JMSProviderVersion=" + tmp));
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for ProviderVersion: ", e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            TestUtil.logTrace((String)("ProviderMajorVersion=" + tmp5));
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for ProviderMajorVersion: ", e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            TestUtil.logTrace((String)("ProviderMinorVersion=" + tmp6));
        }
        catch (Exception e) {
            this.logErr("Error: incorrect type returned for ProviderMinorVersion: ", e);
            pass = false;
        }
        return pass;
    }
}

