/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.ejb.wrappers;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class BMPWrapper
implements EntityBean {
    private CoffeeBean cache;
    protected TSNamingContext nctx = null;
    protected EntityContext ectx = null;
    private CoffeeDAO dao = null;

    public void setEntityContext(EntityContext ctx) throws EJBException {
        TestUtil.logTrace((String)"[BMPWrapper] setEntityContext()");
        this.ectx = ctx;
        try {
            TestUtil.logMsg((String)"[BMPWrapper] Obtaining TS Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("[BMPWrapper] Naming Exception : " + e));
            throw new EJBException("Cannot obtain Naming Context" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[BMPWrapper] Caught exception: " + e));
            throw new EJBException("Caught exception: " + e);
        }
    }

    public Integer ejbCreate(Properties props, int id, String name, float price) throws CreateException {
        try {
            TestUtil.logTrace((String)"[BMPWrapper] ejbCreate()");
            TestUtil.logTrace((String)"[BMPWrapper] Initialize remote logging");
            TestUtil.init((Properties)props);
            TestUtil.logTrace((String)"[BMPWrapper] DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            TestUtil.logTrace((String)"[BMPWrapper] Create new row...");
            this.dao.create(id, name, price);
            this.cache = new CoffeeBean(id, name, price);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"[BMPWrapper] Unexpected exception ", (Throwable)e);
            throw new CreateException("Caught exception : " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(id);
    }

    public void ejbPostCreate(Properties props, int id, String name, float price) {
        TestUtil.logTrace((String)"[BMPWrapper] ejbPostCreate()");
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"[BMPWrapper] unsetEntityContext()");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"[BMPWrapper] ejbRemove()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[BMPWrapper] get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"[BMPWrapper] Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[BMPWrapper] Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("[BMPWrapper] Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("[BMPWrapper] Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"[BMPWrapper] ejbActivate()");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"[BMPWrapper] ejbPassivate()");
    }

    public void ejbLoad() throws EJBException {
        TestUtil.logTrace((String)"[BMPWrapper] ejbLoad()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[BMPWrapper] Get DAO");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"[BMPWrapper] Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[BMPWrapper] Load row...");
            this.cache = this.dao.load((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("[BMPWrapper] No such entity exists: " + e));
            throw new NoSuchEntityException("[ejbLoad] DAOException" + e);
        }
        catch (Exception e) {
            throw new EJBException("[ejbLoad] Unable to init DAO " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() throws EJBException {
        TestUtil.logTrace((String)"[BMPWrapper] ejbStore()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[BMPWrapper] Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"[BMPWrapper] Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[BMPWrapper] Store row...");
            this.dao.store(this.cache);
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("[BMPWrapper] No such entity: " + e));
            throw new NoSuchEntityException("[ejbStore] DAOException" + e);
        }
        catch (Exception e) {
            throw new EJBException("[ejbStore] Unable to init DAO");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"[BMPWrapper] ejbFindByPrimaryKey()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[BMPWrapper] Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("[BMPWrapper] Key not found: " + key);
            }
            catch (DAOException e) {
                throw new FinderException("DAOException " + e);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }
}

