/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.session.stateless.bm;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.wrappers.StatelessWrapper;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import com.sun.ts.tests.ejb.ee.timer.common.TimerInfo;
import java.io.Serializable;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.transaction.UserTransaction;

public class TestBeanEJB
extends StatelessWrapper
implements TimedObject {
    private UserTransaction ut;
    private static final String queueName = "java:comp/env/jms/MyQueue";
    private static final String queueFactoryName = "java:comp/env/jms/MyQueueConnectionFactory";
    private static final String role = "Manager";
    private static final String[] expected = new String[]{"true", "true", "false", "true", "true", "true", "true", "true", "true", "true", "true", "true", "true", "false", "true", "true", "false", "true", "true"};
    private static final boolean[] skip = new boolean[]{false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, true, false, false};

    public TestBeanEJB() {
        TestUtil.logTrace((String)"TestBeanEJB no arg constructor");
    }

    public void ejbTimeout(Timer timer) {
        int timeoutAction;
        QueueConnectionFactory qcFactory;
        Queue queue;
        String msg = null;
        TestUtil.logTrace((String)("EJB_TIMEOUT: ejbTimeout called at " + System.currentTimeMillis()));
        try {
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            Serializable sz = timer.getInfo();
            this.ut.commit();
            if (!(sz instanceof Integer)) {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No action required");
                return;
            }
            TestUtil.logTrace((String)"EJB_TIMEOUT: finding jms resources...");
            queue = (Queue)this.nctx.lookup(queueName);
            qcFactory = (QueueConnectionFactory)this.nctx.lookup(queueFactoryName);
            timeoutAction = (Integer)sz;
            TestUtil.logTrace((String)("EJB_TIMEOUT: timeoutAction is " + timeoutAction + " at " + System.currentTimeMillis()));
        }
        catch (Exception e) {
            TimerImpl.handleException("ejbTimeout initialization", e);
            return;
        }
        switch (timeoutAction) {
            case -1: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No message sent - return");
                return;
            }
            case 1: {
                msg = "hello from ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Access OK, sending JMS message");
                break;
            }
            case 2: {
                msg = TimerImpl.accessCheckedMethod(this.nctx) ? "checked method successfully accessed in ejbTimeout" : "checked method access failed in ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Sending results of attempt to access checked method...");
                break;
            }
            case 5: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: Getting timer handle...");
                try {
                    this.ut.begin();
                    TimerHandle handle = TimerImpl.getTimerHandleFromEjbTimeout(this.sctx.getTimerService(), 5);
                    if (handle == null) {
                        this.ut.commit();
                        TestUtil.logErr((String)"EJB_TIMEOUT: Null handle received from getTimerHandleFromEjbTimeout()");
                        msg = "Timer handle serialization failed in ejbTimeout";
                        break;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying handle is serializable...");
                    if (!TimerImpl.isSerializable(handle)) {
                        this.ut.commit();
                        TestUtil.logErr((String)"EJB_TIMEOUT: Timer handle is not serializable");
                        msg = "Timer handle serialization failed in ejbTimeout";
                        break;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: Getting deserialized handle...");
                    TimerHandle deserializedHandle = TimerImpl.getDeserializedHandle(handle);
                    TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying timers are identical...");
                    if (!TimerImpl.timersAreIdentical(handle, deserializedHandle)) {
                        this.ut.commit();
                        TestUtil.logErr((String)"EJB_TIMEOUT: Timers are not identical");
                        msg = "Timer handle serialization failed in ejbTimeout";
                        break;
                    }
                    this.ut.commit();
                    msg = "Timer handle successfully serialized in ejbTimeout";
                }
                catch (Exception e) {
                    TimerImpl.handleException("ejb_timeout serialization", e);
                }
                break;
            }
            case 6: {
                Properties props = TimerImpl.doOperationTests((EJBContext)this.sctx, this.nctx, timer, skip, role, 1);
                boolean results = TimerImpl.checkOperationsTestResults(props, expected, skip);
                msg = results ? "allowed methods test successful in ejbTimeout" : "allowed methods test failed in ejbTimeout";
                break;
            }
            default: {
                msg = "Invalid action specified in ejbTimeout";
            }
        }
        TestUtil.logTrace((String)("EJB_TIMEOUT: Sending message at " + System.currentTimeMillis()));
        try {
            this.ut.begin();
            TimerImpl.sendMessage(queue, qcFactory, msg);
            this.ut.commit();
        }
        catch (Exception e) {
            TimerImpl.handleException("ejb_timeout message sending", e);
        }
    }

    public boolean getInfoStrAndCancel(int timerType) {
        String infoStr = "info";
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, (Serializable)((Object)infoStr), ts);
            String returnStr = (String)((Object)TimerImpl.getInfo(handle));
            this.ut.commit();
            if (!returnStr.equals(infoStr)) {
                TestUtil.logErr((String)("getInfo failed: input = " + infoStr + ", return value = " + returnStr));
                return false;
            }
            TestUtil.logTrace((String)("Timer info is " + infoStr));
            this.ut.begin();
            TimerImpl.cancelTimer(handle);
            this.ut.commit();
            TestUtil.logTrace((String)"Timer cancelled.");
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoStrAndCancel", e);
            return false;
        }
    }

    public boolean getInfoClassAndCancel(int timerType) {
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerInfo infoClass = new TimerInfo("string", 1, true, 3.1415926);
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, infoClass, ts);
            TimerInfo returnClass = (TimerInfo)TimerImpl.getInfo(handle);
            this.ut.commit();
            if (!returnClass.equals(infoClass)) {
                TestUtil.logErr((String)("getInfo failed: input = " + infoClass.toString() + ", return value = " + returnClass.toString()));
                return false;
            }
            TestUtil.logTrace((String)("Timer info is " + infoClass.toString()));
            this.ut.begin();
            TimerImpl.cancelTimer(handle);
            this.ut.commit();
            TestUtil.logTrace((String)"Timer cancelled.");
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoClassAndCancel", e);
            return false;
        }
    }

    public boolean initializeTimer(int timerType, int timerAction) {
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, new Integer(timerAction), ts);
            this.ut.commit();
            return handle != null;
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
            return false;
        }
    }

    public TimerHandle initializeTimerHandle(int timerType, int timerAction) {
        TimerHandle handle = null;
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            handle = TimerImpl.createTimerHandle(timerType, new Integer(timerAction), ts);
            this.ut.commit();
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
        }
        return handle;
    }

    public boolean createAndRollback(int timerType) {
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            Timer timer = TimerImpl.createTimer(timerType, new Integer(-1), ts);
            TestUtil.logTrace((String)"Rolling back transaction in which timer was created...");
            this.ut.rollback();
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("createAndRollback", e);
            return false;
        }
    }

    public boolean cancelAndRollback(TimerHandle handle) {
        try {
            TestUtil.logTrace((String)"Getting timer...");
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            Timer timer = handle.getTimer();
            TestUtil.logTrace((String)("Cancelling timer at " + System.currentTimeMillis()));
            timer.cancel();
            TestUtil.logTrace((String)"Rolling back transaction in which timer was cancelled...");
            this.ut.rollback();
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAndRollback", e);
            return false;
        }
    }

    public boolean cancelTimer(TimerHandle handle) {
        try {
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerImpl.cancelTimer(handle);
            this.ut.commit();
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelTimer", e);
            return false;
        }
    }

    public boolean isSerializable(int timerType) {
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, new Integer(-1), ts);
            this.ut.commit();
            return TimerImpl.isSerializable(handle);
        }
        catch (Exception e) {
            TimerImpl.handleException("isSerializable", e);
            return false;
        }
    }

    public boolean verifyTimerIsGone() {
        try {
            TimerService ts = this.sctx.getTimerService();
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            boolean result = TimerImpl.verifyNoTimers(ts);
            this.ut.commit();
            return result;
        }
        catch (Exception e) {
            TimerImpl.handleException("verifyTimerIsGone", e);
            return false;
        }
    }

    public void cancelAllTimers() {
        try {
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)"Cancelling all timers...");
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            TimerImpl.cancelAllTimers(ts);
            this.ut.commit();
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAllTimers", e);
        }
    }
}

