/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.annotations.mdcomplete;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class Client
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con2 = null;
    private String completeMDJndiName = null;
    private String uname = null;
    private String password = null;
    private TSDataSource ds2 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.completeMDJndiName = p.getProperty("whitebox-mdcomplete");
        System.out.println("completeMDJndiName = : " + this.completeMDJndiName);
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        this.logMsg("Using: " + this.completeMDJndiName);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds2 = (TSDataSource)this.nctx.lookup(this.completeMDJndiName);
            if (this.ds2 == null) {
                TestUtil.logMsg((String)"ds2 lookup failed and is null");
            } else {
                TestUtil.logMsg((String)"ds2 lookup is not null");
            }
            TestUtil.logMsg((String)("ds2 JNDI lookup: " + this.ds2));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testMDCompleteConfigProp() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        String toCheck1 = "setRAName called with raname=MDCompleteRA";
        String toCheck2 = "setRAName called with raname=BAD_RAName_value";
        try {
            this.ds2.setLogFlag(true);
            this.con2 = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || b2) {
            throw new EETest.Fault("Metadata-complete config prop Failure.");
        }
        TestUtil.logMsg((String)"testMDCompleteConfigProp called correctly");
    }

    public void testMDCompleteMCFAnno() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        String toCheck1 = "MDCompleteMCF constructor";
        String toCheck2 = "MDAnnotatedMCF constructor";
        try {
            this.ds2.setLogFlag(true);
            this.con2 = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || b2) {
            throw new EETest.Fault("Annotated MCF erroneously called despite metadata-complete=true.");
        }
        TestUtil.logMsg((String)"testMDCompleteMCFAnno called correctly");
    }

    public void cleanup() throws EETest.Fault {
        if (this.ds2 != null) {
            this.ds2.clearLog();
        }
        TestUtil.logMsg((String)"Cleanup");
        try {
            TestUtil.logTrace((String)"Closing connection in cleanup.");
            if (this.con2 != null) {
                this.con2.close();
            }
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

