/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry_infomodel.AuditableEvent;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    Timestamp createTS = null;
    Timestamp updateTS = null;
    Timestamp deleteTS = null;
    Timestamp versionedTS = null;
    Timestamp unDeprecateTS = null;
    Timestamp deprecateTS = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    /*
     * Loose catch block
     */
    public void auditableEvent_Test() throws EETest.Fault {
        int failcount;
        String testName;
        block59: {
            Collection ex;
            testName = "auditableEvent_Test";
            failcount = 0;
            ArrayList<Key> serviceKeys = null;
            Service service = null;
            String serviceId = null;
            BusinessQueryManager bqm = null;
            Key serviceKey = null;
            int providerlevel = 0;
            String createUser = null;
            String deleteUser = null;
            Collection orgKeys = null;
            Key orgKey2222222222 = null;
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(testName + "_organization_"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222222222 : orgKeys) {
            }
            bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222222222.getId(), "Organization");
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            Collection audits = org.getAuditTrail();
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + " UnsupportedCapabilityException expected for level 0 providers!");
            }
            try {
                this.debug.add("Test AuditableEvent.getRegistryObject \n");
                Iterator itr = audits.iterator();
                this.debug.add(" Number of auditable events returned is: " + audits.size() + "\n");
                while (itr.hasNext()) {
                    AuditableEvent myAE = (AuditableEvent)itr.next();
                    RegistryObject ro = myAE.getRegistryObject();
                    if (ro != null) {
                        if (ro.getKey().getId().equals(orgKey2222222222.getId())) {
                            this.debug.add("good - org key is a match! \n");
                            continue;
                        }
                        this.debug.add("Failed: getRegistryObject did not return the organization as  expected\n");
                        this.debug.add("myAE.getRegistryObject() returned a: " + ro.getClass().getName() + "\n");
                        ++failcount;
                        continue;
                    }
                    if (ro != null) continue;
                    ++failcount;
                    this.debug.add(" Failure on getRegistryObject! - method returns null!\n");
                }
            }
            catch (Exception e) {
                ++failcount;
                this.debug.add("Error, myAE.getRegistryObject threw an error \n");
                TestUtil.printStackTrace((Throwable)e);
            }
            String serviceName = testName + "_service";
            bqm = this.rs.getBusinessQueryManager();
            this.debug.add("Create an service registryObject \n");
            service = this.blm.createService(serviceName);
            org.addService(service);
            serviceKeys = new ArrayList<Key>();
            serviceKey = this.saveMyService(service);
            if (serviceKey == null) {
                throw new EETest.Fault(testName + " due to create service errors , test did not complete!");
            }
            serviceId = serviceKey.getId();
            serviceKeys.add(serviceKey);
            if (serviceKey == null) {
                throw new EETest.Fault(testName + " due to save service errors , test did not complete!");
            }
            service = this.retrieveMyObject(serviceKey);
            AuditableEvent ae = this.getAE(service);
            if (this.verifyEvent(service, 0)) {
                this.debug.add(" created event returned as expected \n");
                this.createTS = ae.getTimestamp();
                createUser = ae.getUser().getPersonName().getLastName();
            } else {
                ++failcount;
                this.debug.add(" verify create event failed");
            }
            this.debug.add("Update the service \n");
            String description = "We want to test the update event";
            InternationalString is = this.blm.createInternationalString(description);
            service.setDescription(is);
            serviceKey = this.saveMyService(service);
            if (serviceKey == null) {
                throw new EETest.Fault(testName + " due to save service errors , test did not complete!");
            }
            service = this.retrieveMyObject(serviceKey);
            this.debug.add("what is the version number after the update? " + service.getMinorVersion() + "\n");
            ae = this.getAE(service);
            if (this.verifyEvent(service, 3)) {
                this.debug.add(" update event returned as expected \n");
                this.updateTS = ae.getTimestamp();
            } else {
                ++failcount;
                this.debug.add(" update event failed");
            }
            br = this.blm.deprecateObjects(serviceKeys);
            this.debug.add("Deprecate the service \n");
            if (br.getExceptions() != null) {
                this.debug.add(" error on deprecateObjects \n");
                ex = br.getExceptions();
                for (JAXRException je : ex) {
                    this.debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
                ++failcount;
            } else {
                service = this.retrieveMyObject(serviceKey);
                ae = this.getAE(service);
                if (this.verifyEvent(service, 2)) {
                    this.debug.add(" deprecate event returned as expected \n");
                    this.deprecateTS = ae.getTimestamp();
                } else {
                    this.debug.add(" deprecate event not returned as expected \n");
                    ++failcount;
                }
            }
            br = this.blm.unDeprecateObjects(serviceKeys);
            if (br.getExceptions() != null) {
                this.debug.add(" error on unDeprecateObjects \n");
                ex = br.getExceptions();
                for (JAXRException je : ex) {
                    this.debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
                ++failcount;
            } else {
                service = this.retrieveMyObject(serviceKey);
                ae = this.getAE(service);
                if (this.verifyEvent(service, 5)) {
                    this.debug.add(" deprecate event returned as expected \n");
                    this.unDeprecateTS = ae.getTimestamp();
                } else {
                    this.debug.add(" unDeprecate event not returned as expected \n");
                    ++failcount;
                }
            }
            try {
                this.debug.add("delete event time - service key is " + serviceKey.getId() + "\n");
                br = this.blm.deleteServices(serviceKeys);
                if (br.getExceptions() != null) {
                    this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                } else {
                    serviceKeys = null;
                }
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.debug.add("Caught Exception while trying to delete the service \n");
            }
            this.debug.add("Just deleted service: " + serviceId + "\n");
            this.debug.add("use query to get the audit trail for the delete event\n");
            DeclarativeQueryManager dqm = this.rs.getDeclarativeQueryManager();
            Query query = dqm.createQuery(0, "SELECT * FROM AuditableEvent ae, AffectedObject o WHERE o.id = '" + serviceId + "' AND o.eventId = ae.id AND ae.eventType = 'urn:oasis:names:tc:ebxml-regrep:EventType:Deleted'");
            br = dqm.executeQuery(query);
            if (br.getExceptions() != null) {
                ++failcount;
                this.debug.add("Expected Delete event not found \n");
            } else {
                this.debug.add("No exceptions from executeQuery\n");
            }
            Collection events = br.getCollection();
            Iterator iter = events.iterator();
            this.debug.add("size returned from query after delete is: " + events.size() + "\n");
            while (iter.hasNext()) {
                ae = (AuditableEvent)iter.next();
                this.deleteTS = ae.getTimestamp();
                deleteUser = ae.getUser().getPersonName().getLastName();
                this.printEventType(ae);
                if (ae.getEventType() == 1) {
                    this.debug.add("Expected Delete event found \n");
                    continue;
                }
                ++failcount;
            }
            if (!createUser.equals(deleteUser)) {
                ++failcount;
                this.debug.add("create and delete user should match \n");
            }
            this.debug.add(" good - create and delete users match \n");
            if (this.createTS == null) {
                this.debug.add("create timestamp was not created  - test failure\n");
            }
            if (this.deleteTS == null) {
                this.debug.add("deletetimestamp was not created  - test failure\n");
            }
            if (this.createTS != null & this.deleteTS != null) {
                if (!this.createTS.before(this.deleteTS)) {
                    ++failcount;
                    this.debug.add("create timestamp should be before delete timestamp \n");
                }
                this.debug.add(" good - create timestamp is earlier than delete timestamp \n");
            } else {
                ++failcount;
            }
            this.debug.add("End of test method - delete the Service \n");
            try {
                BulkResponse br22;
                this.debug.add("Cleanup time -service key is " + serviceKey.getId() + "\n");
                if (serviceKey != null && (br22 = this.blm.deleteServices(serviceKeys)).getExceptions() != null) {
                    this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                }
                if (orgKey2222222222 != null && (br22 = this.blm.deleteOrganizations(orgKeys)).getExceptions() != null) {
                    this.debug.add("WARNING:  cleanup encountered an error while trying to delete an organization.\n");
                }
                break block59;
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.debug.add("Caught Exception while trying to delete the service \n");
            }
            break block59;
            catch (UnsupportedCapabilityException ue) {
                if (providerlevel != 0) {
                    throw new EETest.Fault(testName + " UnsupportedCapabilityException not expected for level 1 providers!");
                }
                this.debug.add(" UnsupportedCapabilityException thrown as expected\n");
                this.debug.add("End of test method - delete the Service \n");
                try {
                    BulkResponse br32;
                    this.debug.add("Cleanup time -service key is " + serviceKey.getId() + "\n");
                    if (serviceKey != null && (br32 = this.blm.deleteServices(serviceKeys)).getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                    }
                    if (orgKey2222222222 != null && (br32 = this.blm.deleteOrganizations(orgKeys)).getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete an organization.\n");
                    }
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the service \n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
                {
                    catch (Throwable throwable) {
                        this.debug.add("End of test method - delete the Service \n");
                        try {
                            BulkResponse br42;
                            this.debug.add("Cleanup time -service key is " + serviceKey.getId() + "\n");
                            if (serviceKey != null && (br42 = this.blm.deleteServices(serviceKeys)).getExceptions() != null) {
                                this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                            }
                            if (orgKey2222222222 != null && (br42 = this.blm.deleteOrganizations(orgKeys)).getExceptions() != null) {
                                this.debug.add("WARNING:  cleanup encountered an error while trying to delete an organization.\n");
                            }
                        }
                        catch (Exception ee) {
                            TestUtil.printStackTrace((Throwable)ee);
                            this.debug.add("Caught Exception while trying to delete the service \n");
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.debug.add("Number of failures: " + failcount + " \n");
        if (failcount > 0) {
            throw new EETest.Fault(testName + " had test failures");
        }
    }

    private boolean verifyEvent(Service service, int expectedEvent) {
        boolean status = false;
        try {
            Collection audits = service.getAuditTrail();
            Iterator iter = audits.iterator();
            this.debug.add("VerifyEvent - Number of auditable events returned is: " + audits.size() + "\n");
            while (iter.hasNext()) {
                AuditableEvent ae = (AuditableEvent)iter.next();
                this.printEventType(ae);
                if (ae.getEventType() != expectedEvent) continue;
                return true;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    private AuditableEvent getAE(Service service) {
        AuditableEvent ae = null;
        try {
            Collection audits = service.getAuditTrail();
            Iterator iter = audits.iterator();
            this.debug.add(" getAE - Number of auditable events returned is: " + audits.size() + "\n");
            while (iter.hasNext()) {
                ae = (AuditableEvent)iter.next();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return ae;
    }

    private Key saveMyService(Service service) {
        Key key2 = null;
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(service);
        try {
            BulkResponse br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveServices failed \n");
                this.debug.add("== The JAXR Response Status: " + JAXRClient.checkBulkResponseStatus(br.getStatus()) + "\n");
                Collection ex = br.getExceptions();
                for (JAXRException je : ex) {
                    this.debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
                return null;
            }
            Collection serviceKeys = br.getCollection();
            for (Key key2 : serviceKeys) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return key2;
    }

    private Service retrieveMyObject(Key key) {
        Service service2 = null;
        ArrayList<Key> serviceKeys = new ArrayList<Key>();
        serviceKeys.add(key);
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.getRegistryObjects(serviceKeys, "Service");
            if (br.getExceptions() != null) {
                this.debug.add("Error:  encountered an error while trying to retrieve the SERVICE.\n");
                return null;
            }
            Collection retServices = br.getCollection();
            if (retServices.size() != 1) {
                return null;
            }
            for (Service service2 : retServices) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return service2;
    }

    private void printEventType(AuditableEvent ae) {
        try {
            switch (ae.getEventType()) {
                case 0: {
                    this.debug.add("EVENT_TYPE_CREATED \n");
                    break;
                }
                case 1: {
                    this.debug.add("EVENT_TYPE_DELETED\n");
                    break;
                }
                case 2: {
                    this.debug.add("EVENT_TYPE_DEPRECATED \n");
                    break;
                }
                case 5: {
                    this.debug.add("EVENT_TYPE_UNDEPRECATED\n");
                    break;
                }
                case 3: {
                    this.debug.add("EVENT_TYPE_UPDATED\n");
                    break;
                }
                case 4: {
                    this.debug.add("EVENT_TYPE_VERSIONED\n");
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static String checkBulkResponseStatus(int status) {
        String response;
        switch (status) {
            case 0: {
                response = "STATUS_SUCCESS ";
                break;
            }
            case 2: {
                response = "STATUS_FAILURE ";
                break;
            }
            case 3: {
                response = "STATUS_UNAVAILABLE ";
                break;
            }
            case 1: {
                response = "STATUS_WARNING  ";
                break;
            }
            default: {
                response = "Unknown Status! ";
            }
        }
        return response;
    }
}

