/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TimerService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public abstract class TimerMessageBeanBase {
    public static final String test1 = "test1";
    private MessageDrivenContext messageDrivenContext;
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;
    @Resource
    private TimerService timerService;
    private TimerInfo timerInfo = new TimerInfo();

    @Resource(name="messageDrivenContext")
    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.messageDrivenContext = messageDrivenContext;
    }

    protected void initTimerInfo(Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        int testNumber = 0;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            testNumber = msg.getIntProperty("TestCaseNum");
        }
        catch (JMSException e) {
            status = false;
            reason = this.getClass().getName() + "Failed to get test name/number from message: " + msg;
            this.timerInfo = null;
            throw new EJBException(reason, (Exception)((Object)e));
        }
        if (testname.equals(test1) && testNumber == 0) {
            status = true;
            reason = this.getClass().getName() + " received message from " + testname + ", status " + status;
        } else {
            status = false;
            reason = this.getClass().getName() + "Unrecognized testname: " + testname + ", testnum: " + testNumber;
        }
        this.timerInfo.setTestNumber(testNumber);
        this.timerInfo.setTestName(testname);
        this.timerInfo.setStatus(status);
        this.timerInfo.setReason(reason);
    }

    public EJBContext getEJBContext() {
        return this.getMessageDrivenContext();
    }

    public MessageDrivenContext getMessageDrivenContext() {
        return this.messageDrivenContext;
    }

    public QueueConnectionFactory getQFactory() {
        return this.qFactory;
    }

    public Queue getReplyQueue() {
        return this.replyQueue;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public TimerInfo getTimerInfo() {
        return this.timerInfo;
    }
}

