/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Classification;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    JAXR_Util util = null;
    Organization org = null;
    String classificationName = "Book Publishers";
    String classificationValue = "51113";
    ClassificationScheme scheme = null;
    Classification classification = null;
    String schemeName = "NAICS";
    String schemeDescription = "North American Industry Classification System";
    String name = "classificationScheme";
    Concept concept = null;
    String conceptName = "NAICS";
    String conceptValue = "51";

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void classification_setgetValueTest() throws EETest.Fault {
        String testName = "classification_setgetValueTest";
        boolean pass = false;
        try {
            this.createExternalClassificationObject();
            this.classification.setValue(this.classificationValue);
            if (this.classification.getValue().equals(this.classificationValue)) {
                pass = true;
                this.debug.add("Success! setValue was returned: " + this.classification.getValue());
            } else {
                this.debug.add("FAIL: getValue returned " + this.classification.getValue());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_getValueTest() throws EETest.Fault {
        String testName = "classification_getValueTest";
        boolean pass = false;
        try {
            this.createInternalClassificationObject();
            this.debug.add("Expecting value = " + this.conceptValue + "\n");
            this.debug.add("returned value = " + this.classification.getValue() + "\n");
            if (this.classification.getValue().equals(this.conceptValue)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_isExternalTrueTest() throws EETest.Fault {
        String testName = "classification_isExternalTrueTest";
        boolean pass = false;
        try {
            this.createExternalClassificationObject();
            this.classification.setValue(this.classificationValue);
            this.debug.add("Create an external Classification \n");
            if (this.classification.isExternal()) {
                pass = true;
                this.debug.add("Success! isExternal returned: " + this.classification.isExternal());
            } else {
                this.debug.add("FAIL: isExternal returned " + this.classification.isExternal());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_isExternalFalseTest() throws EETest.Fault {
        String testName = "classification_isExternalFalseTest";
        boolean pass = false;
        try {
            this.createInternalClassificationObject();
            this.debug.add("Created an internal Classification \n");
            if (!this.classification.isExternal()) {
                pass = true;
                this.debug.add("Success! isExternal returned: " + this.classification.isExternal());
            } else {
                this.debug.add("FAIL: isExternal returned " + this.classification.isExternal());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_getClassificationSchemeTest() throws EETest.Fault {
        String testName = "classification_getClassificationSchemeTest";
        boolean pass = false;
        ClassificationScheme scheme = null;
        try {
            this.createExternalClassificationObject();
            scheme = this.classification.getClassificationScheme();
            if (scheme.getName().getValue().equals(this.name)) {
                pass = true;
                this.debug.add("Success! returned: " + scheme.getName().getValue());
            } else {
                this.debug.add("FAIL: isExternal returned " + scheme.getName().getValue());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_setgetClassifiedObjectTest() throws EETest.Fault {
        String testName = "classification_setgetClassifiedObjectTest";
        boolean pass = false;
        try {
            this.createExternalClassificationObject();
            this.classification.setClassifiedObject((RegistryObject)this.org);
            RegistryObject ro = this.classification.getClassifiedObject();
            if (!(ro instanceof Organization)) {
                pass = false;
                throw new EETest.Fault("Did not get back an Organization as expected!");
            }
            if (ro.getName().getValue(this.tsLocale).equals("TS Default Organization")) {
                pass = true;
                this.debug.add("Correct Classified object returned: " + ro.getName().getValue(this.tsLocale) + "\n");
            } else {
                this.debug.add("Error: did not get back correct Classified object\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_getConcept() throws EETest.Fault {
        String testName = "classification_getConcept";
        boolean pass = false;
        this.concept = null;
        try {
            this.createInternalClassificationObject();
            this.concept = this.classification.getConcept();
            this.debug.add("concept returned value = " + this.concept.getValue());
            if (this.concept.getValue().equals(this.conceptValue)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classification_setConcept() throws EETest.Fault {
        String testName = "classification_setConcept";
        boolean pass = false;
        this.concept = null;
        String conceptName = "NAICS";
        String conceptValue = "51";
        try {
            this.createInternalClassificationObject();
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            this.concept = this.blm.createConcept((RegistryObject)this.scheme, conceptName, conceptValue);
            this.classification.setConcept(this.concept);
            this.concept = this.classification.getConcept();
            this.debug.add("Expecting concept value = " + conceptValue + "\n");
            this.debug.add("concept returned value = " + this.concept.getValue());
            if (this.concept.getValue().equals(conceptValue)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private void createExternalClassificationObject() throws JAXRException {
        this.org = JAXR_Util.createDefaultOrganization(this.blm);
        this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
        this.scheme.setName(this.blm.createInternationalString(this.tsLocale, this.name));
        this.classification = this.blm.createClassification(this.scheme, this.classificationName, this.classificationValue);
        this.classification.setClassificationScheme(this.scheme);
    }

    private void createInternalClassificationObject() throws JAXRException {
        this.org = JAXR_Util.createDefaultOrganization(this.blm);
        this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
        this.scheme.setName(this.blm.createInternationalString(this.tsLocale, this.name));
        this.concept = this.blm.createConcept((RegistryObject)this.scheme, this.blm.createInternationalString(this.tsLocale, this.conceptName), this.conceptValue);
        this.classification = this.blm.createClassification(this.concept);
    }
}

