/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonValue;

public abstract class CommonOperation {
    private static final String TEST_FAIL_OP = " operation";
    private static final String TEST_FAIL_FOR = " for ";
    private static final String TEST_FAIL_FAI = " failed";
    private static final String TEST_FAIL_ON1 = " on JSON ";
    private static final String TEST_FAIL_ON2 = " value";
    private static final String TEST_FAIL_MET = " using ";

    protected CommonOperation() {
    }

    protected abstract String operationName();

    protected abstract JsonPatchBuilder createOperationBuilder(String var1, Object var2);

    protected abstract JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder var1, String var2, Object var3);

    protected void simpleOperation(TestResult result, JsonValue in, JsonValue check, String path, Object value) {
        JsonValue out;
        JsonPatchBuilder builder = this.createOperationBuilder(path, value);
        JsonPatch patch = builder.build();
        try {
            out = SimpleValues.patchApply(patch, in);
        }
        catch (JsonException e) {
            out = null;
            TestUtil.logMsg((String)("   Exception for path \"" + path + "\" on " + JsonAssert.valueToString(in)));
            TestUtil.logMsg((String)("     " + e.getMessage()));
        }
        if (this.operationFailed(check, out)) {
            String targetClassName = in.getValueType().name().toLowerCase();
            String operation = JsonAssert.valueToString((JsonValue)patch.toJsonArray());
            TestUtil.logMsg((String)("     " + operation));
            result.fail(this.testName(path, targetClassName), this.testMessage(operation, path, JsonAssert.valueToString(in)));
        }
    }

    protected void complexOperation(TestResult result, JsonArray in, JsonArray check, String[] paths) {
        Object[] values = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            values[i] = null;
        }
        this.complexOperation(result, in, check, paths, values);
    }

    protected void complexOperation(TestResult result, JsonArray in, JsonArray check, String[] paths, Object[] values) {
        if (paths.length != values.length) {
            throw new IllegalArgumentException("Number of paths does not match number of indexes");
        }
        JsonPatchBuilder builder = this.prepareComplexBuilder(paths, values);
        JsonPatch patch = builder.build();
        JsonValue out = SimpleValues.patchApply(patch, (JsonValue)in);
        if (this.operationFailed((JsonValue)check, out)) {
            String operations = JsonAssert.valueToString((JsonValue)patch.toJsonArray());
            String targetClassName = in.getValueType().name().toLowerCase();
            TestUtil.logMsg((String)("     " + operations));
            result.fail(this.testName(paths, targetClassName), this.testMessage(operations, paths, JsonAssert.valueToString((JsonValue)in)));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }

    private JsonPatchBuilder prepareComplexBuilder(String[] paths, Object[] values) {
        JsonPatchBuilder builder = Json.createPatchBuilder();
        for (int i = 0; i < paths.length; ++i) {
            builder = this.updateOperationBuilder(builder, paths[i], values[i]);
        }
        return builder;
    }

    protected void simpleOperationFail(TestResult result, JsonValue in, String path, Object value) {
        try {
            JsonPatch patch = this.createOperationBuilder(path, value).build();
            SimpleValues.patchApply(patch, in);
            String targetClassName = in.getValueType().name().toLowerCase();
            String operation = JsonAssert.valueToString((JsonValue)patch.toJsonArray());
            TestUtil.logMsg((String)("   Failed for path \"" + path + "\" on " + JsonAssert.valueToString(in)));
            TestUtil.logMsg((String)("     " + operation));
            result.fail(this.testName(path, targetClassName), this.testMessage(operation, path, JsonAssert.valueToString(in)));
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
    }

    protected String getSrcName(Object value) {
        return value != null ? value.getClass().getSimpleName() : null;
    }

    protected String[] getSrcNames(Object[] values) {
        if (values == null) {
            return null;
        }
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i] != null ? values[i].getClass().getSimpleName() : null;
        }
        return names;
    }

    protected String testName(String path, String targetType) {
        String operationName = this.operationName();
        int pathLen = path != null ? path.length() + 1 : 0;
        StringBuilder sb = new StringBuilder(operationName.length() + pathLen + targetType.length() + 1);
        sb.append(operationName);
        if (pathLen > 0) {
            sb.append(' ');
            sb.append(path);
        }
        sb.append(' ');
        sb.append(targetType);
        return sb.toString();
    }

    protected String testName(String[] paths, String targetType) {
        String operationName = this.operationName();
        int pathsLen = paths != null ? paths.length : 0;
        int pathsSize = 0;
        for (int i = 0; i < pathsLen; ++i) {
            pathsSize += paths[i] != null ? paths[i].length() : "null".length();
            if (i <= 0) continue;
            ++pathsSize;
        }
        if (pathsLen > 1) {
            pathsSize += 2;
        }
        StringBuilder sb = new StringBuilder(operationName.length() + pathsSize + targetType.length() + 2);
        sb.append(operationName);
        sb.append(' ');
        if (pathsLen > 1) {
            sb.append('[');
        }
        for (int i = 0; i < pathsLen; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(paths[i] != null ? paths[i] : "null");
        }
        if (pathsLen > 1) {
            sb.append(']');
        }
        sb.append(' ');
        sb.append(targetType);
        return sb.toString();
    }

    protected String testMessage(String operation, String path, String value) {
        int tarLen = value != null ? TEST_FAIL_ON1.length() + TEST_FAIL_ON2.length() + value.length() : 0;
        StringBuilder sb = new StringBuilder(operation.length() + TEST_FAIL_OP.length() + TEST_FAIL_FOR.length() + path.length() + TEST_FAIL_FAI.length() + tarLen);
        sb.append(operation);
        sb.append(TEST_FAIL_OP);
        sb.append(TEST_FAIL_FOR);
        sb.append(path);
        sb.append(TEST_FAIL_FAI);
        if (tarLen > 0) {
            sb.append(TEST_FAIL_ON1);
            sb.append(value);
            sb.append(TEST_FAIL_ON2);
        }
        return sb.toString();
    }

    protected String testMessage(String operation, String[] paths, String value) {
        int tarLen = value != null ? TEST_FAIL_ON1.length() + TEST_FAIL_ON2.length() + value.length() : 0;
        int pathsLen = paths != null ? paths.length : 0;
        int pathsSize = 0;
        for (int i = 0; i < pathsLen; ++i) {
            pathsSize += paths[i] != null ? paths[i].length() : "null".length();
            if (i <= 0) continue;
            ++pathsSize;
        }
        if (pathsLen > 1) {
            pathsSize += 2;
        }
        StringBuilder sb = new StringBuilder(operation.length() + TEST_FAIL_OP.length() + TEST_FAIL_FOR.length() + pathsSize + TEST_FAIL_FAI.length() + tarLen);
        sb.append(operation);
        sb.append(TEST_FAIL_OP);
        sb.append(TEST_FAIL_FOR);
        if (pathsLen > 1) {
            sb.append('[');
        }
        for (int i = 0; i < pathsLen; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(paths[i] != null ? paths[i] : "null");
        }
        if (pathsLen > 1) {
            sb.append(']');
        }
        sb.append(TEST_FAIL_FAI);
        if (tarLen > 0) {
            sb.append(TEST_FAIL_ON1);
            sb.append(value);
            sb.append(TEST_FAIL_ON2);
        }
        return sb.toString();
    }

    protected String testMessage(String[] paths, String targetType) {
        String operationName = this.operationName();
        int tarLen = targetType != null ? TEST_FAIL_ON1.length() + TEST_FAIL_ON2.length() + targetType.length() : 0;
        int pathsLen = 0;
        for (int i = 0; i < paths.length; ++i) {
            pathsLen += paths[i] != null ? paths[i].length() : "null".length();
            if (i <= 0) continue;
            ++pathsLen;
        }
        if (paths.length > 1) {
            pathsLen += 2;
        }
        StringBuilder sb = new StringBuilder(operationName.length() + TEST_FAIL_OP.length() + TEST_FAIL_FOR.length() + pathsLen + TEST_FAIL_FAI.length() + tarLen);
        sb.append(operationName);
        sb.append(TEST_FAIL_OP);
        sb.append(TEST_FAIL_FOR);
        if (paths.length > 1) {
            sb.append('[');
        }
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(paths[i] != null ? paths[i] : "null");
        }
        if (paths.length > 1) {
            sb.append(']');
        }
        sb.append(TEST_FAIL_FAI);
        if (tarLen > 0) {
            sb.append(TEST_FAIL_ON1);
            sb.append(targetType);
            sb.append(TEST_FAIL_ON2);
        }
        return sb.toString();
    }
}

