/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry_infomodel.RegistryObject;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registryObject_Test() throws EETest.Fault {
        String testName = "registryObject_Test";
        boolean pass = true;
        String orgName = "TS Default Organization";
        String slUsageDescription = "detail of specification link usage";
        ArrayList<String> slUsageParameters = new ArrayList<String>();
        slUsageParameters.add("usage=test");
        String myServiceName = "TheNameOfMyService";
        String[] externalURI = new String[]{this.baseuri + "jaxrTestPage1.html", this.baseuri + "jaxrTestPage2.html"};
        String[] description = new String[]{"CTS Test Page1", "CTS Test Page2"};
        String name = "United States";
        String eivalue = "US";
        ExternalLink el = null;
        Collection orgKeys = null;
        Collection conceptKeys = null;
        BulkResponse br = null;
        Collection keys = null;
        Collection services = null;
        Organization org2222 = null;
        try {
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            ArrayList<String> externalURIs = new ArrayList<String>();
            Collection els = new ArrayList<ExternalLink>();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.debug.add("Create an external link \n");
            for (int i = 0; i < externalURI.length; ++i) {
                els.add(this.blm.createExternalLink(externalURI[i], description[i]));
                externalURIs.add(externalURI[i]);
            }
            this.debug.add("Create an organization registryObject \n");
            org2222 = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            org2222.addExternalLinks(els);
            els = null;
            String schemeName = "Geography";
            String schemeDescription = "North American Regions";
            ClassificationScheme cs = this.blm.createClassificationScheme(schemeName, schemeDescription);
            ArrayList<ClassificationScheme> schemes = new ArrayList<ClassificationScheme>();
            schemes.add(cs);
            br = this.blm.saveClassificationSchemes(schemes);
            if (!JAXR_Util.checkBulkResponse("saveClassificationschemes", br, this.debug)) {
                this.debug.add("Error reported:  saveClassificationschemes\n");
                throw new EETest.Fault(testName + " Error from saveClassificationschemes - test did not complete!");
            }
            keys = new ArrayList();
            keys = br.getCollection();
            Key ClassificationschemeKey2222 = null;
            for (Key ClassificationschemeKey2222 : keys) {
            }
            String keyId = ClassificationschemeKey2222.getId();
            this.debug.add("ClassificationschemeKey keyId is: " + keyId + "\n");
            ClassificationScheme scheme = (ClassificationScheme)bqm.getRegistryObject(keyId, "ClassificationScheme");
            InternationalString iName = this.blm.createInternationalString(name);
            ExternalIdentifier ei2222 = this.blm.createExternalIdentifier(scheme, iName, eivalue);
            org2222.addExternalIdentifier(ei2222);
            ei2222 = null;
            SpecificationLink specificationlink2222 = this.blm.createSpecificationLink();
            specificationlink2222.setUsageDescription(this.blm.createInternationalString(slUsageDescription));
            specificationlink2222.setUsageParameters(slUsageParameters);
            Concept specificationConcept = (Concept)this.blm.createObject("Concept");
            specificationConcept.setName(this.blm.createInternationalString("Conceptname"));
            specificationConcept.setValue("Concept value");
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            concepts.add(specificationConcept);
            br = this.blm.saveConcepts(concepts);
            if (!JAXR_Util.checkBulkResponse("saveConcepts", br, this.debug)) {
                this.debug.add("Error:   saveConcepts failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            conceptKeys = br.getCollection();
            Iterator ii = conceptKeys.iterator();
            Key conKey = null;
            while (ii.hasNext()) {
                conKey = (Key)ii.next();
            }
            Concept concept = (Concept)bqm.getRegistryObject(conKey.getId(), "Concept");
            specificationlink2222.setSpecificationObject((RegistryObject)concept);
            ServiceBinding serviceBinding2222 = this.blm.createServiceBinding();
            serviceBinding2222.setValidateURI(false);
            serviceBinding2222.setAccessURI(externalURI[0]);
            serviceBinding2222.addSpecificationLink(specificationlink2222);
            Service service2222 = this.blm.createService(myServiceName);
            service2222.addServiceBinding(serviceBinding2222);
            org2222.addService(service2222);
            orgs.add(org2222);
            org2222 = null;
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:   saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            orgKeys = br.getCollection();
            if (!JAXR_Util.checkBulkResponse("getRegistryObjects", br = bqm.getRegistryObjects(orgKeys, "Organization"), this.debug)) {
                this.debug.add("Error:  encountered an error while trying to retrieve the organization.\n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Collection retOrgs = br.getCollection();
            if (retOrgs.size() != 1) {
                throw new EETest.Fault(testName + " failed to retrieve 1 organization as expected. Test did not complete!");
            }
            for (Organization org2222 : retOrgs) {
            }
            service2222 = null;
            services = org2222.getServices();
            for (Service service2222 : services) {
                this.debug.add("Service Name: " + service2222.getName().getValue() + "\n");
                this.debug.add("Get the service binding from this service \n");
                Collection serviceBindings = service2222.getServiceBindings();
                serviceBinding2222 = null;
                for (ServiceBinding serviceBinding2222 : serviceBindings) {
                    Collection specificationlinks = serviceBinding2222.getSpecificationLinks();
                    for (SpecificationLink specificationlink2222 : specificationlinks) {
                    }
                }
            }
            Collection eis = org2222.getExternalIdentifiers();
            for (ExternalIdentifier ei2222 : eis) {
                if (ei2222.getValue().equals(eivalue)) {
                    this.debug.add("String returned from ExternalIdentifier.getValue matched value \n");
                    continue;
                }
                pass = false;
                this.debug.add("Error: ExternalIdentifier value returned: " + ei2222.getValue() + "expected value was " + eivalue + "\n");
            }
            this.debug.add("Expecting the following ExternalLinkURIs: \n");
            for (int i = 0; i < externalURI.length; ++i) {
                this.debug.add("          " + externalURI[i] + "\n");
            }
            els = org2222.getExternalLinks();
            Iterator iter = els.iterator();
            int count = 0;
            while (iter.hasNext()) {
                el = (ExternalLink)iter.next();
                this.debug.add("found link: " + el.getExternalURI() + "\n");
                if (!externalURIs.contains(el.getExternalURI())) continue;
                ++count;
            }
            if (count != externalURI.length) {
                pass = false;
                this.debug.add("Error: retrieved unexpected ExternalLink from organization\n");
            } else {
                this.debug.add("ExternalLinks pass\n");
            }
            this.debug.add("End of test method - delete the Organization \n");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                this.debug.add("End of test method - delete the Organization \n");
                try {
                    org2222.removeServices(services);
                    br = this.blm.deleteClassificationSchemes(keys);
                    br = this.blm.deleteConcepts(conceptKeys);
                    br = this.blm.deleteOrganizations(orgKeys);
                    if (JAXR_Util.checkBulkResponse("deleteOrganzations", br, this.debug)) throw throwable;
                    this.debug.add("WARNING:  cleanup encountered an error while trying to delete the organization.\n");
                    throw throwable;
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the organization \n");
                }
                throw throwable;
            }
        }
        try {
            org2222.removeServices(services);
            br = this.blm.deleteClassificationSchemes(keys);
            br = this.blm.deleteConcepts(conceptKeys);
            br = this.blm.deleteOrganizations(orgKeys);
            if (!JAXR_Util.checkBulkResponse("deleteOrganzations", br, this.debug)) {
                this.debug.add("WARNING:  cleanup encountered an error while trying to delete the organization.\n");
            }
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            this.debug.add("Caught Exception while trying to delete the organization \n");
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    public void registryObject_getAssociatedObjects() throws EETest.Fault {
        int failcount;
        String testName;
        block21: {
            testName = "registryObject_getAssociatedObjects";
            failcount = 0;
            BusinessQueryManager bqm = null;
            int providerlevel = 0;
            String type = "RelatedTo";
            Object orgKeys = null;
            try {
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                String orgName1 = testName + "_myTestOrganization1";
                String orgName2 = testName + "_myTestOrganization2";
                bqm = this.rs.getBusinessQueryManager();
                Organization org1 = this.blm.createOrganization(this.blm.createInternationalString(orgName1));
                Organization org2 = this.blm.createOrganization(this.blm.createInternationalString(orgName2));
                Key org1Key = this.saveMyOrganization(org1);
                Key org2Key = this.saveMyOrganization(org2);
                String orgId2 = org2Key.getId();
                Concept relatedTo = bqm.findConceptByPath("/AssociationType/RelatedTo");
                Association a = this.blm.createAssociation((RegistryObject)org2, relatedTo);
                org1.addAssociation(a);
                this.saveMyOrganization(org1);
                Collection o1AssObjs = org1.getAssociatedObjects();
                if (providerlevel == 0) {
                    this.debug.add(" Error - Expected UnsupportedCapabilityException Not Thrown \n");
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("size of org1 object collection returned is " + o1AssObjs.size() + "\n");
                if (o1AssObjs.size() == 0) {
                    this.debug.add("Error - getAssociatedObjects returned empty collection\n");
                    ++failcount;
                }
                for (Organization o : o1AssObjs) {
                    if (o.getKey().getId().equals(orgId2)) {
                        this.debug.add(" good got back org2 for assocated object \n");
                        continue;
                    }
                    this.debug.add(" not good - did not get back org2 as expected\n");
                    ++failcount;
                }
            }
            catch (UnsupportedCapabilityException ue) {
                if (providerlevel == 0) {
                    this.debug.add(" UnsupportedCapabilityException thrown as expected\n");
                    break block21;
                }
                throw new EETest.Fault(testName + " UnsupportedCapabilityException not expected for level 1 providers!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            finally {
                this.debug.add("End of test method - delete the organizations \n");
                try {
                    BulkResponse br = bqm.getRegistryObjects("Organization");
                    Collection myOrgs = br.getCollection();
                    Iterator iter = myOrgs.iterator();
                    ArrayList<Key> myOrgKeys = new ArrayList<Key>();
                    while (iter.hasNext()) {
                        Organization o = (Organization)iter.next();
                        myOrgKeys.add(o.getKey());
                    }
                    br = this.blm.deleteOrganizations(myOrgKeys);
                    if (br.getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete the organizations.\n");
                    }
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the service \n");
                }
            }
        }
        if (failcount > 0) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_getObjectTypeTest() throws EETest.Fault {
        String testName = "registryObject_getObjectTypeTest";
        int providerlevel = 0;
        Object orgKeys = null;
        String orgClassificationId = "urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Organization";
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            String orgName = testName + "_myTestOrganization";
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            this.debug.add("get the object type for the RegistryObject - Organization\n");
            Concept concept = org.getObjectType();
            if (providerlevel == 0) {
                this.debug.add(" Error - Expected UnsupportedCapabilityException Not Thrown \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("concept value is: " + concept.getValue() + "\n");
            this.debug.add("concept key is: " + concept.getKey().getId() + "\n");
            if (!concept.getKey().getId().equals(orgClassificationId)) {
                throw new EETest.Fault(testName + " key returned from concept is not correct");
            }
            this.debug.add("ObjectType verified \n");
        }
        catch (UnsupportedCapabilityException ue) {
            if (providerlevel == 0) {
                this.debug.add(" UnsupportedCapabilityException thrown as expected\n");
            }
            throw new EETest.Fault(testName + " UnsupportedCapabilityException not expected for level 1 providers!");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_getRegistryPackagesTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block19: {
            testName = "registryObject_getRegistryPackagesTest";
            int providerlevel = 0;
            pass = false;
            ArrayList<Key> serviceKeys = null;
            try {
                String serviceName = testName + "_my-test-service";
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                Service service = this.blm.createService(serviceName);
                String registryPackage = testName + "_my-test-registry-package";
                RegistryPackage rP = this.blm.createRegistryPackage(registryPackage);
                if (providerlevel == 0) {
                    throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
                }
                serviceKeys = new ArrayList<Key>();
                Key serviceKey = this.saveMyService(service);
                serviceKeys.add(serviceKey);
                rP.addRegistryObject((RegistryObject)service);
                ArrayList<RegistryPackage> packages = new ArrayList<RegistryPackage>();
                packages.add(rP);
                this.blm.saveObjects(packages);
                Key rpKey = rP.getKey();
                Collection rpkgs = service.getRegistryPackages();
                if (rpkgs.size() == 0) {
                    throw new EETest.Fault(testName + "failed - getRegistryPackages returned an empty collection.");
                }
                for (Object o : rpkgs) {
                    RegistryPackage rp;
                    if (!(o instanceof RegistryPackage) || !(rp = (RegistryPackage)o).getKey().getId().equals(rpKey.getId())) continue;
                    this.debug.add("All set, I found my registryPackage\n");
                    pass = true;
                    break;
                }
            }
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel == 0) {
                    pass = true;
                    this.debug.add(" Call to getRegistryPackages threw UnsupportedCapabilityException as expected\n");
                    break block19;
                }
                throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            finally {
                this.debug.add("End of test method - delete the service\n");
                try {
                    BulkResponse br;
                    if (serviceKeys != null && (br = this.blm.deleteServices(serviceKeys)).getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                    }
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the service \n");
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * Loose catch block
     */
    public void registryObject_getAuditTrailTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block21: {
            testName = "registryObject_getAuditTrailTest";
            int providerlevel = 0;
            pass = false;
            Collection orgKeys = null;
            Key orgKey2222222222 = null;
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            this.debug.add("Level 0 Providers must throw an UnsupportedCapabilityException for getAuditTrail\n");
            this.debug.add("This provider report a Capability Level of " + providerlevel + "\n");
            String orgName = testName + " _organization";
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                throw new EETest.Fault(testName + " unexpected error ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222222222 : orgKeys) {
            }
            org = (Organization)bqm.getRegistryObject(orgKey2222222222.getId(), "Organization");
            Collection audits = org.getAuditTrail();
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + " failed to throw expected UnsupportedCapabilityException.");
            }
            for (AuditableEvent ae : audits) {
                if (ae.getEventType() != 0) continue;
                pass = true;
            }
            this.debug.add("End of test method - delete the org \n");
            try {
                BulkResponse br2 = this.blm.deleteOrganizations(orgKeys);
                if (br2.getExceptions() != null) {
                    this.debug.add("WARNING:  cleanup encountered an error while trying to delete the org.\n");
                }
                break block21;
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.debug.add("Caught Exception while trying to delete the organization. \n");
            }
            break block21;
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel == 0) {
                    this.debug.add(" Call to getAuditTrail threw UnsupportedCapabilityException as expected\n");
                    pass = true;
                    break block21;
                }
                throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.debug.add("End of test method - delete the org \n");
                try {
                    BulkResponse br3 = this.blm.deleteOrganizations(orgKeys);
                    if (br3.getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete the org.\n");
                    }
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the organization. \n");
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private Key saveMyService(Service service) {
        Key key2 = null;
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(service);
        try {
            BulkResponse br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveServices failed \n");
                return null;
            }
            Collection serviceKeys = br.getCollection();
            for (Key key2 : serviceKeys) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return key2;
    }
}

