/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.multiclienttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private CoffeeDAO dao = null;
    private EntityContext ectx = null;
    float cofPrice = 0.0f;

    public Integer ejbCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logMsg((String)"Get DB Connection");
            this.dao.startSession();
            if (this.dao.exists(cofID)) {
                TestUtil.logErr((String)"key exists - duplicate");
                throw new DuplicateKeyException();
            }
            TestUtil.logMsg((String)"key does not exist - create entity");
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
        }
        catch (DuplicateKeyException de) {
            TestUtil.printStackTrace((Throwable)de);
            throw new DuplicateKeyException();
        }
        catch (RemoteLoggingInitException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new CreateException(re.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Load row...");
            this.cache = this.dao.load((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("No such entity exists: " + e));
            throw new NoSuchEntityException("[ejbload] DAOException" + e);
        }
        catch (Exception e) {
            throw new EJBException("[ejbload] Unable to init DAO " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Store row...");
            this.dao.store(this.cache);
        }
        catch (DAOException de) {
            TestUtil.logErr((String)("No such entity: " + de));
            throw new NoSuchEntityException("[ejbStore] DAOException" + de);
        }
        catch (Exception e) {
            throw new EJBException("[ejbStore] Unable to init DAO");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
            this.dao = null;
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void updatePrice(float newPrice) {
        TestUtil.logTrace((String)"updatePrice");
        this.cofPrice = newPrice;
    }

    public float getPrice() {
        TestUtil.logTrace((String)"getPrice");
        return this.cofPrice;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

