/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.xa.compat;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;

public class compatClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nc = null;
    private TSConnection con = null;
    private String uname = null;
    private String password = null;
    private String oldwhitebox_xa = null;
    private String oldwhitebox_xa_param = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        compatClient1 theTests = new compatClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.oldwhitebox_xa = p.getProperty("oldwhitebox-xa");
        this.oldwhitebox_xa_param = p.getProperty("oldwhitebox-xa-param");
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        this.logMsg("Using: " + this.uname);
        this.logMsg("Using: " + this.password);
        this.logMsg("Using: " + this.oldwhitebox_xa);
        this.logMsg("Using: " + this.oldwhitebox_xa_param);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nc = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nc.lookup(this.oldwhitebox_xa);
            this.ds2 = (TSDataSource)this.nc.lookup(this.oldwhitebox_xa_param);
            TestUtil.logMsg((String)("ds1 JNDI lookup: " + this.ds1));
            TestUtil.logMsg((String)("ds2 JNDI lookup: " + this.ds2));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testGetConnection1() throws EETest.Fault {
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got Connection Object from the DataSource.");
            TestUtil.logMsg((String)"Checking for Connection Validity.");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(e.getMessage());
        }
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Connection Object is Valid.");
    }

    public void testgetConnectionWithParameter1() throws EETest.Fault {
        try {
            this.logMsg("Using: " + this.oldwhitebox_xa);
            this.logMsg("Using: " + this.oldwhitebox_xa_param);
            this.con = this.ds2.getConnection(this.uname, this.password);
            this.logMsg("Using: " + this.uname);
            this.logMsg("Using: " + this.password);
            TestUtil.logMsg((String)"Got connection object from the DataSource.");
            TestUtil.logMsg((String)"Checking for Connection Validity.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Connection Object is Valid.");
    }

    public void cleanup() throws EETest.Fault {
        this.ds1.clearLog();
        this.ds2.clearLog();
        try {
            this.con.close();
        }
        catch (Exception e) {
            this.logErr("Error closing connection during cleanup: " + e.getMessage(), e);
        }
    }
}

