/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.MessageContext;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.MessageContext.Hello;
import com.sun.ts.tests.jaxrpc.common.HandlerTracker;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private Service service = null;
    private HandlerRegistry hr = null;
    private HandlerChain hc = null;
    private Properties props = null;
    Hello port = null;
    Service svc = null;

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            TestUtil.logMsg((String)"Obtained InitialContext");
            TestUtil.logMsg((String)"Lookup java:comp/env/service/messagecontext");
            this.svc = (Service)ic.lookup("java:comp/env/service/messagecontext");
            TestUtil.logMsg((String)"Obtained service");
            this.port = (Hello)this.svc.getPort(Hello.class);
            TestUtil.logMsg((String)"Obtained port");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void DoMessageContextTest() throws EETest.Fault {
        TestUtil.logTrace((String)"DoMessageContextTest");
        boolean pass = true;
        boolean fault = true;
        try {
            TestUtil.logMsg((String)"This is a test to verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Invoking RPC method port.doMessageContextTest()");
            HandlerTracker.purge();
            String serverSideMsgs = this.port.doMessageContextTest();
            String clientSideMsgs = HandlerTracker.getMessages2();
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)"Dumping Client-Side MessageContext messages");
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)clientSideMsgs);
            TestUtil.logMsg((String)"Verifying Client-Side MessageContext usage messages");
            if (!this.VerifyMessageContext("client", clientSideMsgs)) {
                TestUtil.logErr((String)"Client-Side MessageContext usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Client-Side MessageContext usage (correct)");
            }
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)"Dumping Server-Side MessageContext messages");
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)serverSideMsgs);
            TestUtil.logMsg((String)"Verifying Server-Side MessageContext usage");
            if (!this.VerifyMessageContext("server", serverSideMsgs)) {
                TestUtil.logErr((String)"Server-Side MessageContext usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Server-Side MessageContext usage (correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("DoMessageContextTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("DoMessageContextTest failed");
        }
    }

    private boolean VerifyMessageContext(String who, String calls) {
        boolean startIdx = false;
        boolean endIdx = false;
        boolean pass = true;
        if (who.equals("client")) {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("MessageContext.setProperty(ClientReqProp1,Value1)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ClientReqProp1,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.setProperty(ClientReqProp2,Value2)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ClientReqProp2,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.setProperty(ClientRespProp1,Value1)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ClientRespProp2,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.setProperty(ClientRespProp2,Value2)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ClientRespProp2,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ClientReqProp1)=Value1") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ClientReqProp1)=Value1 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ClientReqProp2)=Value2") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ClientReqProp2)=Value2 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ClientRespProp1)=Value1") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ClientRespProp1)=Value1 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ClientRespProp2)=Value2") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ClientRespProp2)=Value2 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ClientReqProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ClientReqProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ClientReqProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ClientReqProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ClientRespProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ClientRespProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ClientRespProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ClientRespProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ClientReqProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ClientReqProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ClientReqProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ClientReqProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ClientRespProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ClientRespProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ClientRespProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ClientRespProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
        } else {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("MessageContext.setProperty(ServerReqProp1,Value1)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ServerReqProp1,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.setProperty(ServerReqProp2,Value2)") == -1) {
                TestUtil.logErr((String)"MessageContext.setProperty(ServerReqProp2,Value1) was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ServerReqProp1)=Value1") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ServerReqProp1)=Value1 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getProperty(ServerReqProp2)=Value2") == -1) {
                TestUtil.logErr((String)"MessageContext.getProperty(ServerReqProp2)=Value2 was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ServerReqProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ServerReqProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.removeProperty(ServerReqProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.removeProperty(ServerReqProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ServerReqProp1)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ServerReqProp1)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.containsProperty(ServerReqProp2)=true") == -1) {
                TestUtil.logErr((String)"MessageContext.containsProperty(ServerReqProp2)=true was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
            if (calls.indexOf("MessageContext.getPropertyNames()") == -1) {
                TestUtil.logErr((String)"MessageContext.getPropertyNames() was not called");
                pass = false;
            }
            return pass;
        }
        return pass;
    }
}

