/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Association;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    RegistryService rs2 = null;
    BusinessLifeCycleManager blm2 = null;
    BusinessQueryManager bqm = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
            this.bqm = this.rs.getBusinessQueryManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void association_getAssociationType() throws EETest.Fault {
        String testName = "association_getAssociationType";
        String orgName = "TS Default Organization";
        String type = "RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/RelatedTo");
            Association a = this.blm.createAssociation((RegistryObject)target, associationType);
            Concept retType = a.getAssociationType();
            this.debug.add("getAssociationType returned : " + retType.getValue() + "\n");
            if (!retType.getValue().equals(type)) {
                throw new EETest.Fault(testName + " unexpected value returned ");
            }
            this.debug.add("value returned as expected \n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void association_setAssociationType() throws EETest.Fault {
        String testName = "association_setAssociationType";
        String orgName = "TS Default Organization";
        String type = "HasMember";
        try {
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/HasMember");
            Association a = (Association)this.blm.createObject("Association");
            a.setAssociationType(associationType);
            Concept retType = a.getAssociationType();
            this.debug.add("getAssociationType returned : " + retType.getValue() + "\n");
            if (!retType.getValue().equals(type)) {
                throw new EETest.Fault(testName + " unexpected value returned ");
            }
            this.debug.add("value returned as expected \n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void association_setSourceObject() throws EETest.Fault {
        String testName = "association_setSourceObject";
        String orgTarget = "Target Org";
        String orgSource = "Source Org";
        String type = "RelatedTo";
        try {
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/RelatedTo");
            if (associationType == null) {
                throw new EETest.Fault(testName + " failed to find an Association type - RelatedTo ");
            }
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            Association association = this.blm.createAssociation((RegistryObject)target, associationType);
            this.debug.add("target is" + association.getTargetObject().getName().getValue(this.tsLocale) + "\n");
            association.setSourceObject((RegistryObject)source);
            this.debug.add("Organization name from getSourceObject is " + association.getSourceObject().getName().getValue(this.tsLocale) + "\n");
            if (!association.getSourceObject().getName().getValue(this.tsLocale).equals(orgSource)) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void association_getTargetObject() throws EETest.Fault {
        String testName = "association_getTargetObject";
        String orgName = "TS Default Organization";
        String type = "RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/RelatedTo");
            if (associationType == null) {
                throw new EETest.Fault(testName + " findConceptByPath failed to return /AssociationType/RelatedTo");
            }
            Association a = this.blm.createAssociation((RegistryObject)target, associationType);
            this.debug.add("Expected this Organization name for the target object " + orgName + "\n");
            this.debug.add("Organization name from getTargetObject is " + a.getTargetObject().getName().getValue(this.tsLocale) + "\n");
            if (!a.getTargetObject().getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void association_setTargetObject() throws EETest.Fault {
        String testName = "association_setTargetObject";
        String orgName = "TS Default Organization";
        String type = "RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/RelatedTo");
            if (associationType == null) {
                throw new EETest.Fault(testName + " findConceptByPath failed to return /AssociationType/RelatedTo");
            }
            Association a = (Association)this.blm.createObject("Association");
            a.setAssociationType(associationType);
            a.setTargetObject((RegistryObject)target);
            this.debug.add("Expected this Organization name for the target object " + orgName + "\n");
            this.debug.add("Organization name from getTargetObject is " + a.getTargetObject().getName().getValue(this.tsLocale) + "\n");
            if (!a.getTargetObject().getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void association_isConfirmed() throws EETest.Fault {
        String testName = "association_isConfirmed";
        String orgTarget = "Target Org";
        String orgSource = "Source Org";
        String aType = "/AssociationType/RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            this.debug.add("Created target and source organizations \n");
            Concept associationConcept = this.bqm.findConceptByPath(aType);
            if (associationConcept == null) {
                throw new EETest.Fault(testName + " findConceptByPath failed to return /AssociationType/RelatedTo");
            }
            Association a = this.blm.createAssociation((RegistryObject)target, associationConcept);
            a.setSourceObject((RegistryObject)source);
            this.debug.add("This is an intramural association and does not require\n");
            this.debug.add("explicit confirmation step. \n");
            this.debug.add("Expect isConfirmed to be true\n");
            this.debug.add("isConfirmed is " + a.isConfirmed());
            if (!a.isConfirmed()) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(" failed ");
        }
    }

    public void association_isConfirmedBySourceOwner() throws EETest.Fault {
        String testName = "association_isConfirmedBySourceOwner";
        String orgTarget = "Target Org";
        String orgSource = "Source Org";
        String aType = "/AssociationType/RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(orgSource));
            this.debug.add("Created target and source organizations \n");
            Concept associationConcept = this.bqm.findConceptByPath(aType);
            if (associationConcept == null) {
                throw new EETest.Fault(testName + " findConceptByPath failed to return /AssociationType/RelatedTo");
            }
            Association a = this.blm.createAssociation((RegistryObject)target, associationConcept);
            a.setSourceObject((RegistryObject)source);
            this.debug.add("This is an intramural association and does not require\n");
            this.debug.add("explicit confirmation step. \n");
            this.debug.add("Expect isConfirmedBySourceOwner to be true\n");
            this.debug.add("isConfirmedBySourceOwner is " + a.isConfirmedBySourceOwner());
            if (!a.isConfirmedBySourceOwner()) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(" failed ");
        }
    }

    public void association_isConfirmedByTargetOwner() throws EETest.Fault {
        String testName = "association_isConfirmedByTargetOwner";
        String orgTarget = "Target Org";
        String orgSource = "Source Org";
        String aType = "/AssociationType/RelatedTo";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(orgSource));
            this.debug.add("Created target and source organizations \n");
            Concept associationConcept = this.bqm.findConceptByPath(aType);
            if (associationConcept == null) {
                throw new EETest.Fault(testName + " findConceptByPath failed to return /AssociationType/RelatedTo");
            }
            Association a = this.blm.createAssociation((RegistryObject)target, associationConcept);
            a.setSourceObject((RegistryObject)source);
            this.debug.add("This is an intramural association and does not require\n");
            this.debug.add("explicit confirmation step. \n");
            this.debug.add("Expect isConfirmedByTargetOwner to be true\n");
            this.debug.add("isConfirmedByTargetOwner is " + a.isConfirmedByTargetOwner());
            if (!a.isConfirmedByTargetOwner()) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(" failed ");
        }
    }

    public void association_isExtramural() throws EETest.Fault {
        String testName = "association_isExtramural";
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "Replaces";
        try {
            this.secondConnection();
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(orgSource));
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            Association a = this.blm.createAssociation((RegistryObject)target, associationType);
            a.setSourceObject((RegistryObject)source);
            this.debug.add("isExtramural should be true\n");
            this.debug.add("Association.isExtramural returns: " + a.isExtramural() + "\n");
            if (!a.isExtramural()) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void association_isConfirmedExtramuralPubl() throws EETest.Fault {
        String testName = "association_isConfirmedExtramuralPubl";
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "HasChild";
        BulkResponse br = null;
        Key savekey2222 = null;
        String objectType = "Organization";
        BusinessQueryManager bqm2 = null;
        Collection associationKeys = null;
        Collection sourceKeys = null;
        Collection targetKeys = null;
        boolean pass = true;
        String targetId = null;
        String sourceId = null;
        try {
            this.secondConnection();
            bqm2 = this.rs2.getBusinessQueryManager();
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(source);
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            sourceKeys = br.getCollection();
            for (Key savekey2222 : sourceKeys) {
            }
            sourceId = savekey2222.getId();
            Organization pubSource = (Organization)this.bqm.getRegistryObject(sourceId, objectType);
            this.debug.add("Verify the pub source retrieved from registry \n");
            orgs.clear();
            orgs.add(target);
            br = this.blm2.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            targetKeys = br.getCollection();
            for (Key savekey2222 : targetKeys) {
            }
            targetId = savekey2222.getId();
            Organization pubTarget = (Organization)bqm2.getRegistryObject(targetId, objectType);
            this.debug.add("Verify the pub target retrieved from registry \n");
            this.debug.add("pubTarget retrieved: " + pubTarget.getName().getValue(this.tsLocale) + "\n");
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            Association a = this.blm2.createAssociation((RegistryObject)pubTarget, associationType);
            a.setSourceObject((RegistryObject)pubSource);
            this.debug.add("user2 confirm the target association");
            this.blm2.confirmAssociation(a);
            Collection<Association> associations = new ArrayList<Association>();
            associations.add(a);
            br = this.blm2.saveAssociations(associations, false);
            if (!JAXR_Util.checkBulkResponse("saveAssociations", br, this.debug)) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            associationKeys = br.getCollection();
            Iterator iter = associationKeys.iterator();
            Key assocKey = (Key)iter.next();
            this.debug.add("expected 1 association key, got " + associationKeys.size() + "\n");
            ArrayList<Concept> associationTypes = new ArrayList<Concept>();
            associationTypes.add(associationType);
            br = this.bqm.findCallerAssociations(null, Boolean.FALSE, Boolean.TRUE, associationTypes);
            if (!JAXR_Util.checkBulkResponse("findCallerAssociations", br, this.debug)) {
                this.debug.add("Error:    findCallerAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            associations = br.getCollection();
            if (associations.size() == 0) {
                this.debug.add("Failure: findCallerAssociations did not return an association as expected!\n");
                throw new EETest.Fault(testName + " failed");
            }
            a = null;
            for (Association ass : associations) {
                if (!ass.getKey().getId().equals(assocKey.getId())) continue;
                a = ass;
                break;
            }
            if (a == null) {
                new EETest.Fault(testName + " did not complete - association is null! ");
            }
            this.debug.add("Verify the published association retrieved from registry \n");
            this.debug.add("retrieved association with association type = : " + a.getAssociationType().getValue() + "\n");
            this.debug.add("isConfirmed should be false, not confirmed by both source and target owner\n");
            this.debug.add("Association.isConfirmed returns: " + a.isConfirmed() + "\n");
            if (a.isConfirmed()) {
                this.debug.add("FAIL: isConfirmed incorrectly returned true \n");
                pass = false;
            }
            this.debug.add("isConfirmedBySourceOwner should be false\n");
            this.debug.add("Association.isConfirmedBySourceOwner returns: " + a.isConfirmedBySourceOwner() + "\n");
            if (a.isConfirmedBySourceOwner()) {
                this.debug.add("FAIL: isConfirmedBySourceOwner incorrectly returned true \n");
                pass = false;
            }
            this.debug.add("The source owner confirms the association\n");
            this.blm.confirmAssociation(a);
            associations.clear();
            associations.add(a);
            br = this.blm.saveAssociations(associations, false);
            if (!JAXR_Util.checkBulkResponse("saveAssociations", br, this.debug)) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            br = this.bqm.findCallerAssociations(null, Boolean.TRUE, Boolean.TRUE, associationTypes);
            if (!JAXR_Util.checkBulkResponse("findCallerAssociations", br, this.debug)) {
                this.debug.add("Error:    findCallerAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            associations = br.getCollection();
            iter = associations.iterator();
            a = null;
            while (iter.hasNext()) {
                Association ass;
                ass = (Association)iter.next();
                if (!ass.getKey().getId().equals(assocKey.getId())) continue;
                a = ass;
                break;
            }
            if (a == null) {
                new EETest.Fault(testName + " did not complete - association is null! ");
            }
            this.debug.add("isConfirmed should be true\n");
            this.debug.add("Association.isConfirmed returns: " + a.isConfirmed() + "\n");
            if (!a.isConfirmed()) {
                this.debug.add("FAIL: isConfirmed incorrectly returned false\n");
                pass = false;
            }
            this.debug.add("isConfirmedBySourceOwner should be true\n");
            this.debug.add("Association.isConfirmedBySourceOwner returns: " + a.isConfirmedBySourceOwner() + "\n");
            if (!a.isConfirmedBySourceOwner()) {
                this.debug.add("FAIL: isConfirmedBySourceOwner incorrectly returned false\n");
                pass = false;
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(sourceKeys);
                    this.debug.add(" Cleanup: Remove target organization\n");
                    this.blm2.deleteOrganizations(targetKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
                throw throwable;
            }
        }
        try {
            this.debug.add(" Cleanup: Remove source organization\n");
            this.blm.deleteOrganizations(sourceKeys);
            this.debug.add(" Cleanup: Remove target organization\n");
            this.blm2.deleteOrganizations(targetKeys);
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete registry object\n");
        }
        if (pass) return;
        throw new EETest.Fault(testName + "failed ");
    }

    private Concept getAssociationConcept(String associationType) {
        ArrayList<String> atypes = new ArrayList<String>();
        atypes.add("AssociationType");
        try {
            Collection associationTypes = this.bqm.findClassificationSchemes(null, atypes, null, null).getCollection();
            for (ClassificationScheme cs : associationTypes) {
                Collection types = cs.getChildrenConcepts();
                Iterator iter1 = types.iterator();
                Concept concept = null;
                while (iter1.hasNext()) {
                    concept = (Concept)iter1.next();
                    if (!concept.getName().getValue(this.tsLocale).equals(associationType)) continue;
                    return concept;
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.debug.add("getAssociationConcept caught an error!\n");
            return null;
        }
        return null;
    }

    private void secondConnection() throws EETest.Fault {
        Connection srcConnection = null;
        try {
            srcConnection = this.factory.createConnection();
            Set<PasswordAuthentication> credentials = null;
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    credentials = new HashSet();
                    PasswordAuthentication passwdAuth = new PasswordAuthentication(this.jaxrUser2, this.jaxrPassword2.toCharArray());
                    credentials.add(passwdAuth);
                    break;
                }
                case 1: {
                    credentials = super.getDigitalCertificateCredentials(this.jaxrAlias2, this.jaxrAlias2Password);
                    break;
                }
                default: {
                    throw new EETest.Fault("second connection failed: jaxrSecurityCredentialType is invalid");
                }
            }
            srcConnection.setCredentials(credentials);
            this.rs2 = srcConnection.getRegistryService();
            this.blm2 = this.rs2.getBusinessLifeCycleManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception in secondConnection method", e);
        }
    }
}

