/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.clientviewtest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.clientviewtest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.clientviewtest.TestBeanHome;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;

public class Client
extends EETest {
    private static final String testName = "ClientViewTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "clientviewtest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private TestBean beanRef = null;
    private Properties props = new Properties();
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private boolean setupOK = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.setupOK = true;
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home in test1");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            if (this.beanHome != null) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 failed : " + e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test2");
            TestBean beanRef = this.beanHome.create(this.props);
            pass = beanRef.isCreated();
            if (!pass) {
                throw new EETest.Fault("test2 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test2 failed", e);
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test3");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"Get object handle for bean instance");
            Handle handle = beanRef.getHandle();
            TestUtil.logMsg((String)"This is before the handle print");
            TestUtil.logMsg((String)("handle=" + handle));
            if (handle == null) {
                TestUtil.logErr((String)"handle for EJB is null");
                throw new EETest.Fault("test3 failed");
            }
            TestUtil.logMsg((String)"remove bean via handle");
            this.beanHome.remove(handle);
            try {
                TestUtil.logMsg((String)"Calling beanRef.isCreated()");
                pass = beanRef.isCreated();
            }
            catch (NoSuchObjectException e) {
                TestUtil.logErr((String)("Caught inner NoSuchObjectException in test3 as expected: " + e));
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught inner exception test3: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("test3 failed : " + e);
            }
            if (!pass) {
                throw new EETest.Fault("test3 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test3 failed : " + e);
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test4");
            TestBean beanRef = this.beanHome.create(this.props);
            try {
                TestUtil.logMsg((String)"This is before the beanRef.getPrimaryKey() ");
                Object primaryKey = beanRef.getPrimaryKey();
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("Caught RemoteException test4 as expected: " + e));
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("test4 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test4 failed", e);
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test");
            TestBean beanRef = this.beanHome.create(this.props);
            try {
                TestUtil.logMsg((String)"This is before the beanRef.remove(primaryKey) ");
                Integer primaryKey = new Integer(1);
                this.beanHome.remove(primaryKey);
                pass = false;
            }
            catch (RemoveException e) {
                TestUtil.logMsg((String)("Caught RemoveException as expected in test5: " + (Object)((Object)e)));
                pass = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)("Unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test6");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"Get EJBMetaData interface");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            if (metaData != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"EJBMetaData interface is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test6 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test6 failed", e);
        }
    }

    public void test6a() throws EETest.Fault {
        boolean pass = false;
        Object beanRef = null;
        try {
            TestUtil.logMsg((String)"Get HomeHandle");
            HomeHandle homeHandle = this.beanHome.getHomeHandle();
            if (homeHandle != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"homeHandle is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test6a failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test6a: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test6a failed", e);
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test7");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.getEJBHome() ");
            EJBHome beanHome2 = beanRef.getEJBHome();
            TestUtil.logMsg((String)"This is after the beanRef.getEJBHome() ");
            if (beanHome2 != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Home Interface is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test7 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test7 failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test8");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.getHandle() ");
            Handle handle = beanRef.getHandle();
            TestUtil.logMsg((String)"This is after the beanRef.getHandle() ");
            TestUtil.logMsg((String)("handle= " + handle));
            if (handle != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"handle is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test8 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test8 failed", e);
        }
    }

    public void test9() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test9");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.remove() ");
            beanRef.remove();
            TestUtil.logMsg((String)"This is after the beanRef.remove() ");
            pass = beanRef.isCreated();
        }
        catch (NoSuchObjectException e) {
            TestUtil.logErr((String)("Caught inner NoSuchObjectException in test9 as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test9 failed : " + e);
        }
        if (!pass) {
            throw new EETest.Fault("test9 failed");
        }
    }

    public void test10() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create beanRef instance test10");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"SubTest1: Getting ready to do the compare of 2 objects that are identical");
            if (beanRef.isIdentical(beanRef)) {
                TestUtil.logMsg((String)"The EJBObjects are Identical");
                pass = true;
            } else {
                TestUtil.logMsg((String)"The EJBObjects are not Identical");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test10 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test10: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test10 failed", e);
        }
    }

    public void test11() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create beanRef1 instance test11");
            TestBean beanRef1 = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"Create beanRef2 instance test11");
            TestBean beanRef2 = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"SubTest1: Getting ready to do the compare 2 different objects");
            if (beanRef1.isIdentical(beanRef2)) {
                TestUtil.logMsg((String)"The EJBObjects are Identical");
                pass = false;
            } else {
                TestUtil.logMsg((String)"The EJBObjects are not Identical");
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("test11 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test11: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test11 failed", e);
        }
    }

    public void test12() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test12");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.businessMethod() ");
            TestUtil.logMsg((String)beanRef.Ping("This is the call to the businessMethod()"));
            TestUtil.logMsg((String)"This is after the beanRef.businessMethod() ");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test12: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test12 failed", e);
        }
    }

    public TestBean echoMethod(TestBean tb) {
        try {
            TestUtil.logMsg((String)tb.Ping("Test Ping"));
            return tb;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in echoMethod : " + e));
            TestUtil.printStackTrace((Throwable)e);
            return null;
        }
    }

    public void test13() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance test13");
            TestBean beanRef = this.beanHome.create(this.props);
            TestUtil.logMsg((String)"This is before the echoMethod(EJBObject) ");
            pass = beanRef.isIdentical(this.echoMethod(beanRef));
            TestUtil.logMsg((String)("This is after the echoMethod(EJBObject) := " + pass));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test13: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test13 failed", e);
        }
    }

    public void test14() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Before the call to get MetaData() test14!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"This is before the metaData.getEJBHome()");
            EJBHome home = metaData.getEJBHome();
            TestUtil.logMsg((String)"This is after the metaData.getEJBHome() ");
            if (home != null) {
                pass = true;
            } else {
                TestUtil.logMsg((String)"Home was null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test14 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test14: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test14 failed", e);
        }
    }

    public void test15() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Before the call to get MetaData() test15!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"Before the metaData.getHomeInterfaceClass()");
            Class cls = metaData.getHomeInterfaceClass();
            TestUtil.logMsg((String)"After the metaData.getHomeInterfaceClass() ");
            TestUtil.logMsg((String)("class=" + cls));
            if (cls != null) {
                pass = true;
            } else {
                TestUtil.logMsg((String)"The getHomeInterfaceClass returned null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test15 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test15: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test15 failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test16() throws EETest.Fault {
        block10: {
            boolean pass = false;
            try {
                TestUtil.logMsg((String)"Before the call to get MetaData() test16!");
                EJBMetaData metaData = this.beanHome.getEJBMetaData();
                TestUtil.logMsg((String)("metaData=" + metaData));
                TestUtil.logMsg((String)"Before the metaData.getPrimaryKeyClass()");
                try {
                    Class cls = metaData.getPrimaryKeyClass();
                    TestUtil.logMsg((String)"After the metaData.getPrimaryKeyClass() ");
                    TestUtil.logMsg((String)("class=" + cls));
                    TestUtil.logMsg((String)"Test failed because SessionBeans shouldn't be able to get primaryKeyClass");
                }
                catch (RuntimeException e) {
                    TestUtil.logMsg((String)("Caught exception as expected test16 : " + e));
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logMsg((String)("Caught exception test16 : " + e));
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            catch (RemoteException e) {
                TestUtil.logErr((String)("Caught exception test16: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test16: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
            finally {
                if (pass) break block10;
                throw new EETest.Fault("test16 failed");
            }
        }
    }

    public void test17() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Before the call to get MetaData() test17!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"Before the metaData.getRemoteInterfaceClass()");
            Class cls = metaData.getRemoteInterfaceClass();
            TestUtil.logMsg((String)"After the metaData.getRemoteInterfaceClass() ");
            TestUtil.logMsg((String)("class=" + cls));
            if (cls != null) {
                pass = true;
            } else {
                TestUtil.logMsg((String)"getRemoteInterfaceClass Returned a null value test17");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test17 failed");
            }
        }
        catch (RemoteException e) {
            TestUtil.logErr((String)("Caught exception test17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test17 failed", e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test17 failed", e);
        }
    }

    public void test18() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Before the call to get MetaData() test18!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"This is before the metaData.isSession()");
            boolean isSession = metaData.isSession();
            TestUtil.logMsg((String)"This is after the metaData.isSession() ");
            TestUtil.logMsg((String)("isSession =" + isSession));
            pass = isSession;
            if (!pass) {
                throw new EETest.Fault("test18 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test18: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test18 failed", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

