/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta3;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class dbMetaClient3
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta3";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient3 theTests = new dbMetaClient3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new EETest.Fault("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new EETest.Fault("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new EETest.Fault("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new EETest.Fault("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsConvert03() throws EETest.Fault {
        try {
            boolean retValue = this.dbmd.supportsConvert(-2, 12);
            this.msg.setMsg("Calling supportsConvert(BINARY, VARCHAR) on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsConvert(BINARY, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BINARY, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert04() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(BIT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-7, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(BIT, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BIT, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert05() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(BLOB, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2004, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(BLOB, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BLOB, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert06() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(CHAR, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(1, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(CHAR, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(CHAR, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert07() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(CLOB, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2005, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(CLOB, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(CLOB, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert08() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(DATE, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(91, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DATE, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DATE, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert09() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(DECIMAL, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(3, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DECIMAL, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DECIMAL, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert10() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(DISTINCT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2001, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DISTINCT, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DISTINCT, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert11() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(DOUBLE, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(8, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DOUBLE, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DOUBLE, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert12() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(FLOAT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(6, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(FLOAT, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(FLOAT, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert13() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(INTEGER, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(4, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(INTEGER, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(INTEGER, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert14() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(JAVA_OBJECT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2000, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(JAVA_OBJECT, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(JAVA_OBJECT, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert15() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(LONGVARBINARY, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-4, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(LONGVARBINARY, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(LONGVARBINARY, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert16() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(LONGVARCHAR, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-1, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(LONGVARCHAR, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(LONGVARCHAR, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert17() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(NULL, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(0, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(NULL, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(NULL, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert18() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(NUMERIC, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(NUMERIC, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(NUMERIC, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert19() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling supportsConvert(OTHER, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(1111, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(OTHER, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(OTHER, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert20() throws EETest.Fault {
        try {
            boolean retValue = this.dbmd.supportsConvert(7, 12);
            this.msg.setMsg("Calling supportsConvert(REAL, VARCHAR) on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsConvert(REAL, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(REAL, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert21() throws EETest.Fault {
        try {
            boolean retValue = this.dbmd.supportsConvert(2006, 12);
            this.msg.setMsg("Calling supportsConvert(REF, VARCHAR) on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsConvert(REF VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(REF VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert22() throws EETest.Fault {
        try {
            boolean retValue = this.dbmd.supportsConvert(5, 12);
            this.msg.setMsg("Calling supportsConvert(SMALLINT, VARCHAR) on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsConvert(SMALLINT VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(SMALLINT VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

