/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.common;

import com.sun.ts.lib.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;

public final class JAXRPC_Util {
    public static final String SOAP11 = "soap11";
    public static final String SOAP12 = "soap12";
    private static MessageFactory mfactorySOAP11 = null;
    private static MessageFactory mfactorySOAP12 = null;
    private static SOAPFactory sfactorySOAP11 = null;
    private static SOAPFactory sfactorySOAP12 = null;
    private static boolean debug = false;
    private static Context nctx = null;
    private static ServiceFactory sfactory = null;
    private static String content = null;

    public static Object doJNDILookup(String name) throws NamingException {
        System.out.println("JAXRPC_Util:doJNDILookup");
        if (nctx == null) {
            System.out.println("Create JAXRPC naming context...");
            nctx = new InitialContext();
            System.out.println("List all names in JAXRPC naming context...");
            NamingEnumeration<NameClassPair> list = nctx.list("");
            while (list.hasMore()) {
                NameClassPair nc = list.next();
                System.out.println(nc);
            }
        }
        return nctx.lookup(name);
    }

    public static String getURLFromProp(String urlProp) throws Exception {
        return TestUtil.getProperty((String)urlProp);
    }

    public static void setSOAPLogging(OutputStream s) throws Exception {
    }

    public static void setSOAPLogging(Stub o, OutputStream s) throws Exception {
    }

    public static ServiceFactory getServiceFactory() {
        TestUtil.logMsg((String)"JAXRPC_Util:getServiceFactory");
        try {
            TestUtil.logMsg((String)"Creating ServiceFactory instance");
            if (sfactory == null) {
                sfactory = ServiceFactory.newInstance();
            }
            return sfactory;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred: ", (Throwable)e);
            return null;
        }
    }

    public static Service getService(QName sname) throws Exception {
        TestUtil.logMsg((String)"JAXRPC_Util:getService");
        if (sfactory == null) {
            sfactory = ServiceFactory.newInstance();
        }
        TestUtil.logMsg((String)("Creating Service instance for QNAME: " + sname));
        Service service = sfactory.createService(sname);
        return service;
    }

    public static Service getService(URL wsdlurl, QName sname) throws Exception {
        TestUtil.logMsg((String)"JAXRPC_Util:getService");
        if (sfactory == null) {
            sfactory = ServiceFactory.newInstance();
        }
        TestUtil.logMsg((String)"Creating Service instance");
        TestUtil.logMsg((String)("URL=" + wsdlurl + ", QNAME=" + sname));
        Service service = sfactory.createService(wsdlurl, sname);
        return service;
    }

    public static Service getService(String serviceInterfaceName) throws Exception {
        TestUtil.logMsg((String)"JAXRPC_Util.getService()");
        TestUtil.logMsg((String)("Get service implementation class for service interface=" + serviceInterfaceName));
        ServiceFactory sf = JAXRPC_Util.getServiceFactory();
        Class<?> si = Class.forName(serviceInterfaceName);
        Service svc = sf.loadService(si);
        TestUtil.logMsg((String)("ServiceImplClass=" + svc));
        return svc;
    }

    public static Object getStub(String serviceInterfaceName, String portMethod) throws Exception {
        TestUtil.logMsg((String)"JAXRPC_Util.getStub()");
        TestUtil.logMsg((String)("Get service implementation class for service interface=" + serviceInterfaceName));
        ServiceFactory sf = JAXRPC_Util.getServiceFactory();
        Class<?> si = Class.forName(serviceInterfaceName);
        Service svc = sf.loadService(si);
        TestUtil.logMsg((String)("ServiceImplClass=" + svc));
        TestUtil.logMsg((String)("Get stub class for port method=" + portMethod));
        Method m = svc.getClass().getMethod(portMethod, new Class[0]);
        return m.invoke((Object)svc, new Object[0]);
    }

    public static Object getStub(Service svc, String portMethod) throws Exception {
        TestUtil.logMsg((String)"JAXRPC_Util.getStub()");
        TestUtil.logMsg((String)("Get stub class from service instance for port method=" + portMethod));
        Method m = svc.getClass().getMethod(portMethod, new Class[0]);
        return m.invoke((Object)svc, new Object[0]);
    }

    public static Call setCallProperties(Call call, String uri) throws Exception {
        TestUtil.logMsg((String)"Set standard call properties");
        TestUtil.logMsg((String)("javax.xml.rpc.soap.http.soapaction.use=" + new Boolean(true)));
        call.setProperty("javax.xml.rpc.soap.http.soapaction.use", (Object)new Boolean(true));
        TestUtil.logMsg((String)("javax.xml.rpc.soap.http.soapaction.uri=" + uri));
        call.setProperty("javax.xml.rpc.soap.http.soapaction.uri", (Object)uri);
        TestUtil.logMsg((String)"javax.xml.rpc.encodingstyle.namespace.uri=http://schemas.xmlsoap.org/soap/encoding/");
        call.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", (Object)"http://schemas.xmlsoap.org/soap/encoding/");
        call.setProperty("javax.xml.rpc.soap.operation.style", (Object)"rpc");
        return call;
    }

    private static void DumpTypeMappingRegistry(Service service) {
        TestUtil.logMsg((String)"Get TypeMappingRegistry for Service instance");
        try {
            TypeMappingRegistry registry = service.getTypeMappingRegistry();
            if (registry != null) {
                TestUtil.logMsg((String)"TypeMappingRegistry exists for Service instance");
                String[] s = registry.getRegisteredEncodingStyleURIs();
                if (s != null) {
                    TestUtil.logMsg((String)"EncodingStyleURIs exists for Service instance");
                    for (int i = 0; i < s.length; ++i) {
                        TestUtil.logMsg((String)("Registered EncodingStyleURI[" + i + "]=" + s[i]));
                        TypeMapping t = registry.getTypeMapping(s[i]);
                        TestUtil.logMsg((String)("Registered TypeMapping = " + t));
                    }
                }
                TestUtil.logMsg((String)("Default TypeMapping = " + registry.getDefaultTypeMapping()));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printSOAPMessage(SOAPMessage msg, PrintWriter writer) {
        writer.println(JAXRPC_Util.returnSOAPMessageAsString(msg));
    }

    public static void printSOAPMessage(SOAPMessage msg, PrintStream out) {
        out.println("" + JAXRPC_Util.returnSOAPMessageAsString(msg));
    }

    public static void dumpSOAPMessage(SOAPMessage msg) {
        TestUtil.logMsg((String)"***** Begin Dumping SOAPMessage *****");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            TestUtil.logMsg((String)baos.toString());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        TestUtil.logMsg((String)"***** Done Dumping SOAPMessage *****");
    }

    public static String returnSOAPMessageAsString(SOAPMessage msg) {
        ByteArrayOutputStream baos = null;
        String s = null;
        try {
            baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            s = baos.toString();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return s;
    }

    public static void dumpSOAPMessageWOA(SOAPMessage msg) {
        TestUtil.logMsg((String)"***** Begin Dumping SOAPMessage Without Attachments *****");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage tmpMsg = mf.createMessage(msg.getMimeHeaders(), (InputStream)new ByteArrayInputStream(baos.toString().getBytes()));
            tmpMsg.removeAllAttachments();
            tmpMsg.saveChanges();
            tmpMsg.writeTo((OutputStream)baos);
            TestUtil.logMsg((String)baos.toString());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        TestUtil.logMsg((String)"***** Done Dumping SOAPMessage Without Attachments *****");
    }

    public static boolean SOAPElementContentsEqual(SOAPElement request, SOAPElement response) {
        String requestContent = JAXRPC_Util.GetSOAPElementContent("Request", request);
        String responseContent = JAXRPC_Util.GetSOAPElementContent("Response", response);
        TestUtil.logMsg((String)"Comparing request and response SOAPElement content");
        if (requestContent.equals(responseContent)) {
            TestUtil.logMsg((String)"Request and Response SOAPElement content is equal (expected)");
            return true;
        }
        TestUtil.logErr((String)"Request and Response SOAPElement content is not equal (unexpected)");
        return false;
    }

    public static String GetSOAPElementContent(String which, SOAPElement se) {
        content = null;
        TestUtil.logMsg((String)("Dumping SOAPElement " + which + " Content"));
        JAXRPC_Util._GetSOAPElementContent(se);
        return content;
    }

    private static void _GetSOAPElementContent(SOAPElement se) {
        Object o;
        Name name = se.getElementName();
        if (name.getURI() == null || name.getURI().equals("")) {
            TestUtil.logMsg((String)(" Element=" + name.getLocalName()));
            content = content + name.getLocalName();
        } else {
            TestUtil.logMsg((String)(" Element=" + name.getLocalName() + " URI=" + name.getURI()));
            content = content + name.getLocalName() + " " + name.getURI();
        }
        Iterator i = se.getAllAttributes();
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof Name)) continue;
            Name attr = (Name)o;
            if (attr.getURI() == null || attr.getURI().equals("")) {
                TestUtil.logMsg((String)("  AttrName=" + attr.getLocalName() + " AttrValue=" + se.getAttributeValue(attr)));
                continue;
            }
            TestUtil.logMsg((String)("  AttrName=" + attr.getLocalName() + " URI=" + attr.getURI() + " AttrValue=" + se.getAttributeValue(attr)));
        }
        i = se.getChildElements();
        while (i.hasNext()) {
            o = i.next();
            if (o instanceof Name) {
                Name elem = (Name)o;
                if (elem.getURI() == null || elem.getURI().equals("")) {
                    TestUtil.logMsg((String)(" Element=" + elem.getLocalName()));
                    content = content + " " + elem.getLocalName();
                    continue;
                }
                TestUtil.logMsg((String)(" Element=" + elem.getLocalName() + " URI=" + elem.getURI()));
                content = content + " " + elem.getLocalName() + " " + elem.getURI();
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                TestUtil.logMsg((String)("  Text=" + text.getValue()));
                content = content + " " + text.getValue();
                continue;
            }
            SOAPElement se2 = (SOAPElement)o;
            JAXRPC_Util._GetSOAPElementContent(se2);
        }
    }

    public static MessageFactory getMessageFactory(String which) throws Exception {
        System.out.println("JAXRPC_Util:getMessageFactory");
        if (which.equals(SOAP11)) {
            if (mfactorySOAP11 == null) {
                mfactorySOAP11 = MessageFactory.newInstance();
            }
            return mfactorySOAP11;
        }
        return mfactorySOAP12;
    }

    public static SOAPFactory getSOAPFactory(String which) throws Exception {
        System.out.println("JAXRPC_Util:getSOAPFactory");
        if (which.equals(SOAP11)) {
            if (sfactorySOAP11 == null) {
                sfactorySOAP11 = SOAPFactory.newInstance();
            }
            return sfactorySOAP11;
        }
        return sfactorySOAP12;
    }
}

