/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.ac_ssl_ssln_upr_noid.reverse;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2AppClient;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.IOR1ValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ResponseValidationStrategy;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private Properties props = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private TSLoginContext lc = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"setup...");
        this.props = p;
        try {
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
        }
        catch (Exception e) {
            throw new EETest.Fault("Login failed:", e);
        }
    }

    public void ac_ssl_ssln_upr_noid_sb_testid2() throws EETest.Fault {
        boolean pass = true;
        String testName = "ac_ssl_ssln_upr_noid_sb_testid2_reverse";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(true, true);
        log.startLog();
        log.logStartAssertion(testName);
        ArrayList<String> chain = new ArrayList<String>();
        chain.add("java:comp/env/ejb/RemoteSession");
        TestUtil.logMsg((String)"Client initiated.");
        CSIv2AppClient appClient = new CSIv2AppClient();
        TestUtil.logMsg((String)"AppClient (RI) ====> RemoteSessionBean (VI).");
        appClient.invoke(chain, this.props);
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, new IOR1ValidationStrategy(false), null, new ResponseValidationStrategy(true, false));
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup...");
    }
}

