/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptiontests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;

public class ExceptionTest
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptiontests.ExceptionTest";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        ExceptionTest theTests = new ExceptionTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
    }

    public void cleanup() throws EETest.Fault {
    }

    public void transactionRolledBackExceptionTest1() throws EETest.Fault {
        try {
            String errorCode = "Serious";
            String cause = "Rollback operation not allowed.";
            TransactionRolledBackException exceptionToTest = new TransactionRolledBackException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TransactionRolledBackExceptionTest1 Failed: ");
        }
    }

    public void transactionRolledBackExceptionTest2() throws EETest.Fault {
        try {
            TransactionRolledBackException exceptionToTest = new TransactionRolledBackException("Rollback operation not allowed.");
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TransactionRolledBackExceptionTest2 Failed: ");
        }
    }

    public void testTransactionInProgressException1() throws EETest.Fault {
        try {
            String errorCode = "Warning";
            String cause = "Transaction is still in progress.";
            TransactionInProgressException exceptionToTest = new TransactionInProgressException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TransactionInProgressExceptionTest1 Failed: ");
        }
    }

    public void testTransactionInProgressException2() throws EETest.Fault {
        try {
            TransactionInProgressException exceptionToTest = new TransactionInProgressException("Transaction is still in progress.");
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressException transactionInProgressException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TransactionInProgressExceptionTest2 Failed: ");
        }
    }

    public void testResourceAllocationException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot get the resource, not enough heap space.";
            ResourceAllocationException exceptionToTest = new ResourceAllocationException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ResourceAllocationException1 Failed: ");
        }
    }

    public void resourceAllocationExceptionTest2() throws EETest.Fault {
        try {
            ResourceAllocationException exceptionToTest = new ResourceAllocationException("Cannot get the resource, not enough heap space.");
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationException resourceAllocationException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ResourceAllocationException2 Failed: ");
        }
    }

    public void testMessageNotWriteableException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Message just received";
            MessageNotWriteableException exceptionToTest = new MessageNotWriteableException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageNotWriteableExceptionTest1 Failed: ");
        }
    }

    public void testMessageNotWriteableException2() throws EETest.Fault {
        try {
            MessageNotWriteableException exceptionToTest = new MessageNotWriteableException("Message just received");
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableException messageNotWriteableException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageNotWriteableExceptionTest2 Failed: ");
        }
    }

    public void testMessageNotReadableException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Message is empty";
            MessageNotReadableException exceptionToTest = new MessageNotReadableException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotReadableException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageNotReadableExceptionTest1 Failed: ");
        }
    }

    public void testMessageNotReadableException2() throws EETest.Fault {
        try {
            MessageNotReadableException exceptionToTest = new MessageNotReadableException("Message is empty");
            try {
                throw exceptionToTest;
            }
            catch (MessageNotReadableException messageNotReadableException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageNotReadableExceptionTest2 Failed: ");
        }
    }

    public void testMessageFormatException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot convert from int to char";
            MessageFormatException exceptionToTest = new MessageFormatException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageFormatExceptionTest1 Failed: ");
        }
    }

    public void testMessageFormatException2() throws EETest.Fault {
        try {
            MessageFormatException exceptionToTest = new MessageFormatException("Cannot convert from int to char");
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatException messageFormatException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageFormatExceptionTest2 Failed: ");
        }
    }

    public void testMessageEOFException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "It is a byte, not an int.";
            MessageEOFException exceptionToTest = new MessageEOFException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageEOFException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageEOFExceptionTest1 Failed: ");
        }
    }

    public void testMessageEOFException2() throws EETest.Fault {
        try {
            MessageEOFException exceptionToTest = new MessageEOFException("It is a byte, not an int.");
            try {
                throw exceptionToTest;
            }
            catch (MessageEOFException messageEOFException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MessageEOFExceptionTest2 Failed: ");
        }
    }

    public void testJMSSecurityException1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot find the user.";
            JMSSecurityException exceptionToTest = new JMSSecurityException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("JMSSecurityExceptionTest1 Failed: ");
        }
    }

    public void testJMSSecurityException2() throws EETest.Fault {
        try {
            JMSSecurityException exceptionToTest = new JMSSecurityException("Cannot find the user.");
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityException jMSSecurityException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("JMSSecurityExceptionTest2 Failed: ");
        }
    }

    public void testJMSException1() throws EETest.Fault {
        try {
            String errorCode = "Warning";
            String cause = "Not a JMS operation";
            JMSException exceptionToTest = new JMSException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("JMSExceptionTest1 Failed: ");
        }
    }

    public void testJMSException2() throws EETest.Fault {
        try {
            String cause = "Not a JMS operation";
            String cause1 = "Deprecated since v1.1";
            JMSException exceptionToTest = new JMSException(cause);
            JMSException exceptionToTest1 = new JMSException(cause1);
            exceptionToTest.setLinkedException((Exception)((Object)exceptionToTest1));
            if (!exceptionToTest.getLinkedException().getMessage().equals(exceptionToTest1.getMessage())) {
                throw new EETest.Fault("Linked Exception does not return correct message " + exceptionToTest.getLinkedException().getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("JMSExceptionTest2 Failed: ");
        }
    }

    public void invalidSelectorExceptionTest1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "unknown variable";
            InvalidSelectorException exceptionToTest = new InvalidSelectorException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidSelectorExceptionTest1 Failed: ");
        }
    }

    public void invalidSelectorExceptionTest2() throws EETest.Fault {
        try {
            InvalidSelectorException exceptionToTest = new InvalidSelectorException("unknown variable");
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorException invalidSelectorException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidSelectorExceptionTest2 Failed: ");
        }
    }

    public void invalidDestinationExceptionTest1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Destination is Null";
            InvalidDestinationException exceptionToTest = new InvalidDestinationException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidDestinationExceptionTest1 Failed: ");
        }
    }

    public void invalidDestinationExceptionTest2() throws EETest.Fault {
        try {
            InvalidDestinationException exceptionToTest = new InvalidDestinationException("Destination is Null");
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationException invalidDestinationException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidDestinationExceptionTest2 Failed: ");
        }
    }

    public void invalidClientIDExceptionTest1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "Duplicate Client ID";
            InvalidClientIDException exceptionToTest = new InvalidClientIDException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidClientIDExceptionTest1 Failed: ");
        }
    }

    public void invalidClientIDExceptionTest2() throws EETest.Fault {
        try {
            InvalidClientIDException exceptionToTest = new InvalidClientIDException("Duplicate Client ID");
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDException invalidClientIDException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvalidClientIDExceptionTest2 Failed: ");
        }
    }

    public void illegalStateExceptionTest1() throws EETest.Fault {
        try {
            String errorCode = "Urgent";
            String cause = "The operation is intended for Queue Configuration only.";
            IllegalStateException exceptionToTest = new IllegalStateException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new EETest.Fault("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("IllegalStateExceptionTest1 Failed: ");
        }
    }

    public void illegalStateExceptionTest2() throws EETest.Fault {
        try {
            IllegalStateException exceptionToTest = new IllegalStateException("The operation is intended for Queue Configuration only.");
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Failed to construct IllegalStateException: ");
        }
    }
}

