/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.SigTestData;
import com.sun.ts.tests.signaturetest.SigTestResult;
import com.sun.ts.tests.signaturetest.SignatureTestDriver;
import com.sun.ts.tests.signaturetest.SignatureTestDriverFactory;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SigTest
extends EETest {
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl(this.testInfo.getBinDir());
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl(this.testInfo.getBinDir());
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl(this.testInfo.getTSHome());
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages();

    protected String[] getClasses() {
        return new String[0];
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"$$$ SigTest.setup() called");
            this.testInfo = new SigTestData(p);
            TestUtil.logTrace((String)"$$$ SigTest.setup() complete");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception " + e.getMessage());
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void signatureTest() throws EETest.Fault {
        TestUtil.logTrace((String)"$$$ SigTest.test1() called");
        SigTestResult results = null;
        String mapFile = this.getMapFile();
        String repositoryDir = this.getRepositoryDir();
        String[] packages = this.getPackages();
        String[] classes = this.getClasses();
        String packageFile = this.getPackageFile();
        String testClasspath = this.testInfo.getTestClasspath();
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            TestUtil.logMsg((String)results.toString());
            if (!results.passed()) {
                TestUtil.logTrace((String)"results.passed() returned false");
                throw new Exception();
            }
            TestUtil.logTrace((String)"$$$ SigTest.test1() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new EETest.Fault("SigTest.test1() failed!, diffs found");
            }
            TestUtil.logErr((String)("Unexpected exception " + e.getMessage()));
            throw new EETest.Fault("test1 failed with an unexpected exception", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"$$$ SigTest.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            TestUtil.logTrace((String)"$$$ SigTest.cleanup() returning");
        }
        catch (Exception e) {
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }
}

