/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Data;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.Echo;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.EchoService;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookupDDs.client.EjbClientIF;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.ws.WebServiceRef;

@Stateless(name="WSWebServiceRefLookupDDsClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private Properties harnessProps = null;
    private static final boolean debug = false;
    private String urlString;
    EchoService service = null;
    Echo port = null;
    @WebServiceRef(lookup="bogus")
    EchoService service2 = null;
    Echo port2 = null;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)("EjbClient DEBUG: service=" + (Object)((Object)this.service)));
        this.port = (Echo)this.service.getPort(Echo.class);
        TestUtil.logMsg((String)"EjbClient DEBUG: Obtained port");
        TestUtil.logMsg((String)("EjbClient DEBUG: port=" + this.port));
        this.getTargetEndpointAddress(this.port);
        TestUtil.logMsg((String)("EjbClient DEBUG: service2=" + (Object)((Object)this.service2)));
        TestUtil.logMsg((String)"EjbClient DEBUG: Obtained port");
        this.port2 = (Echo)this.service2.getPort(Echo.class);
        TestUtil.logMsg((String)("EjbClient DEBUG: port2=" + this.port2));
    }

    private void getTargetEndpointAddress(Object port) throws Exception {
        TestUtil.logMsg((String)("Get Target Endpoint Address for port=" + port));
        String urlString = JAXWS_Util.getTargetEndpointAddress(port);
        TestUtil.logMsg((String)("Target Endpoint Address=" + urlString));
    }

    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        try {
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"JNDI lookup java:comp/env/service/wswsreflookupddsservice");
            this.service = (EchoService)((Object)ctx.lookup("java:comp/env/service/wswsreflookupddsservice"));
            this.getPort();
        }
        catch (Exception e) {
            System.err.println("EjbClient:postConstruct() Exception: " + e);
            e.printStackTrace();
        }
        if (this.service == null || this.service2 == null || this.port == null || this.port2 == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        this.harnessProps = p;
        try {
            TestUtil.init((Properties)p);
            this.urlString = this.harnessProps.getProperty("ENDPOINTURL");
            JAXWS_Util.setTargetEndpointAddress(this.port2, this.urlString);
            this.getTargetEndpointAddress(this.port2);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean testwsreflookup(Properties p) {
        this.postConstruct();
        this.init(p);
        TestUtil.logMsg((String)"testwsreflookup");
        boolean pass = true;
        return this.stringTest();
    }

    private boolean stringTest() {
        TestUtil.logMsg((String)"stringTest");
        boolean pass = true;
        String request = "Mary";
        try {
            String response = this.port2.echoString(request);
            if (!JAXWS_Data.compareValues(request, response, "String")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

