/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonstringtests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import java.util.Properties;
import javax.json.JsonString;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonStringEqualsTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonString 1 for testing");
            JsonString string1 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string1=" + JSONP_Util.toStringJsonString(string1));
            this.logMsg("Create sample JsonString 2 for testing");
            JsonString string2 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string2=" + JSONP_Util.toStringJsonString(string2));
            this.logMsg("Call JsonString.equals() to compare 2 equal JsonStrings and expect true");
            if (string1.equals((Object)string2)) {
                this.logMsg("JsonStrings are equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonStrings are not equal - unexpected.");
            }
            this.logMsg("Create sample JsonString 1 for testing");
            string1 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string1=" + JSONP_Util.toStringJsonString(string1));
            this.logMsg("Create sample JsonString 2 for testing");
            string2 = JSONP_Util.createJsonString("Hello USA");
            this.logMsg("string2=" + JSONP_Util.toStringJsonString(string2));
            this.logMsg("Call JsonString.equals() to compare 2 equal JsonStrings and expect false");
            if (!string1.equals((Object)string2)) {
                this.logMsg("JsonStrings are not equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonStrings are equal - unexpected.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonStringEqualsTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonStringEqualsTest Failed");
        }
    }

    public void jsonStringHashCodeTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonString 1 for testing");
            JsonString string1 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string1=" + JSONP_Util.toStringJsonString(string1));
            this.logMsg("string1.hashCode()=" + string1.hashCode());
            this.logMsg("Create sample JsonString 2 for testing");
            JsonString string2 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string2=" + JSONP_Util.toStringJsonString(string2));
            this.logMsg("string2.hashCode()=" + string2.hashCode());
            this.logMsg("Call JsonString.hashCode() to compare 2 equal JsonStrings and expect true");
            if (string1.hashCode() == string2.hashCode()) {
                this.logMsg("JsonStrings hashCode are equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonStrings hashCode are not equal - unexpected.");
            }
            this.logMsg("Create sample JsonString 1 for testing");
            string1 = JSONP_Util.createJsonString("Hello World");
            this.logMsg("string1=" + JSONP_Util.toStringJsonString(string1));
            this.logMsg("string1.hashCode()=" + string1.hashCode());
            this.logMsg("Create sample JsonString 2 for testing");
            string2 = JSONP_Util.createJsonString("Hello USA");
            this.logMsg("string2=" + JSONP_Util.toStringJsonString(string2));
            this.logMsg("string2.hashCode()=" + string2.hashCode());
            this.logMsg("Call JsonString.hashCode() to compare 2 equal JsonStrings and expect false");
            if (string1.hashCode() != string2.hashCode()) {
                this.logMsg("JsonStrings hashCode are not equal - expected.");
            } else {
                pass = false;
                this.logErr("JsonStrings hashCode are equal - unexpected.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonStringHashCodeTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonStringHashCodeTest Failed");
        }
    }

    public void jsonStringGetCharsTest() throws EETest.Fault {
        boolean pass = true;
        String helloWorld = "Hello World";
        try {
            this.logMsg("Create sample JsonString for testing");
            JsonString string = JSONP_Util.createJsonString(helloWorld);
            this.logMsg("string=" + JSONP_Util.toStringJsonString(string));
            this.logMsg("Call JsonString.getChars() to return the char sequence for the JSON string");
            CharSequence cs = string.getChars();
            this.logMsg("charSequence=" + cs.toString());
            this.logMsg("Checking char sequence for equality to expected string contents");
            if (!JSONP_Util.assertEquals(helloWorld, cs.toString())) {
                pass = false;
            }
            this.logMsg("Checking char sequence for expected equality to string length");
            if (!JSONP_Util.assertEquals(helloWorld.length(), cs.length())) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonStringGetCharsTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonStringGetCharsTest Failed");
        }
    }
}

