/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.standalone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Data;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Graph;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.IDLStruct;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Multi;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.MyUtil;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Timer;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException;
import com.sun.ts.tests.rmiiiop.ee.standalone.CallBackInterface;
import com.sun.ts.tests.rmiiiop.ee.standalone.RMIIIOPTests;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class Client
extends ServiceEETest
implements Serializable {
    private Properties testProps = null;
    private static final String RMIIIOPServerLookup = "RMIIIOPServer";
    private TSNamingContext nctx = null;
    private RMIIIOPTests testsRef = null;
    private CallBackInterface[] callbackRefs = new CallBackInterface[10];

    public static void main(String[] args) {
        Client client = new Client();
        Status s = client.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        MyUtil.logTrace("Client.setup()");
        String ior = null;
        try {
            this.testProps = p;
            MyUtil.logTrace("Obtain Naming Context");
            this.nctx = new TSNamingContext();
            MyUtil.logMsg("Create HTTP URL Connection to RMIIIOPHttpServer");
            String urlString = "http://" + p.getProperty("rmiiiopHttpServerHost") + ":" + p.getProperty("rmiiiopHttpServerPort");
            MyUtil.logMsg("Create HTTP URL [" + urlString + "] to RMIIIOPHttpServer");
            URL url = new URL(urlString);
            MyUtil.logMsg("Open URL stream [" + urlString + "] to RMIIIOPHttpServer");
            InputStream in = url.openStream();
            MyUtil.logMsg("Read IOR from URL stream of RMIIIOPHttpServer");
            byte[] buffer = new byte[2048];
            int bytes_read = in.read(buffer);
            in.close();
            ior = new String(buffer, 0, bytes_read);
            MyUtil.logMsg("IOR = " + ior);
        }
        catch (Exception e) {
            MyUtil.logErr("Caught unexpected exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr("FATAL-ERROR: Cannot contact the standalone RMIIIOPServer.");
            MyUtil.logErr("The standalone rmiiiop tests require that you start the standalone");
            MyUtil.logErr("RMIIIOPServer. You start the standalone  RMIIIOPServer by executing");
            MyUtil.logErr("the startRMIIIOPServer script in $TS_HOME/bin. Refer to the TS");
            MyUtil.logErr("Users Guide which has more info on the standalone rmiiiop tests.");
            throw new EETest.Fault("Setup failed:");
        }
        try {
            MyUtil.logMsg("Create default J2EE ORB using ORB.init()");
            ORB orb = ORB.init((String[])new String[0], null);
            MyUtil.logMsg("ORB = " + orb);
            MyUtil.logMsg("Using stringified IOR to get object reference");
            MyUtil.logMsg("Convert stringified IOR to a CORBA object");
            Object obj = orb.string_to_object(ior);
            MyUtil.logMsg("Narrow CORBA object to get object reference");
            this.testsRef = (RMIIIOPTests)PortableRemoteObject.narrow((java.lang.Object)obj, RMIIIOPTests.class);
        }
        catch (Exception e) {
            MyUtil.logErr("FATAL-ERROR: Could not create ORB via [ORB.init()] or could not");
            MyUtil.logErr("convert stringified IOR to a CORBA object.");
            MyUtil.logErr("Exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            throw new EETest.Fault("Setup failed:");
        }
    }

    public void cleanup() throws EETest.Fault {
        MyUtil.logMsg("Cleanup ok");
    }

    public void PrimTest01() throws EETest.Fault {
        String testname = "PrimTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_boolean();
            failures += this.pass_a_byte();
            failures += this.pass_a_char();
            failures += this.pass_a_short();
            failures += this.pass_a_int();
            failures += this.pass_a_long();
            failures += this.pass_a_float();
            MyUtil.logSubTestResultSummary();
            if ((failures += this.pass_a_double()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void PrimTest02() throws EETest.Fault {
        String testname = "PrimTest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_boolean_array();
            failures += this.pass_a_byte_array();
            failures += this.pass_a_char_array();
            failures += this.pass_a_short_array();
            failures += this.pass_a_int_array();
            failures += this.pass_a_long_array();
            failures += this.pass_a_float_array();
            MyUtil.logSubTestResultSummary();
            if ((failures += this.pass_a_double_array()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void EXTest01() throws EETest.Fault {
        String testname = "EXTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.throw_a_user_exception()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RITest01() throws EETest.Fault {
        String testname = "RITest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.return_a_remote_interface();
            failures += this.pass_a_remote_interface();
            if ((failures += this.return_a_remote_interface()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RITest02() throws EETest.Fault {
        String testname = "RITest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.return_array_of_remote_interfaces();
            failures += this.pass_array_of_remote_interfaces();
            if ((failures += this.return_array_of_remote_interfaces()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RITest03() throws EETest.Fault {
        String testname = "RITest03";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.return_verify_stub();
            if ((failures += this.pass_verify_stub()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest01() throws EETest.Fault {
        String testname = "OBVTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_date_object();
            failures += this.pass_any_object();
            failures += this.return_a_date_object();
            if ((failures += this.return_any_object()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest02() throws EETest.Fault {
        String testname = "OBVTest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_date_object_array();
            failures += this.pass_any_object_array();
            failures += this.return_a_date_object_array();
            if ((failures += this.return_any_object_array()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest03() throws EETest.Fault {
        String testname = "OBVTest03";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_graph_of_objects();
            if ((failures += this.return_a_graph_of_objects()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest04() throws EETest.Fault {
        String testname = "OBVTest04";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_array_of_graph_objects();
            if ((failures += this.return_array_of_graph_objects()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest05() throws EETest.Fault {
        String testname = "OBVTest05";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.pass_return_object3_array(5)) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void MultiTest01() throws EETest.Fault {
        String testname = "MultiTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.pass_return_multiclass_types()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void IDLEntityTest01() throws EETest.Fault {
        String testname = "IDLEntityTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_return_idl_entity_types("struct");
            if ((failures += this.pass_return_idl_entity_types("sequence")) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    private int pass_a_boolean() {
        String subtestname = "PrimTest01:(pass_a_boolean)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            boolean ret = false;
            boolean saveret = false;
            MyUtil.logMsg("Passing/Returning boolean to/from RMIIIOPServer");
            for (int i = 0; i < Data.boolean_data.length && (!(ret = this.testsRef.pass_a_boolean(i, Data.boolean_data[i])) || ret); ++i) {
                if (!ret) continue;
                saveret = true;
            }
            if (saveret) {
                ret = saveret;
            }
            if (ret && !ret) {
                MyUtil.displayError("Invalid return", "false or true", "" + ret);
                ++failures;
            } else if (ret) {
                MyUtil.displayError("Wrong return", "false", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_byte() {
        String subtestname = "PrimTest01:(pass_a_byte)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            byte ret = 0;
            byte saveret = 0;
            MyUtil.logMsg("Passing/Returning byte to/from RMIIIOPServer");
            for (int i = 0; i < Data.byte_data.length && ((ret = this.testsRef.pass_a_byte(i, Data.byte_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_char() {
        String subtestname = "PrimTest01:(pass_a_char)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            char ret = '0';
            char saveret = '0';
            MyUtil.logMsg("Passing/Returning char to/from RMIIIOPServer");
            for (int i = 0; i < Data.char_data.length && ((ret = (char)this.testsRef.pass_a_char(i, Data.char_data[i])) == '0' || ret == '1'); ++i) {
                if (ret != 49) continue;
                saveret = '1';
            }
            if (saveret == '1') {
                ret = saveret;
            }
            if (ret != '0' && ret != '1') {
                MyUtil.displayError("Invalid return", "'0' or '1'", "'" + ret + "'");
                ++failures;
            } else if (ret != '0') {
                MyUtil.displayError("Wrong return", "'0'", "'" + ret + "'");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_short() {
        String subtestname = "PrimTest01:(pass_a_short)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            short ret = 0;
            short saveret = 0;
            MyUtil.logMsg("Passing/Returning short to/from RMIIIOPServer");
            for (int i = 0; i < Data.short_data.length && ((ret = this.testsRef.pass_a_short(i, Data.short_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_int() {
        String subtestname = "PrimTest01:(pass_a_int)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            int ret = 0;
            int saveret = 0;
            MyUtil.logMsg("Passing/Returning int to/from RMIIIOPServer");
            for (int i = 0; i < Data.int_data.length && ((ret = this.testsRef.pass_a_int(i, Data.int_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_long() {
        String subtestname = "PrimTest01:(pass_a_long)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            long ret = 0L;
            long saveret = 0L;
            MyUtil.logMsg("Passing/Returning long to/from RMIIIOPServer");
            for (int i = 0; i < Data.long_data.length && ((ret = this.testsRef.pass_a_long(i, Data.long_data[i])) == 0L || ret == 1L); ++i) {
                if (ret != 1L) continue;
                saveret = 1L;
            }
            if (saveret == 1L) {
                ret = saveret;
            }
            if (ret != 0L && ret != 1L) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0L) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_float() {
        String subtestname = "PrimTest01:(pass_a_float)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            float ret = 0.0f;
            float saveret = 0.0f;
            MyUtil.logMsg("Passing/Returning float to/from RMIIIOPServer");
            for (int i = 0; i < Data.float_data.length && ((ret = this.testsRef.pass_a_float(i, Data.float_data[i])) == 0.0f || ret == 1.0f); ++i) {
                if (ret != 1.0f) continue;
                saveret = 1.0f;
            }
            if (saveret == 1.0f) {
                ret = saveret;
            }
            if (ret != 0.0f && ret != 1.0f) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret);
                ++failures;
            } else if (ret != 0.0f) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_double() {
        String subtestname = "PrimTest01:(pass_a_double)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            double ret = 0.0;
            double saveret = 0.0;
            MyUtil.logMsg("Passing/Returning double to/from RMIIIOPServer");
            for (int i = 0; i < Data.double_data.length && ((ret = this.testsRef.pass_a_double(i, Data.double_data[i])) == 0.0 || ret == 1.0); ++i) {
                if (ret != 1.0) continue;
                saveret = 1.0;
            }
            if (saveret == 1.0) {
                ret = saveret;
            }
            if (ret != 0.0 && ret != 1.0) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret);
                ++failures;
            } else if (ret != 0.0) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_boolean_array() {
        String subtestname = "PrimTest02:(pass_a_boolean_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning boolean array to/from RMIIIOPServer");
            boolean[] ret = this.testsRef.pass_a_boolean_array(Data.boolean_data);
            if (ret.length != Data.boolean_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.boolean_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] && !ret[0]) {
                MyUtil.displayError("Invalid return", "false or true", "" + ret[0]);
                ++failures;
            } else if (ret[0]) {
                MyUtil.displayError("Wrong return", "false", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_byte_array() {
        String subtestname = "PrimTest02:(pass_a_byte_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning byte array to/from RMIIIOPServer");
            byte[] ret = this.testsRef.pass_a_byte_array(Data.byte_data);
            if (ret.length != Data.byte_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.byte_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_char_array() {
        String subtestname = "PrimTest02:(pass_a_char_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning char array to/from RMIIIOPServer");
            char[] ret = this.testsRef.pass_a_char_array(Data.char_data);
            if (ret.length != Data.char_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.char_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != '0' && ret[0] != '1') {
                MyUtil.displayError("Invalid return", "'0' or '1'", "'" + ret[0] + "'");
                ++failures;
            } else if (ret[0] != '0') {
                MyUtil.displayError("Wrong return", "'0'", "'" + ret[0] + "'");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_short_array() {
        String subtestname = "PrimTest02:(pass_a_short_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning short array to/from RMIIIOPServer");
            short[] ret = this.testsRef.pass_a_short_array(Data.short_data);
            if (ret.length != Data.short_data.length) {
                MyUtil.displayError("Invalid length", "" + Data.short_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_int_array() {
        String subtestname = "PrimTest02:(pass_a_int_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning int array to/from RMIIIOPServer");
            int[] ret = this.testsRef.pass_a_int_array(Data.int_data);
            if (ret.length != Data.int_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.int_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_long_array() {
        String subtestname = "PrimTest02:(pass_a_long_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning long array to/from RMIIIOPServer");
            long[] ret = this.testsRef.pass_a_long_array(Data.long_data);
            if (ret.length != Data.long_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.long_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0L && ret[0] != 1L) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0L) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_float_array() {
        String subtestname = "PrimTest02:(pass_a_float_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning float array to/from RMIIIOPServer");
            float[] ret = this.testsRef.pass_a_float_array(Data.float_data);
            if (ret.length != Data.float_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.float_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0.0f && ret[0] != 1.0f) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0.0f) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_double_array() {
        String subtestname = "PrimTest02:(pass_a_double_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning double array to/from RMIIIOPServer");
            double[] ret = this.testsRef.pass_a_double_array(Data.double_data);
            if (ret.length != Data.double_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.double_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0.0 && ret[0] != 1.0) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0.0) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int throw_a_user_exception() {
        String subtestname = "EXTest01:(throw_a_user_exception)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Throw a user defined exception from RMIIIOPServer");
            this.testsRef.throw_a_user_exception();
            MyUtil.logMsg("No UserException was thrown");
            ++failures;
        }
        catch (UserException e) {
            MyUtil.logMsg("Caught UserException as expected");
            MyUtil.logMsg("Checking UserException message");
            if (!e.getMessage().equals("This is a UserException test")) {
                MyUtil.displayError("Wrong message", "This is a UserException test", e.getMessage());
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_remote_interface() {
        String subtestname = "RITest01:(pass_a_remote_interface)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Remote Interface to RMIIIOPServer");
            int ret = this.testsRef.pass_a_remote_interface(this.callbackRefs[0]);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Remote Interface to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_remote_interface() {
        String subtestname = "RITest01:(return_a_remote_interface)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Remote Interface from RMIIIOPServer");
            this.callbackRefs[0] = this.testsRef.return_a_remote_interface();
            if (this.callbackRefs[0] == null) {
                MyUtil.logErr("Could not return a Remote Interface from RMIIIOPServer");
                ++failures;
            } else {
                try {
                    MyUtil.logMsg("Invoking the methods of the returned Remote Interface");
                    this.callbackRefs[0].method1();
                    this.callbackRefs[0].method2();
                }
                catch (Exception e) {
                    MyUtil.logErr("Unable to invoke the methods of the Remote Interface");
                    MyUtil.logErr("Caught exception: " + e.getMessage());
                    MyUtil.printStackTrace(e);
                    MyUtil.logErr(e.toString());
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_array_of_remote_interfaces() {
        String subtestname = "RITest02:(pass_array_of_remote_interfaces)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing array of Remote Interfaces to RMIIIOPServer");
            int ret = this.testsRef.pass_array_of_remote_interfaces(this.callbackRefs);
            if (ret != 0) {
                MyUtil.logErr("Could not pass array of Remote Interfaces to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_array_of_remote_interfaces() {
        String subtestname = "RITest02:(return_array_of_remote_interfaces)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning array of Remote Interfaces from RMIIIOPServer");
            this.callbackRefs = this.testsRef.return_array_of_remote_interfaces();
            if (this.callbackRefs == null) {
                MyUtil.logErr("Could not return array of Remote Interfaces from RMIIIOPServer");
                ++failures;
            } else if (this.callbackRefs.length != 10) {
                MyUtil.displayError("Wrong length", "10", "" + this.callbackRefs.length);
                ++failures;
            }
            if (this.callbackRefs != null) {
                for (int i = 0; i < this.callbackRefs.length; ++i) {
                    try {
                        MyUtil.logMsg("Invoking the methods of the returned Remote Interface refs[" + i + "]");
                        this.callbackRefs[i].method1();
                        this.callbackRefs[i].method2();
                        continue;
                    }
                    catch (Exception e) {
                        MyUtil.logErr("Unable to invoke the methods of the Remote Interface refs[" + i + "]");
                        MyUtil.logErr("Caught exception: " + e.getMessage());
                        MyUtil.printStackTrace(e);
                        MyUtil.logErr(e.toString());
                        ++failures;
                    }
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_verify_stub() {
        String subtestname = "RITest03:(pass_verify_stub)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Remote Interface to RMIIIOPServer");
            MyUtil.logMsg("Verify that the object passed is a stub object");
            int ret = this.testsRef.pass_verify_stub(this.callbackRefs[0]);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Remote Interface to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_verify_stub() {
        int failures;
        String subtestname;
        block9: {
            subtestname = "RITest03:(return_verify_stub)";
            failures = 0;
            MyUtil.logMsg(subtestname);
            try {
                MyUtil.logMsg("Returning a Remote Interface from RMIIIOPServer");
                MyUtil.logMsg("Verify that the object returned is a stub object");
                this.callbackRefs[0] = this.testsRef.return_verify_stub();
                MyUtil.logMsg("Returned reference=" + this.callbackRefs[0]);
                if (this.callbackRefs[0] == null) {
                    MyUtil.logErr("Could not return a Remote Interface from RMIIIOPServer");
                    ++failures;
                    break block9;
                }
                try {
                    MyUtil.logMsg("Invoking the methods of the returned Stub Object");
                    this.callbackRefs[0].method1();
                    this.callbackRefs[0].method2();
                }
                catch (Exception e) {
                    MyUtil.logErr("Unable to invoke the methods of the returned Stub Object");
                    MyUtil.logErr("Caught exception: " + e.getMessage());
                    MyUtil.printStackTrace(e);
                    MyUtil.logErr(e.toString());
                    ++failures;
                }
                if (this.callbackRefs[0] instanceof Stub) {
                    MyUtil.logMsg("Returned reference is of type javax.rmi.CORBA.Stub");
                } else {
                    MyUtil.logMsg("Returned reference is of type CallBackInterface");
                }
            }
            catch (Exception e) {
                MyUtil.logErr("Caught exception: " + e.getMessage());
                MyUtil.printStackTrace(e);
                MyUtil.logErr(e.toString());
                ++failures;
            }
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_date_object() {
        String subtestname = "OBVTest01:(pass_a_date_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Date object to RMIIIOPServer");
            int ret = this.testsRef.pass_a_date_object(Data.date);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Date object to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_any_object() {
        String subtestname = "OBVTest01:(pass_any_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing any Java object to RMIIIOPServer");
            int ret = this.testsRef.pass_any_object(Data.bitset);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a BitSet object to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_date_object() {
        String subtestname = "OBVTest01:(return_a_date_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Date object from RMIIIOPServer");
            Date d = this.testsRef.return_a_date_object();
            if (d == null) {
                MyUtil.logErr("Could not return a Date object from RMIIIOPServer");
                ++failures;
            } else if (!d.equals(Data.date)) {
                MyUtil.logErr("Returned Date object doesn't match expected Date object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_any_object() {
        String subtestname = "OBVTest01:(return_any_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning any Java object from RMIIIOPServer");
            java.lang.Object o = this.testsRef.return_any_object();
            if (!(o instanceof BitSet)) {
                MyUtil.logErr("Could not return a BitSet object from RMIIIOPServer");
                ++failures;
            }
            if (!o.equals(Data.bitset)) {
                MyUtil.logErr("Returned BitSet object doesn't match expected BitSet object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_date_object_array() {
        String subtestname = "OBVTest02:(pass_a_date_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Date object array to RMIIIOPServer");
            int ret = this.testsRef.pass_a_date_object_array(Data.date_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Date object array to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_any_object_array() {
        String subtestname = "OBVTest02:(pass_any_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing any Java object array to RMIIIOPServer");
            int ret = this.testsRef.pass_any_object_array(Data.bitset_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a BitSet object array to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_date_object_array() {
        String subtestname = "OBVTest02:(return_a_date_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Date object array from RMIIIOPServer");
            Date[] d = this.testsRef.return_a_date_object_array();
            if (d.length != Data.date_array.length) {
                MyUtil.logErr("Could not return a Date object array from RMIIIOPServer");
                MyUtil.displayError("Wrong length", "" + Data.date_array.length, "" + d.length);
                ++failures;
            }
            for (int i = 0; i < d.length; ++i) {
                if (d[i] == null) {
                    MyUtil.logErr("Could not return a Date object array from RMIIIOPServer");
                    MyUtil.logErr("d[" + i + "] is null (unexpected)");
                    ++failures;
                }
                if (d[i].equals(Data.date_array[i])) continue;
                MyUtil.logErr("Returned Date object doesn't match expected Date object");
                MyUtil.logErr("d[" + i + "] is unexpected Date object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_any_object_array() {
        String subtestname = "OBVTest02:(return_any_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning any Java object array from RMIIIOPServer");
            java.lang.Object[] o = this.testsRef.return_any_object_array();
            if (o.length != Data.bitset_array.length) {
                MyUtil.logErr("Could not return BitSet object array from RMIIIOPServer");
                MyUtil.displayError("Wrong length", "" + Data.bitset_array.length, "" + o.length);
                ++failures;
            }
            for (int i = 0; i < o.length; ++i) {
                if (!(o[i] instanceof BitSet)) {
                    MyUtil.logErr("Could not return a BitSet object array from RMIIIOPServer");
                    MyUtil.logErr("o[" + i + "] not a BitSet object");
                    ++failures;
                }
                if (o[i].equals(Data.bitset_array[i])) continue;
                MyUtil.logErr("Returned BitSet object doesn't match expected BitSet object");
                MyUtil.logErr("o[" + i + "] is unexpected BitSet object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_graph_of_objects() {
        String subtestname = "OBVTest03:(pass_a_graph_of_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Graph object to RMIIIOPServer");
            int ret = this.testsRef.pass_a_graph_of_objects(Data.graph);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Graph object to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_graph_of_objects() {
        String subtestname = "OBVTest03:(return_a_graph_of_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Graph object from RMIIIOPServer");
            Graph g = this.testsRef.return_a_graph_of_objects();
            if (g == null) {
                MyUtil.logErr("Could not return a Graph object from RMIIIOPServer");
                ++failures;
            }
            StringBuffer result = new StringBuffer("{ ");
            Graph list = g;
            for (Graph list2 = Data.graph; list != null && list2 != null; list = list.next(), list2 = list2.next()) {
                result.append(list.data()).append(" ");
                if (!list.CONSTANT_STRING.equals(list2.CONSTANT_STRING)) {
                    ++failures;
                    MyUtil.displayError("list.CONSTANT_STRING != list2.CONSTANT_STRING");
                    MyUtil.displayError("list.CONSTANT_STRING", "" + list2.CONSTANT_STRING, "" + list.CONSTANT_STRING);
                }
                if (list.CONSTANT_INT != list2.CONSTANT_INT) {
                    ++failures;
                    MyUtil.displayError(": list.CONSTANT_INT != list2.CONSTANT_INT");
                    MyUtil.displayError("list.CONSTANT_INT", "" + list2.CONSTANT_INT, "" + list.CONSTANT_INT);
                }
                if (list.CONSTANT_BITSET.equals(list2.CONSTANT_BITSET)) continue;
                ++failures;
                MyUtil.displayError("list.CONSTANT_BITSET != list2.CONSTANT_BITSET");
                MyUtil.displayError("list.CONSTANT_BITSET", "" + list2.CONSTANT_BITSET, "" + list.CONSTANT_BITSET);
            }
            result.append("}").toString();
            if (!result.toString().equals("{ This is a graph object test. }")) {
                ++failures;
                MyUtil.displayError("graph string != Data.graph_expected_string");
                MyUtil.displayError("graph string", "{ This is a graph object test. }", "" + result);
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_array_of_graph_objects() {
        String subtestname = "OBVTest04:(pass_array_of_graph_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing array of Graph objects to RMIIIOPServer");
            int ret = this.testsRef.pass_array_of_graph_objects(Data.graph_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass array of Graph objects to RMIIIOPServer");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_array_of_graph_objects() {
        String subtestname = "OBVTest04:(return_array_of_graph_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning array of Graph objects from RMIIIOPServer");
            Graph[] g = this.testsRef.return_array_of_graph_objects();
            for (int i = 0; i < g.length; ++i) {
                if (g[i] == null) {
                    MyUtil.logErr("Could not return a array of Graph objects from RMIIIOPServer");
                    ++failures;
                }
                StringBuffer result = new StringBuffer("{ ");
                Graph list = g[i];
                for (Graph list2 = Data.graph_array[i]; list != null && list2 != null; list = list.next(), list2 = list2.next()) {
                    result.append(list.data()).append(" ");
                    if (!list.CONSTANT_STRING.equals(list2.CONSTANT_STRING)) {
                        ++failures;
                        MyUtil.displayError("g[" + i + "].CONSTANT_STRING != list2.CONSTANT_STRING");
                        MyUtil.displayError("g[" + i + "].CONSTANT_STRING", "" + list2.CONSTANT_STRING, "" + g[i].CONSTANT_STRING);
                    }
                    if (list.CONSTANT_INT != list2.CONSTANT_INT) {
                        ++failures;
                        MyUtil.displayError("g[" + i + "].CONSTANT_INT != list2.CONSTANT_INT");
                        MyUtil.displayError("g[" + i + "].CONSTANT_INT", "" + list2.CONSTANT_INT, "" + g[i].CONSTANT_INT);
                    }
                    if (list.CONSTANT_BITSET.equals(list2.CONSTANT_BITSET)) continue;
                    ++failures;
                    MyUtil.displayError("g[" + i + "].CONSTANT_BITSET != list2.CONSTANT_BITSET");
                    MyUtil.displayError("g[" + i + "].CONSTANT_BITSET", "" + list2.CONSTANT_BITSET, "" + g[i].CONSTANT_BITSET);
                }
                result.append("}").toString();
                if (result.toString().equals("{ This is a graph object test. }")) continue;
                ++failures;
                MyUtil.displayError("g[" + i + "] graph string != Data.graph_expected_string");
                MyUtil.displayError("g[" + i + "] graph string", "{ This is a graph object test. }", "" + result);
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_object3_array(int vectorsize) {
        int j;
        int k;
        int m;
        String subtestname = "OBVTest05:(pass_return_object3_array)";
        int failures = 0;
        java.lang.Object[][][] main = new Vector[vectorsize][][];
        java.lang.Object[][][] w = null;
        Timer timer = new Timer();
        MyUtil.logMsg(subtestname);
        MyUtil.logMsg("Initialize 3 dimensional object array with vectorsize = " + vectorsize);
        for (m = 0; m < main.length; ++m) {
            main[m] = new Vector[vectorsize][];
            for (k = 0; k < main[m].length; ++k) {
                main[m][k] = new Vector[vectorsize];
                for (j = 0; j < main[m][k].length; ++j) {
                    main[m][k][j] = new Vector(vectorsize);
                    for (int i = 0; i < vectorsize; ++i) {
                        ((Vector)main[m][k][j]).insertElementAt(i * j, i);
                    }
                }
            }
        }
        try {
            MyUtil.logMsg("Pass and return the 3 dimensional object array to RMIIIOPServer");
            MyUtil.logMsg("Please wait this method call can take a long time ....");
            timer.start();
            w = this.testsRef.pass_return_object3_array(main);
            timer.stop();
            MyUtil.logMsg("Method call took ....[" + timer.getStringFormattedTime() + "]");
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            MyUtil.logMsg(subtestname + "failed");
            MyUtil.logDoneSubTest(subtestname);
            return ++failures;
        }
        MyUtil.logMsg("Compare returned 3 dimensional object array with the one passed");
        MyUtil.logMsg("Checking lengths");
        if (main.length != w.length) {
            MyUtil.displayError("Wrong Length", " main array length of " + main.length, " is different from the returned array length of " + w.length);
            ++failures;
        }
        MyUtil.logMsg("Checking data");
        for (m = 0; m < main.length && failures == 0; ++m) {
            if (main[m].length != w[m].length) {
                MyUtil.displayError("Wrong Data1", " main [" + m + "] array length of " + main[m].length, " is different from the returned array[" + m + "] length of " + w[m].length);
                ++failures;
                break;
            }
            for (k = 0; k < main[m].length; ++k) {
                if (main[m][k].length != w[m][k].length) {
                    MyUtil.displayError("Wrong Data2", " main [" + m + "][" + k + "] array length of " + main[m][k].length, " is different from the returned array[" + m + "][" + k + "] length of " + w[m][k].length);
                    ++failures;
                    break;
                }
                if (failures != 0) break;
                for (j = 0; j < main[m][k].length; ++j) {
                    if (((Vector)main[m][k][j]).size() != ((Vector)w[m][k][j]).size()) {
                        MyUtil.displayError("Wrong Data3", " main [" + m + "][" + k + "][" + j + "] vector length of " + ((Vector)main[m][k][j]).size(), " is different from the returned vector [" + m + "][" + k + "][" + j + "] length of " + ((Vector)w[m][k][j]).size());
                        ++failures;
                        break;
                    }
                    Enumeration e = ((Vector)main[m][k][j]).elements();
                    Enumeration f = ((Vector)w[m][k][j]).elements();
                    int counter = 0;
                    while (e.hasMoreElements()) {
                        if (!((Integer)e.nextElement()).equals((Integer)f.nextElement())) {
                            MyUtil.displayError("Wrong Data4: element " + counter + " in Vector (" + m + "," + k + "," + j + ")");
                            ++failures;
                            break;
                        }
                        ++counter;
                    }
                    if (failures != 0) break;
                    if (f.hasMoreElements()) {
                        MyUtil.displayError("Wrong Data5:  returned Vector (" + m + "," + k + "," + j + ") ");
                        ++failures;
                        break;
                    }
                    if (failures != 0) break;
                }
                if (failures != 0) break;
            }
            if (failures != 0) break;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    public int pass_return_multiclass_types() {
        String subtestname = "MultiTest01:(pass_return_multiclass_types)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning Multi Class Types to RMIIIOPServer");
            Multi ret = null;
            ret = this.testsRef.pass_return_multiclass_types(Data.multiTypes);
            if (ret == null) {
                MyUtil.logErr("Could not return Multi Class Types from RMIIIOPServer");
                ++failures;
            } else if (ret.getBear1().getSize() != Data.bear1Size) {
                MyUtil.displayError("Wrong bear1Size", "" + Data.bear1Size, "" + ret.getBear1().getSize());
                ++failures;
            } else if (ret.getBear2().getSize() != Data.bear2Size) {
                MyUtil.displayError("Wrong bear2Size", "" + Data.bear2Size, "" + ret.getBear2().getSize());
                ++failures;
            } else if (ret.getBear3().getSize() != Data.bear3Size) {
                MyUtil.displayError("Wrong bear3Size", "" + Data.bear3Size, "" + ret.getBear3().getSize());
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    public int pass_return_idl_entity_types(String idltype) {
        String subtestname = "IDLEntityTest01:(pass_return_idl_entity_types)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning IDLEntity Types to RMIIIOPServer");
            if (idltype.equals("struct")) {
                MyUtil.logMsg("Passing/Returning struct IDLEntity type to RMIIIOPServer");
                IDLStruct ret = null;
                ret = this.testsRef.pass_return_idl_entity_types(Data.idlType1);
                if (ret == null) {
                    MyUtil.logErr("Could not return struct IDLEntity type from RMIIIOPServer");
                    ++failures;
                } else if (ret.x != Data.idlType1_value) {
                    MyUtil.displayError("Wrong value", "" + Data.idlType1_value, "" + ret.x);
                    ++failures;
                }
            } else if (idltype.equals("sequence")) {
                MyUtil.logMsg("Passing/Returning sequence IDLEntity type to RMIIIOPServer");
                IDLStruct[] ret = null;
                ret = this.testsRef.pass_return_idl_entity_types(Data.idlType2);
                if (ret == null) {
                    MyUtil.logErr("Could not return sequence IDLEntity type from RMIIIOPServer");
                    ++failures;
                } else {
                    for (int i = 0; i < 10; ++i) {
                        if (ret[i].x == (short)i) continue;
                        MyUtil.displayError("Wrong value", "" + i, "" + ret[i].x);
                        ++failures;
                    }
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }
}

