/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.rmiiiop.objecttests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloJAVAIDLObjectImpl;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloJAVAIDLObjectIntf;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloJAVAIDLObjectIntfHelper;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloRMIIIOPObjectImpl;
import com.sun.ts.tests.rmiiiop.ee.objecttests.HelloRMIIIOPObjectIntf;
import com.sun.ts.tests.rmiiiop.ee.objecttests.TestBean;
import com.sun.ts.tests.rmiiiop.ee.objecttests.TestBeanHome;
import java.rmi.Remote;
import java.util.Properties;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private TestBean beanRef2 = null;
    private TestBeanHome beanHome2 = null;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private HelloRMIIIOPObjectImpl rmiiiopObj = null;
    private HelloJAVAIDLObjectIntf javaidlObj = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            this.beanRef = this.beanHome.create(p);
            this.setupJavaidlRmiiiopObjects(p);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    private void setupJavaidlRmiiiopObjects(Properties p) throws Exception {
        HelloJAVAIDLObjectImpl helloImpl = null;
        ORB orb = null;
        POA rootPOA = null;
        Object ref = null;
        TestUtil.logMsg((String)"Looking up the ORB and getting RootPOA");
        orb = (ORB)this.nctx.lookup("java:comp/ORB");
        rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        rootPOA.the_POAManager().activate();
        TestUtil.logMsg((String)"Create javaidl object: HelloJAVAIDLObjectImpl");
        helloImpl = new HelloJAVAIDLObjectImpl();
        TestUtil.logMsg((String)"Get the reference from the servant");
        ref = rootPOA.servant_to_reference((Servant)helloImpl);
        TestUtil.logMsg((String)"Narrow the javaidl object reference");
        this.javaidlObj = HelloJAVAIDLObjectIntfHelper.narrow(ref);
        TestUtil.logMsg((String)"Create rmiiiop object: HelloRMIIIOPObjectImpl");
        this.rmiiiopObj = new HelloRMIIIOPObjectImpl();
        TestUtil.logMsg((String)"Get HelloRMIIIOPObjectImpl Stub object");
        Stub rmiiiopStub = (Stub)PortableRemoteObject.toStub((Remote)this.rmiiiopObj);
        TestUtil.logMsg((String)"Connect/Attach HelloRMIIIOPObjectImpl object to ORB");
        rmiiiopStub.connect(orb);
        this.rmiiiopObj.passProperties(p);
    }

    public void cleanup() throws EETest.Fault {
        this.rmiiiopObj = null;
        this.javaidlObj = null;
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void RmiiiopObjectTest01() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"RmiiiopObjectTest01");
            TestUtil.logMsg((String)"Pass a rmiiiop object to TestBeanEJB");
            pass = this.beanRef.pass_a_rmiiiop_object(this.rmiiiopObj);
            if (!pass) {
                TestUtil.logErr((String)"Could not pass a rmiiiop object to TestBeanEJB");
                TestUtil.logErr((String)"Wrong return, got false, expected true");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest01 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RmiiiopObjectTest02() throws EETest.Fault {
        boolean pass;
        block16: {
            pass = true;
            String expStr = "Hello from HelloRMIIIOPObjectImpl";
            try {
                TestUtil.logTrace((String)"RmiiiopObjectTest02");
                TestUtil.logMsg((String)"Return a rmiiiop object from TestBeanEJB");
                HelloRMIIIOPObjectIntf rmiiiopRef = this.beanRef.return_a_rmiiiop_object(this.rmiiiopObj);
                if (rmiiiopRef == null) {
                    TestUtil.logErr((String)"Could not return a rmiiiop object (ref is null)");
                    pass = false;
                    break block16;
                }
                try {
                    TestUtil.logMsg((String)"Invoke methods on the rmiiiop object reference");
                    String hello = rmiiiopRef.hello();
                    if (!hello.equals(expStr)) {
                        TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                        TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                        pass = false;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unable to invoke methods of the rmiiiop object");
                    TestUtil.printStackTrace((Throwable)e);
                    TestUtil.logErr((String)e.toString());
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logErr((String)e.toString());
                pass = false;
            }
            finally {
                try {
                    this.beanRef.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest02 failed");
        }
    }

    public void RmiiiopObjectTest03() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"RmiiiopObjectTest03");
            TestUtil.logMsg((String)"Pass a EJBHome object to rmiiiop object");
            pass = this.rmiiiopObj.passEjbHome(this.beanHome);
            if (!pass) {
                TestUtil.logErr((String)"Could not pass a EJBHome object to rmiiiop object");
                TestUtil.logErr((String)"Wrong return, got false, expected true");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest03 failed");
        }
    }

    public void RmiiiopObjectTest04() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"RmiiiopObjectTest04");
            TestUtil.logMsg((String)"Pass a EJBObject object to rmiiiop object");
            pass = this.rmiiiopObj.passEjbObject(this.beanRef);
            if (!pass) {
                TestUtil.logErr((String)"Could not pass a EJBObject object to rmiiiop object");
                TestUtil.logErr((String)"Wrong return, got false, expected true");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest04 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RmiiiopObjectTest05() throws EETest.Fault {
        boolean pass;
        block16: {
            pass = true;
            String expStr = "Hello from TestBeanEJB";
            try {
                TestUtil.logTrace((String)"RmiiiopObjectTest05");
                TestUtil.logMsg((String)"Return a EJBHome object from a rmiiiop object");
                this.beanHome2 = this.rmiiiopObj.returnEjbHome(this.beanHome);
                if (this.beanHome2 == null) {
                    TestUtil.logErr((String)"Could not return EJBHome object (ref is null)");
                    pass = false;
                    break block16;
                }
                try {
                    TestUtil.logMsg((String)"Invoke methods on the EJBHome object reference");
                    TestUtil.logMsg((String)"Create EJB instance from EJBHome object reference");
                    this.beanRef2 = this.beanHome2.create(this.props);
                    String hello = this.beanRef2.hello();
                    if (!hello.equals(expStr)) {
                        TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                        TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                        pass = false;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unable to invoke methods of the EJBHome object");
                    TestUtil.printStackTrace((Throwable)e);
                    TestUtil.logErr((String)e.toString());
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logErr((String)e.toString());
                pass = false;
            }
            finally {
                try {
                    this.beanRef.remove();
                    this.beanRef2.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest05 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RmiiiopObjectTest06() throws EETest.Fault {
        boolean pass;
        block16: {
            pass = true;
            String expStr = "Hello from TestBeanEJB";
            try {
                TestUtil.logTrace((String)"RmiiiopObjectTest06");
                TestUtil.logMsg((String)"Return a EJBObject object from a rmiiiop object");
                this.beanRef = this.rmiiiopObj.returnEjbObject(this.beanRef);
                if (this.beanRef == null) {
                    TestUtil.logErr((String)"Could not return EJBObject object (ref is null)");
                    pass = false;
                    break block16;
                }
                try {
                    TestUtil.logMsg((String)"Invoke methods on the EJBObject object reference");
                    String hello = this.beanRef.hello();
                    if (!hello.equals(expStr)) {
                        TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                        TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                        pass = false;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unable to invoke methods of the EJBObject object");
                    TestUtil.printStackTrace((Throwable)e);
                    TestUtil.logErr((String)e.toString());
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logErr((String)e.toString());
                pass = false;
            }
            finally {
                try {
                    this.beanRef.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("RmiiiopObjectTest06 failed");
        }
    }

    public void JavaidlObjectTest01() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"JavaidlObjectTest01");
            TestUtil.logMsg((String)"Pass a javaidl object to TestBeanEJB");
            pass = this.beanRef.pass_a_javaidl_object(this.javaidlObj);
            if (!pass) {
                TestUtil.logErr((String)"Could not pass a javaidl object to TestBeanEJB");
                TestUtil.logErr((String)"Wrong return, got false, expected true");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("JavaidlObjectTest01 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void JavaidlObjectTest02() throws EETest.Fault {
        boolean pass;
        block16: {
            pass = true;
            String expStr = "Hello from HelloJAVAIDLObjectImpl";
            try {
                TestUtil.logTrace((String)"JavaidlObjectTest02");
                TestUtil.logMsg((String)"Return a javaidl object from TestBeanEJB");
                HelloJAVAIDLObjectIntf javaidlRef = this.beanRef.return_a_javaidl_object(this.javaidlObj);
                if (javaidlRef == null) {
                    TestUtil.logErr((String)"Could not return javaidl object (ref is null)");
                    pass = false;
                    break block16;
                }
                try {
                    TestUtil.logMsg((String)"Invoke methods on the javaidl object reference");
                    String hello = javaidlRef.hello();
                    if (!hello.equals(expStr)) {
                        pass = false;
                        TestUtil.logErr((String)("Wrong message, got [" + hello + "], expected [" + expStr + "]"));
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unable to invoke methods of the javaidl object");
                    TestUtil.printStackTrace((Throwable)e);
                    TestUtil.logErr((String)e.toString());
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logErr((String)e.toString());
                pass = false;
            }
            finally {
                try {
                    this.beanRef.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("JavaidlObjectTest02 failed");
        }
    }
}

