/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;

public class FlowTransitioningTests
extends ServiceEETest {
    private JobOperatorBridge jobOp = null;

    public void testFlowTransitionToStep() throws EETest.Fault {
        String METHOD = "testFlowTransitionToStep";
        TestUtil.logTrace((String)METHOD);
        try {
            String[] transitionList = new String[]{"flow1step1", "flow1step2", "flow1step3", "step1"};
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_step", null);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            String[] jobTransitionList = jobExec.getExitStatus().split(",");
            AssertionUtils.assertWithMessage("transitioned to exact number of steps", transitionList.length, jobTransitionList.length);
            for (int i = 0; i < jobTransitionList.length; ++i) {
                AssertionUtils.assertWithMessage("Flow transitions", transitionList[i], jobTransitionList[i].trim());
            }
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    public void testFlowTransitionToStepOutOfScope() throws EETest.Fault {
        String METHOD = " testFlowTransitionToStepOutOfScope";
        TestUtil.logTrace((String)METHOD);
        try {
            boolean seenException = false;
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_step_out_of_scope", null);
            }
            catch (JobStartException e) {
                TestUtil.logMsg((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                TestUtil.logMsg((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    public void testFlowTransitionToDecision() throws EETest.Fault {
        String METHOD = "testFlowTransitionToDecision";
        TestUtil.logTrace((String)METHOD);
        try {
            String exitStatus = "ThatsAllFolks";
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_decision", null);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job Exit Status is from decider", exitStatus, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    public void testFlowTransitionWithinFlow() throws EETest.Fault {
        String METHOD = "testFlowTransitionWithinFlow";
        TestUtil.logTrace((String)METHOD);
        try {
            String[] transitionList = new String[]{"flow1step1", "flow1step2", "flow1step3"};
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_within_flow", null);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            String[] jobTransitionList = jobExec.getExitStatus().split(",");
            AssertionUtils.assertWithMessage("transitioned to exact number of steps", transitionList.length, jobTransitionList.length);
            for (int i = 0; i < jobTransitionList.length; ++i) {
                AssertionUtils.assertWithMessage("Flow transitions", transitionList[i], jobTransitionList[i].trim());
            }
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    public void afterTest() {
        this.jobOp = null;
    }
}

