/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.specialized.BatchletUsingStepContextImpl;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class ExecuteTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(ExecuteTests.class.getName());
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ExecuteTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void testMyStepContextBatchlet() throws EETest.Fault {
        String METHOD = "testMyStepContextBatchlet";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("test_batchlet_stepCtx");
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecuteTests.handleException(METHOD, e);
        }
    }
}

