/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueSession;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;

public class ClosedQueueSessionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueSession.ClosedQueueSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueSessionTests theTests = new ClosedQueueSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type, String user, String password) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logMsg("Closing QueueSession");
            this.tool.getDefaultQueueSession().close();
        } else if (type == 15) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultConnection().start();
            this.logMsg("Closing Session");
            this.tool.getDefaultSession().close();
        } else {
            this.logErr("Unspecified type");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing QueueConnection");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedQueueSessionCloseTest() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Before create and close");
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to call close on closed session.");
            this.tool.getDefaultQueueSession().close();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("fault " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCloseTest");
        }
    }

    public void closedQueueSessionCreateBrowserTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateBrowserTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            throw new EETest.Fault("closedQueueSessionCreateBrowserTest", e);
        }
    }

    public void closedQueueSessionCreateBrowserMsgSelectorTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateBrowserMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateBrowserMsgSelectorTest");
        }
    }

    public void closedQueueSessionCreateQueueTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create queue with closed session.");
            try {
                Queue queue = this.tool.getDefaultQueueSession().createQueue(testName);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateQueueTest");
        }
    }

    public void closedQueueSessionCreateReceiverTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateReceiverTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateReceiverTest");
        }
    }

    public void closedQueueSessionCreateReceiverMsgSelectorTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateReceiverMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateReceiverMsgSelectorTest");
        }
    }

    public void closedQueueSessionCreateSenderTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateSenderTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Sender with closed session.");
            try {
                QueueSender queueSender = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateSenderTest");
        }
    }

    public void closedQueueSessionCreateTempQueueTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateTempQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TemporaryQueue with closed session.");
            try {
                TemporaryQueue temporaryQueue = this.tool.getDefaultQueueSession().createTemporaryQueue();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateTempQueueTest");
        }
    }

    public void closedQueueSessionCreateMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultQueueSession().createMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateMessageTest");
        }
    }

    public void closedQueueSessionCreateBytesMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateBytesMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateBytesMessageTest");
        }
    }

    public void closedQueueSessionCreateMapMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateMapMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultQueueSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateMapMessageTest");
        }
    }

    public void closedQueueSessionCreateObjectMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateObjectMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage();
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + m));
                }
                TestUtil.logTrace((String)"FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateObjectMessageTest");
        }
    }

    public void closedQueueSessionCreateObject2MessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateObject2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + m));
                }
                TestUtil.logTrace((String)"FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateObject2MessageTest");
        }
    }

    public void closedQueueSessionCreateStreamMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateStreamMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultQueueSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateStreamMessageTest");
        }
    }

    public void closedQueueSessionCreateTextMessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateTextMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateTextMessageTest");
        }
    }

    public void closedQueueSessionCreateText2MessageTest() throws EETest.Fault {
        String testName = "closedQueueSessionCreateText2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionCreateText2MessageTest");
        }
    }

    public void closedQueueSessionReceiverCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionReceiverCloseTest", e);
        }
    }

    public void closedQueueSessionGetMessageSelectorTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetMessageSelectorTest", e);
        }
    }

    public void closedQueueSessionReceiveTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionReceiveTest", e);
        }
    }

    public void closedQueueSessionReceiveTimeoutTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionReceiveTimeoutTest", e);
        }
    }

    public void closedQueueSessionReceiveNoWaitTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionReceiveNoWaitTest", e);
        }
    }

    public void closedQueueSessionReceiverGetQueueTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionReceiverGetQueueTest", e);
        }
    }

    public void closedQueueSessionSenderCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSenderCloseTest", e);
        }
    }

    public void closedQueueSessionGetDeliveryModeTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetDeliveryModeTest", e);
        }
    }

    public void closedQueueSessionGetDisableMessageIDTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSessionGetDisableMessageTimestampTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSessionGetPriorityTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetPriorityTest", e);
        }
    }

    public void closedQueueSessionGetTimeToLiveTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionGetTimeToLiveTest", e);
        }
    }

    public void closedQueueSessionSetDeliveryModeTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSetDeliveryModeTest", e);
        }
    }

    public void closedQueueSessionSetDisableMessageIDTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSessionSetDisableMessageTimestampTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSessionSetPriorityTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSetPriorityTest", e);
        }
    }

    public void closedQueueSessionSetTimeToLiveTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSetTimeToLiveTest", e);
        }
    }

    public void closedQueueSessionSenderGetQueueTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSenderGetQueueTest", e);
        }
    }

    public void closedQueueSessionSend1Test() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSend1Test", e);
        }
    }

    public void closedQueueSessionSend2Test() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSend2Test", e);
        }
    }

    public void closedQueueSessionSend3Test() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSend3Test", e);
        }
    }

    public void closedQueueSessionSend4Test() throws EETest.Fault {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logErr("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new EETest.Fault("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueSessionSend4Test", e);
        }
    }

    public void closedQueueSessionRecoverTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultQueueSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault("closedQueueSessionRecoverTest");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"closedQueueSessionRecoverTest failed: ", (Throwable)e);
            throw new EETest.Fault("closedQueueSessionRecoverTest", e);
        }
    }

    public void closedSessionRecoverTest() throws EETest.Fault {
        String testName = "closedSessionRecoverTest";
        try {
            this.createAndCloseSession(15, this.user, this.password);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void closedQueueSessionCommitTest() throws EETest.Fault {
        String testName = "closedQueueSessionCommitTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call commit with closed session.");
            try {
                this.tool.getDefaultQueueSession().commit();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void closedQueueSessionGetTransactedTest() throws EETest.Fault {
        String testName = "closedQueueSessionGetTransactedTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultQueueSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void closedQueueSessionRollbackTest() throws EETest.Fault {
        String testName = "closedQueueSessionRollbackTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultQueueSession().rollback();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new EETest.Fault(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueSessionRollbackTest");
        }
    }
}

