/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.orbtests;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.rmiiiop.ee.orbtests.HelloRMIIIOPObjectIntf;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class TestBeanEJB
implements SessionBean {
    private static final String orbLookup = "java:comp/ORB";
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private HelloRMIIIOPObjectIntf rmiiiopRef = null;
    private ORB orb = null;
    private Object obj = null;
    private TSNamingContext nctx = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.nctx = new TSNamingContext();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public String hello() {
        return "Hello from TestBeanEJB";
    }

    public boolean test1(String ior) {
        boolean pass = true;
        String expStr = "Hello from HelloRMIIIOPObjectImpl";
        try {
            TestUtil.logTrace((String)"test1");
            TestUtil.logMsg((String)"Create an ORB instance using [ORB.init()]");
            this.orb = ORB.init((String[])new String[0], null);
            TestUtil.logMsg((String)("ORB = " + this.orb));
            if (this.orb == null) {
                TestUtil.logErr((String)"Unable to create an ORB instance using [ORB.init()]");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Verify some basic ORB functionality");
                TestUtil.logMsg((String)("IOR = " + ior));
                TestUtil.logMsg((String)"Convert stringified IOR to a CORBA object");
                this.obj = this.orb.string_to_object(ior);
                TestUtil.logMsg((String)"Narrow CORBA object to interface HelloRMIIIOPObjectIntf");
                this.rmiiiopRef = (HelloRMIIIOPObjectIntf)PortableRemoteObject.narrow((java.lang.Object)this.obj, HelloRMIIIOPObjectIntf.class);
                TestUtil.logMsg((String)"Call hello method on interface HelloRMIIIOPObjectIntf");
                String hello = this.rmiiiopRef.hello();
                TestUtil.logMsg((String)"Verify the method call");
                if (!hello.equals(expStr)) {
                    TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                    TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        return pass;
    }

    public boolean test2(String ior) {
        boolean pass = true;
        String expStr = "Hello from HelloRMIIIOPObjectImpl";
        try {
            TestUtil.logTrace((String)"test2");
            TestUtil.logMsg((String)"Lookup ORB instance in JNDI namespace under [java:comp/ORB]");
            try {
                this.orb = (ORB)this.nctx.lookup(orbLookup);
                TestUtil.logMsg((String)("ORB = " + this.orb));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.orb = null;
            }
            if (this.orb == null) {
                TestUtil.logErr((String)"Unable to lookup ORB instance in JNDI namespace");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Verify some basic ORB functionality");
                TestUtil.logMsg((String)("IOR = " + ior));
                TestUtil.logMsg((String)"Convert stringified IOR to a CORBA object");
                this.obj = this.orb.string_to_object(ior);
                TestUtil.logMsg((String)"Narrow CORBA object to interface HelloRMIIIOPObjectIntf");
                this.rmiiiopRef = (HelloRMIIIOPObjectIntf)PortableRemoteObject.narrow((java.lang.Object)this.obj, HelloRMIIIOPObjectIntf.class);
                TestUtil.logMsg((String)"Call hello method on interface HelloRMIIIOPObjectIntf");
                String hello = this.rmiiiopRef.hello();
                TestUtil.logMsg((String)"Verify the method call");
                if (!hello.equals(expStr)) {
                    TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                    TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        return pass;
    }
}

