/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.mdb.modernconnector.connector;

import com.sun.ts.tests.ejb32.mdb.modernconnector.connector.EventMonitor;
import com.sun.ts.tests.ejb32.mdb.modernconnector.connector.EventMonitorConfig;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class EventMonitorAdapter
implements ResourceAdapter {
    private Map<EventMonitorConfig, ActivatedEndpoint> endpoints = new HashMap<EventMonitorConfig, ActivatedEndpoint>();

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
    }

    public void stop() {
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        EventMonitorConfig config = (EventMonitorConfig)activationSpec;
        ActivatedEndpoint activatedEndpoint = new ActivatedEndpoint(messageEndpointFactory, config);
        this.endpoints.put(config, activatedEndpoint);
        Thread thread = new Thread(activatedEndpoint);
        thread.setDaemon(true);
        thread.start();
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.endpoints.remove(activationSpec);
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        return new XAResource[0];
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EventMonitorAdapter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        EventMonitorAdapter that = (EventMonitorAdapter)obj;
        return true;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    private static class ActivatedEndpoint
    implements Runnable {
        private final MessageEndpointFactory factory;
        private final EventMonitorConfig config;
        private final Map<String, Method> eventConsumers = new HashMap<String, Method>();

        private ActivatedEndpoint(MessageEndpointFactory factory, EventMonitorConfig config) {
            Method[] methods;
            this.factory = factory;
            this.config = config;
            for (Method method : methods = factory.getEndpointClass().getMethods()) {
                if (!method.isAnnotationPresent(EventMonitor.class)) continue;
                this.eventConsumers.put(method.getAnnotation(EventMonitor.class).priority(), method);
            }
        }

        private static void pause() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void produceEvent(MessageEndpoint endpoint, String priority, String event) throws Exception {
            Method consumer = this.eventConsumers.get(priority);
            endpoint.beforeDelivery(consumer);
            try {
                consumer.invoke((Object)endpoint, event);
            }
            finally {
                endpoint.afterDelivery();
            }
        }

        @Override
        public void run() {
            ActivatedEndpoint.pause();
            try {
                MessageEndpoint endpoint = this.factory.createEndpoint(null);
                try {
                    this.produceEvent(endpoint, "high", "One " + this.config.getCategory() + " typed high-priority event");
                    this.produceEvent(endpoint, "normal", "One " + this.config.getCategory() + " typed normal-priority event");
                    this.produceEvent(endpoint, "low", "One " + this.config.getCategory() + " typed low-priority event");
                }
                finally {
                    endpoint.release();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

