/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ClassificationScheme;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRClient
extends JAXRCommonClient {
    JAXR_Util util = null;
    String classificationName = "Book Publishers";
    String classificationValue = "51113";
    Classification classification = null;
    ClassificationScheme scheme = null;
    String schemeName = "CTSxxx";
    String schemeDescription = "North American Regions";
    String name = "classificationScheme";
    Concept concept = null;
    String conceptNameAK = "Alaska";
    String conceptValueAK = "US-AK";
    String conceptNameCA = "California";
    String conceptValueCA = "US-CA";
    String conceptNameUS = "United States";
    String conceptValueUS = "US";
    String conceptName = "North America";
    String conceptValue = "NA";

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void classificationScheme_isExternalTrueTest() throws EETest.Fault {
        String testName = "classificationScheme_isExternalTrueTest";
        boolean pass = false;
        try {
            this.createExternalClassificationObject();
            this.debug.add("Create an external Classification \n");
            if (this.scheme.isExternal()) {
                pass = true;
                this.debug.add("Success! isExternal returned: " + this.scheme.isExternal());
            } else {
                this.debug.add("FAIL: isExternal returned " + this.scheme.isExternal());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classificationScheme_isExternalFalseTest() throws EETest.Fault {
        String testName = "classificationScheme_isExternalFalseTest";
        boolean pass = false;
        try {
            this.createInternalClassificationObject();
            this.debug.add("Created an internal Classification \n");
            if (!this.scheme.isExternal()) {
                pass = true;
                this.debug.add("Success! isExternal returned: " + this.scheme.isExternal());
            } else {
                this.debug.add("FAIL: isExternal returned " + this.scheme.isExternal());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void classificationScheme_addChildConceptTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block14: {
            testName = "classificationScheme_addChildConceptTest";
            pass = false;
            Concept childConcept = null;
            this.createInternalClassificationObject();
            childConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameAK, this.conceptValueAK);
            this.debug.add("Child concept count before adding a child is: " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.addChildConcept(childConcept);
            this.debug.add("Child concept count before adding a child is: " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            if (concepts == null) {
                throw new EETest.Fault(testName + "Error- no concepts for getChildren!!");
            }
            this.debug.add("Concept count is: " + concepts.size());
            for (Concept this.concept : concepts) {
                this.debug.add("Concept value is " + this.concept.getValue() + "\n");
                if (this.concept.getValue().equals(this.conceptValueAK)) {
                    pass = true;
                    continue;
                }
                this.debug.add("Error: unexpected child returned\n");
                this.debug.add("Childs value is " + this.concept.getValue() + "\n");
            }
            try {
                this.scheme.removeChildConcept(childConcept);
            }
            catch (JAXRException ex) {
                TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                TestUtil.printStackTrace((Throwable)ex);
            }
            break block14;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.scheme.removeChildConcept(childConcept);
                    }
                    catch (JAXRException ex) {
                        TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                        TestUtil.printStackTrace((Throwable)ex);
                    }
                    throw throwable;
                }
                try {
                    this.scheme.removeChildConcept(childConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void classificationScheme_removeChildConceptTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block13: {
            testName = "classificationScheme_removeChildConceptTest";
            pass = false;
            Concept caConcept = null;
            this.createInternalClassificationObject();
            Concept akConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameAK, this.conceptValueAK);
            caConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameCA, this.conceptValueCA);
            Collection concepts = new ArrayList<Concept>();
            concepts.add(akConcept);
            concepts.add(caConcept);
            this.debug.add("Child concept count before adding a child is: " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.addChildConcepts(concepts);
            this.debug.add("Child concept count after adding a 2 child concepts is: " + this.scheme.getChildConceptCount() + "\n");
            this.debug.add("remove 1 - Alaska , 1 should be left - California \n");
            this.scheme.removeChildConcept(akConcept);
            concepts = this.scheme.getChildrenConcepts();
            if (concepts == null) {
                throw new EETest.Fault(testName + "Error- no concepts for getChildren!!");
            }
            this.debug.add("Concept count is: " + concepts.size());
            for (Concept this.concept : concepts) {
                this.debug.add("Concept value is " + this.concept.getValue() + "\n");
                if (!this.concept.getValue().equals(this.conceptValueCA)) continue;
                pass = true;
            }
            try {
                this.scheme.removeChildConcept(caConcept);
            }
            catch (JAXRException ex) {
                TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                TestUtil.printStackTrace((Throwable)ex);
            }
            break block13;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.scheme.removeChildConcept(caConcept);
                    }
                    catch (JAXRException ex) {
                        TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                        TestUtil.printStackTrace((Throwable)ex);
                    }
                    throw throwable;
                }
                try {
                    this.scheme.removeChildConcept(caConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcept: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void classificationScheme_removeChildConceptsTest() throws EETest.Fault {
        String testName = "classificationScheme_removeChildConceptsTest";
        boolean pass = true;
        Collection concepts = new ArrayList<Concept>();
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            this.debug.add("The child count after createClassificationScheme is: " + this.scheme.getChildConceptCount() + "\n");
            Concept akConcept = (Concept)this.blm.createObject("Concept");
            akConcept.setName(this.blm.createInternationalString(this.conceptNameAK));
            akConcept.setValue(this.conceptValueAK);
            Concept caConcept = (Concept)this.blm.createObject("Concept");
            caConcept.setName(this.blm.createInternationalString(this.conceptNameCA));
            caConcept.setValue(this.conceptValueCA);
            concepts.add(akConcept);
            concepts.add(caConcept);
            this.debug.add("The count before child concepts added to scheme is: " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.addChildConcepts(concepts);
            this.debug.add("Added 2 child concepts -for alaska and california \n");
            this.debug.add(" verify the count. The count is : " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.removeChildConcepts(concepts);
            concepts = this.scheme.getChildrenConcepts();
            this.debug.add("Removed the 2 child concepts for alaska and california \n");
            this.debug.add("Concept count is: " + concepts.size());
            if (concepts.size() != 0) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classificationScheme_addGetChildConceptsTest() throws EETest.Fault {
        String testName = "classificationScheme_addGetChildConceptsTest";
        boolean pass = false;
        Object childConcept = null;
        ArrayList<Concept> childConcepts = new ArrayList<Concept>();
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept akConcept = (Concept)this.blm.createObject("Concept");
            akConcept.setName(this.blm.createInternationalString(this.conceptNameAK));
            akConcept.setValue(this.conceptValueAK);
            childConcepts.add(akConcept);
            Concept caConcept = (Concept)this.blm.createObject("Concept");
            caConcept.setName(this.blm.createInternationalString(this.conceptNameCA));
            caConcept.setValue(this.conceptValueCA);
            childConcepts.add(caConcept);
            this.debug.add("Children concept count before adding a child is: " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.addChildConcepts(childConcepts);
            this.debug.add("Add child concepts for Alaska and California to scheme \n");
            this.debug.add("Verify the concept count. Scheme.getChildConceptCount() returns: " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            if (concepts == null) {
                throw new EETest.Fault(testName + "Error- no concepts for getChildren!!");
            }
            this.debug.add("Concept count returned from getChildrenConcepts is: " + concepts.size());
            Iterator iter = concepts.iterator();
            int childCount = 0;
            while (iter.hasNext()) {
                this.concept = (Concept)iter.next();
                this.debug.add("Concept value is " + this.concept.getValue() + "\n");
                if (!this.concept.getValue().equals(this.conceptValueAK) && !this.concept.getValue().equals(this.conceptValueCA)) continue;
                ++childCount;
            }
            this.debug.add("Child concept count is: " + childCount + "\n");
            if (childCount == 2) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.scheme.removeChildConcepts(childConcepts);
            }
            catch (JAXRException ex) {
                TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                TestUtil.printStackTrace((Throwable)ex);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classificationScheme_getChildConceptCountTest() throws EETest.Fault {
        String testName = "classificationScheme_getChildConceptCountTest";
        boolean pass = false;
        ArrayList<Concept> childConcepts = new ArrayList<Concept>();
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept akConcept = (Concept)this.blm.createObject("Concept");
            akConcept.setName(this.blm.createInternationalString(this.conceptNameAK));
            akConcept.setValue(this.conceptValueAK);
            childConcepts.add(akConcept);
            Concept caConcept = (Concept)this.blm.createObject("Concept");
            caConcept.setName(this.blm.createInternationalString(this.conceptNameCA));
            caConcept.setValue(this.conceptValueCA);
            childConcepts.add(caConcept);
            this.debug.add("Children concept count before adding a children is: " + this.scheme.getChildConceptCount() + "\n");
            this.scheme.addChildConcepts(childConcepts);
            this.debug.add("getChildConceptCount after adding 2 children is " + this.scheme.getChildConceptCount() + "\n");
            this.debug.add("Child concept after adding a children is: " + this.scheme.getChildConceptCount() + "\n");
            if (this.scheme.getChildConceptCount() == 2) {
                pass = true;
            } else {
                this.debug.add("ChildConceptCount got " + this.scheme.getChildConceptCount());
                this.debug.add("ChildConceptCount expected 2");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.scheme.removeChildConcepts(childConcepts);
            }
            catch (JAXRException ex) {
                TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                TestUtil.printStackTrace((Throwable)ex);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void classificationScheme_getDescendantConceptsTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block15: {
            Concept usConcept;
            ArrayList<Concept> childConcepts;
            block14: {
                testName = "classificationScheme_getDescendantConceptsTest";
                pass = false;
                int testCount = 3;
                childConcepts = new ArrayList<Concept>();
                usConcept = null;
                this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
                usConcept = (Concept)this.blm.createObject("Concept");
                usConcept.setName(this.blm.createInternationalString(this.conceptNameUS));
                usConcept.setValue(this.conceptValueUS);
                Concept akConcept = (Concept)this.blm.createObject("Concept");
                akConcept.setName(this.blm.createInternationalString(this.conceptNameAK));
                akConcept.setValue(this.conceptValueAK);
                Concept caConcept = (Concept)this.blm.createObject("Concept");
                caConcept.setName(this.blm.createInternationalString(this.conceptNameCA));
                caConcept.setValue(this.conceptValueCA);
                childConcepts.add(caConcept);
                childConcepts.add(akConcept);
                usConcept.addChildConcepts(childConcepts);
                this.scheme.addChildConcept(usConcept);
                this.debug.add("Child concept after adding a children is: " + this.scheme.getChildConceptCount() + "\n");
                Collection concepts = this.scheme.getDescendantConcepts();
                if (concepts == null) {
                    throw new EETest.Fault(testName + "Error- no concepts returned from getDescendantConcepts!!");
                }
                Iterator iter = concepts.iterator();
                int descendantCount = 0;
                while (iter.hasNext()) {
                    this.concept = (Concept)iter.next();
                    this.debug.add("Concept value is " + this.concept.getValue() + "\n");
                    if (!this.concept.getValue().equals(this.conceptValueAK) && !this.concept.getValue().equals(this.conceptValueCA) && !this.concept.getValue().equals(this.conceptValueUS)) continue;
                    ++descendantCount;
                }
                if (descendantCount == testCount) {
                    pass = true;
                    break block14;
                }
                this.debug.add("Descendant count is " + descendantCount + "\n");
                this.debug.add("Expected Descendant count is " + testCount + "\n");
            }
            try {
                this.scheme.removeChildConcepts(childConcepts);
                this.scheme.removeChildConcept(usConcept);
            }
            catch (JAXRException ex) {
                TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                TestUtil.printStackTrace((Throwable)ex);
            }
            break block15;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.scheme.removeChildConcepts(childConcepts);
                        this.scheme.removeChildConcept(usConcept);
                    }
                    catch (JAXRException ex) {
                        TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                        TestUtil.printStackTrace((Throwable)ex);
                    }
                    throw throwable;
                }
                try {
                    this.scheme.removeChildConcepts(childConcepts);
                    this.scheme.removeChildConcept(usConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void classificationScheme_getValueTypeTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block16: {
            testName = "classificationScheme_getValueTypeTest";
            pass = false;
            Concept childConcept = null;
            int providerlevel = 0;
            try {
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                this.debug.add("Level 0 Providers must throw an UnsupportedCapabilityException for getValueType\n");
                this.debug.add("This provider report a Capability Level of " + providerlevel + "\n");
                this.createInternalClassificationObject();
                childConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameAK, this.conceptValueAK);
                this.scheme.addChildConcept(childConcept);
                int value = this.scheme.getValueType();
                if (providerlevel > 0) {
                    pass = true;
                }
                try {
                    this.scheme.removeChildConcept(childConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel != 0) throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
                this.debug.add(" Call to getValueType threw UnsupportedCapabilityException as expected\n");
                pass = true;
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            finally {
                try {
                    this.scheme.removeChildConcept(childConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void classificationScheme_setValueTypeTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block22: {
            testName = "classificationScheme_setValueTypeTest";
            Concept childConcept = null;
            int providerlevel = 0;
            pass = true;
            try {
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                this.debug.add("Level 0 Providers must throw an UnsupportedCapabilityException for setValueType\n");
                this.debug.add("This provider report a Capability Level of " + providerlevel + "\n");
                this.createInternalClassificationObject();
                childConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameAK, this.conceptValueAK);
                this.scheme.addChildConcept(childConcept);
                this.scheme.setValueType(0);
                if (providerlevel == 0) {
                    throw new EETest.Fault(testName + " UnsupportedCapabilityException was not thrown by level 0 provider");
                }
                if (this.scheme.getValueType() != 0) {
                    this.debug.add("Did not returned expected value \n");
                    pass = false;
                } else {
                    this.debug.add("Returned expected value - ClassificationScheme.VALUE_TYPE_UNIQUE\n");
                }
                this.scheme.setValueType(1);
                if (this.scheme.getValueType() != 1) {
                    this.debug.add("Did not returned expected value \n");
                    pass = false;
                } else {
                    this.debug.add("Returned expected value - ClassificationScheme.VALUE_TYPE_EMBEDDED_PATH\n");
                }
                this.scheme.setValueType(2);
                if (this.scheme.getValueType() != 2) {
                    this.debug.add("Did not returned expected value \n");
                    pass = false;
                } else {
                    this.debug.add("Returned expected value - ClassificationScheme.VALUE_TYPE_NON_UNIQUE\n");
                }
                try {
                    this.scheme.removeChildConcept(childConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel != 0) throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
                this.debug.add(" Call to getValueType threw UnsupportedCapabilityException as expected\n");
                pass = true;
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            finally {
                try {
                    this.scheme.removeChildConcept(childConcept);
                }
                catch (JAXRException ex) {
                    TestUtil.logErr((String)("failed to remove ChildConcepts: " + ex.getMessage()));
                    TestUtil.printStackTrace((Throwable)ex);
                }
            }
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    private void createExternalClassificationObject() throws JAXRException {
        this.scheme = null;
        this.classification = null;
        this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
        this.classification = this.blm.createClassification(this.scheme, this.classificationName, this.classificationValue);
        this.classification.setClassificationScheme(this.scheme);
    }

    private void createInternalClassificationObject() throws JAXRException {
        this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
        this.concept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptName, this.conceptValue);
        this.classification = this.blm.createClassification(this.concept);
    }
}

